/*
 * Decompiled with CFR 0.152.
 */
package io.bitexpress.topia.commons.basic.jackson;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.lang3.exception.ContextedRuntimeException;

public class JacksonObjectFactory {
    public static <T> T createObject(ObjectMapper objectMapper, Class<T> objectType, InputStream inputStream) {
        try {
            return (T)objectMapper.readValue(inputStream, objectType);
        }
        catch (Exception e) {
            throw new ContextedRuntimeException((Throwable)e);
        }
    }

    public static <T> List<T> createObjectList(ObjectMapper objectMapper, Class<T> objectType, InputStream inputStream) {
        try {
            TypeFactory typeFactory = objectMapper.getTypeFactory();
            CollectionType collectionType = typeFactory.constructCollectionType(List.class, objectType);
            return (List)objectMapper.readValue(inputStream, (JavaType)collectionType);
        }
        catch (Exception e) {
            throw new ContextedRuntimeException((Throwable)e);
        }
    }
}

