/*
 * Decompiled with CFR 0.152.
 */
package io.bitexpress.topia.commons.basic.joda.converter;

import java.math.BigDecimal;
import jodd.bean.BeanUtil;
import org.joda.money.CurrencyUnit;
import org.joda.money.Money;

public class MoneyAccessor {
    private MoneyAccessor() {
    }

    public static Money getValue(Object bean, String propertyName) {
        BigDecimal amount = (BigDecimal)BeanUtil.silent.getProperty(bean, propertyName + "Amount");
        String unit = (String)BeanUtil.silent.getProperty(bean, propertyName + "Unit");
        if (amount != null && unit != null) {
            return Money.of((CurrencyUnit)CurrencyUnit.of((String)unit), (BigDecimal)amount);
        }
        return null;
    }

    public static void setValue(Object bean, String propertyName, Money value) {
        String amountPropertyName = propertyName + "Amount";
        String unitPropertyName = propertyName + "Unit";
        if (value != null) {
            BeanUtil.pojo.setProperty(bean, amountPropertyName, (Object)value.getAmount());
            BeanUtil.pojo.setProperty(bean, unitPropertyName, (Object)value.getCurrencyUnit().getCode());
        } else {
            BeanUtil.pojo.setProperty(bean, amountPropertyName, null);
            BeanUtil.pojo.setProperty(bean, unitPropertyName, null);
        }
    }
}

