/*
 * Decompiled with CFR 0.152.
 */
package io.bitexpress.topia.commons.basic.json.converter;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import org.apache.commons.lang3.exception.ContextedRuntimeException;
import org.apache.commons.lang3.time.FastDateFormat;

public class DateDeserializer
extends JsonDeserializer<Date> {
    private static FastDateFormat fastDateFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSS");

    public Date deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        try {
            return fastDateFormat.parse((String)jp.readValueAs(String.class));
        }
        catch (ParseException e) {
            throw new ContextedRuntimeException();
        }
    }

    public Class<Date> handledType() {
        return Date.class;
    }
}

