/*
 * Decompiled with CFR 0.152.
 */
package io.bitexpress.topia.commons.basic.patroller;

import com.google.common.base.Stopwatch;
import io.bitexpress.topia.commons.basic.competition.LockCallback;
import io.bitexpress.topia.commons.basic.competition.LockTemplate2;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.exception.ContextedRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class MutexPatroller
implements InitializingBean {
    private Logger scheduleLogger = LoggerFactory.getLogger(MutexPatroller.class);
    private LockTemplate2 lockTemplate;
    private Object target;
    private String method;
    private String lockKey;
    private Method reflectMethod;

    public void afterPropertiesSet() throws Exception {
        this.reflectMethod = this.target.getClass().getMethod(this.method, new Class[0]);
    }

    public void patrol() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            this.scheduleLogger.info("patrol begin:{}", (Object)this.lockKey);
            this.lockTemplate.execute(this.lockKey, new LockCallback<Void>(){

                @Override
                public Void locked() {
                    try {
                        MutexPatroller.this.reflectMethod.invoke(MutexPatroller.this.target, new Object[0]);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                        throw new ContextedRuntimeException((Throwable)e);
                    }
                    return null;
                }
            });
        }
        finally {
            stopwatch.stop();
            this.scheduleLogger.info("patrol end:{}, cost:{}", (Object)this.lockKey, (Object)stopwatch);
        }
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setLockTemplate(LockTemplate2 lockTemplate) {
        this.lockTemplate = lockTemplate;
    }

    public void setLockKey(String lockKey) {
        Validate.notBlank((CharSequence)lockKey, (String)"lockKey is blank", (Object[])new Object[0]);
        this.lockKey = lockKey;
    }

    public void setLoggerName(String loggerName) {
        Validate.notBlank((CharSequence)loggerName, (String)"loggerName is blank", (Object[])new Object[0]);
        this.scheduleLogger = LoggerFactory.getLogger((String)loggerName);
    }
}

