/*
 * Decompiled with CFR 0.152.
 */
package io.bitexpress.topia.commons.basic.patroller;

import io.bitexpress.topia.commons.basic.competition.LockTemplate2;
import io.bitexpress.topia.commons.basic.patroller.Patroller;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelPatroller {
    private Logger scheduleLogger = LoggerFactory.getLogger(ParallelPatroller.class);
    public static final String DEFAULT_KEY = "PATROL";
    private LockTemplate2 lockTemplate;
    private List<Patroller> patrollers;
    private String lockKey = "PATROL";

    public void patrol() {
        this.scheduleLogger.info("patrol begin:{}", (Object)this.lockKey);
        this.lockTemplate.execute(this.lockKey, () -> {
            this.patrollers.parallelStream().forEach(t -> {
                try {
                    t.patrol();
                }
                catch (Exception e) {
                    this.scheduleLogger.error("", (Throwable)e);
                }
            });
            return null;
        });
        this.scheduleLogger.info("patrol end:{}", (Object)this.lockKey);
    }

    public void setPatrollers(List<Patroller> patrollers) {
        this.patrollers = patrollers;
    }

    public void setLockTemplate(LockTemplate2 lockTemplate) {
        this.lockTemplate = lockTemplate;
    }

    public void setLockKey(String lockKey) {
        Validate.notBlank((CharSequence)lockKey, (String)"lockKey is blank", (Object[])new Object[0]);
        this.lockKey = lockKey;
    }

    public void setLoggerName(String loggerName) {
        Validate.notBlank((CharSequence)loggerName, (String)"loggerName is blank", (Object[])new Object[0]);
        this.scheduleLogger = LoggerFactory.getLogger((String)loggerName);
    }
}

