/*
 * Decompiled with CFR 0.152.
 */
package io.bitexpress.topia.commons.basic.replenishment;

import java.util.Date;
import org.apache.commons.lang3.Range;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;

public class ReplenishmentRange {
    private static final Period DEFAULT_START_PERIOD = Period.days((int)30);
    private static final Period DEFAULT_END_PERIOD = Period.minutes((int)5);
    public static final ReplenishmentRange DEFAULT_INSTANCE = ReplenishmentRange.builder().startPeriod(DEFAULT_START_PERIOD).endPeriod(DEFAULT_END_PERIOD).build();
    private Period startPeriod;
    private Period endPeriod;

    @Deprecated
    public ReplenishmentRange() {
        this.startPeriod = DEFAULT_START_PERIOD;
        this.endPeriod = DEFAULT_END_PERIOD;
    }

    public Interval getInterval() {
        DateTime startTime = new DateTime().minus((ReadablePeriod)this.startPeriod);
        DateTime endTime = new DateTime().minus((ReadablePeriod)this.endPeriod);
        return new Interval((ReadableInstant)startTime, (ReadableInstant)endTime);
    }

    @Deprecated
    public Range<Date> getRange() {
        return this.getDateRange();
    }

    public Range<Date> getDateRange() {
        Interval interval = this.getInterval();
        return Range.between((Comparable)interval.getStart().toDate(), (Comparable)interval.getEnd().toDate());
    }

    private static Period $default$startPeriod() {
        return DEFAULT_START_PERIOD;
    }

    private static Period $default$endPeriod() {
        return DEFAULT_END_PERIOD;
    }

    public static ReplenishmentRangeBuilder builder() {
        return new ReplenishmentRangeBuilder();
    }

    public String toString() {
        return "ReplenishmentRange(startPeriod=" + this.startPeriod + ", endPeriod=" + this.endPeriod + ")";
    }

    public ReplenishmentRange(Period startPeriod, Period endPeriod) {
        this.startPeriod = startPeriod;
        this.endPeriod = endPeriod;
    }

    public void setStartPeriod(Period startPeriod) {
        this.startPeriod = startPeriod;
    }

    public void setEndPeriod(Period endPeriod) {
        this.endPeriod = endPeriod;
    }

    public static class ReplenishmentRangeBuilder {
        private boolean startPeriod$set;
        private Period startPeriod$value;
        private boolean endPeriod$set;
        private Period endPeriod$value;

        ReplenishmentRangeBuilder() {
        }

        public ReplenishmentRangeBuilder startPeriod(Period startPeriod) {
            this.startPeriod$value = startPeriod;
            this.startPeriod$set = true;
            return this;
        }

        public ReplenishmentRangeBuilder endPeriod(Period endPeriod) {
            this.endPeriod$value = endPeriod;
            this.endPeriod$set = true;
            return this;
        }

        public ReplenishmentRange build() {
            Period startPeriod$value = this.startPeriod$value;
            if (!this.startPeriod$set) {
                startPeriod$value = ReplenishmentRange.$default$startPeriod();
            }
            Period endPeriod$value = this.endPeriod$value;
            if (!this.endPeriod$set) {
                endPeriod$value = ReplenishmentRange.$default$endPeriod();
            }
            return new ReplenishmentRange(startPeriod$value, endPeriod$value);
        }

        public String toString() {
            return "ReplenishmentRange.ReplenishmentRangeBuilder(startPeriod$value=" + this.startPeriod$value + ", endPeriod$value=" + this.endPeriod$value + ")";
        }
    }
}

