/*
 * Decompiled with CFR 0.152.
 */
package io.bitexpress.topia.commons.basic.rpc.utils;

import io.bitexpress.topia.commons.basic.exception.ErrorCodeException;
import io.bitexpress.topia.commons.rpc.BaseResponse;
import io.bitexpress.topia.commons.rpc.BusinessCode;
import io.bitexpress.topia.commons.rpc.SystemCode;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class BaseResponseUtils {
    private static final Logger logger = LoggerFactory.getLogger(BaseResponseUtils.class);

    public static BaseResponse successBaseResponse() {
        return BaseResponseUtils.successBaseResponse(null);
    }

    public static BaseResponse successBaseResponse(String message) {
        return BaseResponseUtils.codeBaseResponse(SystemCode.SUCCESS, BusinessCode.SUCCESS.name(), message);
    }

    public static BaseResponse failureBaseResponse(String message) {
        return BaseResponseUtils.codeBaseResponse(SystemCode.FAILURE, null, message);
    }

    public static BaseResponse codeBaseResponse(SystemCode systemCode, String businessCode, String message) {
        BaseResponse br = new BaseResponse();
        br.setSystemCode(systemCode);
        br.setBusinessCode(businessCode);
        br.setMessage(message);
        return br;
    }

    public static BaseResponse errorCodeExceptionResponse(ErrorCodeException e) {
        logger.info("code:{},message:{}", (Object)e.getErrorCode(), (Object)e.getMessage());
        BaseResponse br = new BaseResponse();
        br.setSystemCode(SystemCode.SUCCESS);
        br.setBusinessCode(e.getErrorCode());
        br.setMessage(e.getMessage());
        return br;
    }

    public static BaseResponse exceptionBaseResponse(Throwable throwable) {
        return BaseResponseUtils.exceptionBaseResponse(throwable, false);
    }

    public static BaseResponse exceptionBaseResponse(Throwable throwable, boolean enableTrace) {
        if (throwable instanceof ErrorCodeException) {
            return BaseResponseUtils.errorCodeExceptionResponse((ErrorCodeException)throwable);
        }
        logger.error("", throwable);
        BaseResponse br = new BaseResponse();
        br.setSystemCode(SystemCode.FAILURE);
        br.setMessage(throwable.getMessage());
        br.setTrace(ExceptionUtils.getStackTrace((Throwable)throwable));
        return br;
    }

    public static void parse(BaseResponse baseResponse, String ... silentBusinessCodes) {
        Validate.validState((baseResponse.getSystemCode() == SystemCode.SUCCESS ? 1 : 0) != 0, (String)baseResponse.getMessage(), (Object[])new Object[0]);
        Object[] successCodeArray = (String[])ArrayUtils.add((Object[])silentBusinessCodes, (Object)BusinessCode.SUCCESS.name());
        if (!ArrayUtils.contains((Object[])successCodeArray, (Object)baseResponse.getBusinessCode())) {
            throw new ErrorCodeException(baseResponse.getBusinessCode(), baseResponse.getMessage());
        }
    }
}

