/*
 * Decompiled with CFR 0.152.
 */
package io.bitexpress.topia.commons.basic.rpc.utils;

import io.bitexpress.topia.commons.basic.exception.ErrorCodeException;
import io.bitexpress.topia.commons.basic.rpc.utils.BaseResponseUtils;
import io.bitexpress.topia.commons.rpc.BusinessCode;
import io.bitexpress.topia.commons.rpc.ResultResponse;
import io.bitexpress.topia.commons.rpc.SystemCode;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ResultResponseUtils {
    private static final Logger logger = LoggerFactory.getLogger(ResultResponseUtils.class);

    public static <T> ResultResponse<T> codeResultResponse(T result, SystemCode systemCode, String businessCode, String message) {
        ResultResponse rr = new ResultResponse();
        rr.setSystemCode(systemCode);
        rr.setBusinessCode(businessCode);
        rr.setMessage(message);
        rr.setResult(result);
        return rr;
    }

    public static <T> ResultResponse<T> successResultResponse(T result) {
        return ResultResponseUtils.codeResultResponse(result, SystemCode.SUCCESS, BusinessCode.SUCCESS.name(), null);
    }

    public static <T> ResultResponse<T> failureResultResponse(String message) {
        return ResultResponseUtils.codeResultResponse(null, SystemCode.FAILURE, null, message);
    }

    public static <T> ResultResponse<T> errorCodeExceptionResultResponse(ErrorCodeException e) {
        logger.info("code:{},message:{}", (Object)e.getErrorCode(), (Object)e.getMessage());
        ResultResponse rr = new ResultResponse();
        rr.setSystemCode(SystemCode.SUCCESS);
        rr.setBusinessCode(e.getErrorCode());
        rr.setMessage(e.getMessage());
        return rr;
    }

    public static <T> ResultResponse<T> exceptionResultResponse(Throwable throwable) {
        return ResultResponseUtils.exceptionResultResponse(throwable, false);
    }

    public static <T> ResultResponse<T> exceptionResultResponse(Throwable throwable, boolean enableTrace) {
        if (throwable instanceof ErrorCodeException) {
            return ResultResponseUtils.errorCodeExceptionResultResponse((ErrorCodeException)throwable);
        }
        logger.error("", throwable);
        ResultResponse rr = new ResultResponse();
        rr.setSystemCode(SystemCode.FAILURE);
        rr.setMessage(throwable.getMessage());
        if (enableTrace) {
            rr.setTrace(ExceptionUtils.getStackTrace((Throwable)throwable));
        }
        return rr;
    }

    public static <T> T parse(ResultResponse<T> resultResponse, String ... silentBusinessCodes) {
        BaseResponseUtils.parse(resultResponse, silentBusinessCodes);
        return (T)resultResponse.getResult();
    }
}

