/*
 * Decompiled with CFR 0.152.
 */
package io.bitexpress.topia.commons.pagination;

import io.bitexpress.topia.commons.pagination.SortPageParam;
import java.io.Serializable;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class Pagination<T>
implements Serializable {
    @Min(value=0L)
    private @Min(value=0L) long totalElements;
    @Min(value=0L)
    private @Min(value=0L) long totalPages;
    @NotNull
    @Valid
    private SortPageParam sortPageParam;
    @NotNull
    private List<T> items;

    public Pagination(@Min(value=0L) @Min(value=0L) long totalElements, @Min(value=0L) @Min(value=0L) long totalPages, @NotNull @Valid SortPageParam sortPageParam, @NotNull List<T> items) {
        this.totalElements = totalElements;
        this.totalPages = totalPages;
        this.sortPageParam = sortPageParam;
        this.items = items;
    }

    public <U> Pagination<U> map(Function<? super T, ? extends U> converter) {
        Pagination<? extends U> pagination = new Pagination<U>();
        List<? extends U> convertedContent = this.getConvertedContent(converter);
        pagination.setItems(convertedContent);
        pagination.setTotalElements(this.getTotalElements());
        pagination.setTotalPages(this.getTotalPages());
        pagination.setSortPageParam(this.getSortPageParam());
        return pagination;
    }

    protected <U> List<U> getConvertedContent(Function<? super T, ? extends U> converter) {
        if (this.items == null) {
            return null;
        }
        return this.items.stream().map(converter::apply).collect(Collectors.toList());
    }

    protected Pagination(PaginationBuilder<T, ?, ?> b) {
        this.totalElements = ((PaginationBuilder)b).totalElements;
        this.totalPages = ((PaginationBuilder)b).totalPages;
        this.sortPageParam = ((PaginationBuilder)b).sortPageParam;
        this.items = ((PaginationBuilder)b).items;
    }

    public static <T> PaginationBuilder<T, ?, ?> builder() {
        return new PaginationBuilderImpl();
    }

    public long getTotalElements() {
        return this.totalElements;
    }

    public long getTotalPages() {
        return this.totalPages;
    }

    public SortPageParam getSortPageParam() {
        return this.sortPageParam;
    }

    public List<T> getItems() {
        return this.items;
    }

    public void setTotalElements(long totalElements) {
        this.totalElements = totalElements;
    }

    public void setTotalPages(long totalPages) {
        this.totalPages = totalPages;
    }

    public void setSortPageParam(SortPageParam sortPageParam) {
        this.sortPageParam = sortPageParam;
    }

    public void setItems(List<T> items) {
        this.items = items;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pagination)) {
            return false;
        }
        Pagination other = (Pagination)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTotalElements() != other.getTotalElements()) {
            return false;
        }
        if (this.getTotalPages() != other.getTotalPages()) {
            return false;
        }
        SortPageParam this$sortPageParam = this.getSortPageParam();
        SortPageParam other$sortPageParam = other.getSortPageParam();
        if (this$sortPageParam == null ? other$sortPageParam != null : !((Object)this$sortPageParam).equals(other$sortPageParam)) {
            return false;
        }
        List<T> this$items = this.getItems();
        List<T> other$items = other.getItems();
        return !(this$items == null ? other$items != null : !((Object)this$items).equals(other$items));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Pagination;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $totalElements = this.getTotalElements();
        result = result * 59 + (int)($totalElements >>> 32 ^ $totalElements);
        long $totalPages = this.getTotalPages();
        result = result * 59 + (int)($totalPages >>> 32 ^ $totalPages);
        SortPageParam $sortPageParam = this.getSortPageParam();
        result = result * 59 + ($sortPageParam == null ? 43 : ((Object)$sortPageParam).hashCode());
        List<T> $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        return result;
    }

    public String toString() {
        return "Pagination(totalElements=" + this.getTotalElements() + ", totalPages=" + this.getTotalPages() + ", sortPageParam=" + this.getSortPageParam() + ", items=" + this.getItems() + ")";
    }

    public Pagination() {
    }

    private static final class PaginationBuilderImpl<T>
    extends PaginationBuilder<T, Pagination<T>, PaginationBuilderImpl<T>> {
        private PaginationBuilderImpl() {
        }

        @Override
        protected PaginationBuilderImpl<T> self() {
            return this;
        }

        @Override
        public Pagination<T> build() {
            return new Pagination(this);
        }
    }

    public static abstract class PaginationBuilder<T, C extends Pagination<T>, B extends PaginationBuilder<T, C, B>> {
        private long totalElements;
        private long totalPages;
        private SortPageParam sortPageParam;
        private List<T> items;

        protected abstract B self();

        public abstract C build();

        public B totalElements(long totalElements) {
            this.totalElements = totalElements;
            return this.self();
        }

        public B totalPages(long totalPages) {
            this.totalPages = totalPages;
            return this.self();
        }

        public B sortPageParam(SortPageParam sortPageParam) {
            this.sortPageParam = sortPageParam;
            return this.self();
        }

        public B items(List<T> items) {
            this.items = items;
            return this.self();
        }

        public String toString() {
            return "Pagination.PaginationBuilder(totalElements=" + this.totalElements + ", totalPages=" + this.totalPages + ", sortPageParam=" + this.sortPageParam + ", items=" + this.items + ")";
        }
    }
}

