/*
 * Decompiled with CFR 0.152.
 */
package org.tron.trident.crypto.tuwenitypes;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.vertx.core.buffer.Buffer;
import org.tron.trident.crypto.tuwenitypes.AbstractBytes;
import org.tron.trident.crypto.tuwenitypes.Bytes;
import org.tron.trident.crypto.tuwenitypes.MutableBytes;

class ByteBufWrappingBytes
extends AbstractBytes {
    protected final ByteBuf byteBuf;

    ByteBufWrappingBytes(ByteBuf byteBuf) {
        this.byteBuf = byteBuf;
    }

    ByteBufWrappingBytes(ByteBuf byteBuf, int offset, int length) {
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (Object)"Invalid negative length");
        int bufferLength = byteBuf.capacity();
        Preconditions.checkElementIndex((int)offset, (int)(bufferLength + 1));
        Preconditions.checkArgument((offset + length <= bufferLength ? 1 : 0) != 0, (String)"Provided length %s is too big: the buffer has size %s and has only %s bytes from %s", (Object)length, (Object)bufferLength, (Object)(bufferLength - offset), (Object)offset);
        this.byteBuf = offset == 0 && length == bufferLength ? byteBuf : byteBuf.slice(offset, length);
    }

    @Override
    public int size() {
        return this.byteBuf.capacity();
    }

    @Override
    public byte get(int i) {
        return this.byteBuf.getByte(i);
    }

    @Override
    public int getInt(int i) {
        return this.byteBuf.getInt(i);
    }

    @Override
    public long getLong(int i) {
        return this.byteBuf.getLong(i);
    }

    @Override
    public Bytes slice(int i, int length) {
        int size = this.byteBuf.capacity();
        if (i == 0 && length == size) {
            return this;
        }
        if (length == 0) {
            return Bytes.EMPTY;
        }
        Preconditions.checkElementIndex((int)i, (int)size);
        Preconditions.checkArgument((i + length <= size ? 1 : 0) != 0, (String)"Provided length %s is too big: the value has size %s and has only %s bytes from %s", (Object)length, (Object)size, (Object)(size - i), (Object)i);
        return new ByteBufWrappingBytes(this.byteBuf.slice(i, length));
    }

    @Override
    public Bytes copy() {
        return Bytes.wrap(this.toArray());
    }

    @Override
    public MutableBytes mutableCopy() {
        return MutableBytes.wrap(this.toArray());
    }

    @Override
    public void appendTo(Buffer buffer) {
        buffer.appendBuffer(Buffer.buffer((ByteBuf)this.byteBuf));
    }

    @Override
    public byte[] toArray() {
        int size = this.byteBuf.capacity();
        byte[] array = new byte[size];
        this.byteBuf.getBytes(0, array);
        return array;
    }
}

