/*
 * Decompiled with CFR 0.152.
 */
package org.tron.trident.crypto.tuwenitypes;

import com.google.common.base.Preconditions;
import io.vertx.core.buffer.Buffer;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import org.tron.trident.crypto.tuwenitypes.Bytes;
import org.tron.trident.crypto.tuwenitypes.Bytes32;
import org.tron.trident.crypto.tuwenitypes.MutableBytes;
import org.tron.trident.crypto.tuwenitypes.MutableBytes32;

final class DelegatingMutableBytes32
implements MutableBytes32 {
    private final MutableBytes delegate;

    private DelegatingMutableBytes32(MutableBytes delegate) {
        this.delegate = delegate;
    }

    static MutableBytes32 delegateTo(MutableBytes value) {
        Preconditions.checkArgument((value.size() == 32 ? 1 : 0) != 0, (String)"Expected %s bytes but got %s", (int)32, (int)value.size());
        return new DelegatingMutableBytes32(value);
    }

    @Override
    public void set(int i, byte b) {
        this.delegate.set(i, b);
    }

    @Override
    public void setInt(int i, int value) {
        this.delegate.setInt(i, value);
    }

    @Override
    public void setLong(int i, long value) {
        this.delegate.setLong(i, value);
    }

    @Override
    public MutableBytes increment() {
        return this.delegate.increment();
    }

    @Override
    public MutableBytes decrement() {
        return this.delegate.decrement();
    }

    @Override
    public MutableBytes mutableSlice(int i, int length) {
        return this.delegate.mutableSlice(i, length);
    }

    @Override
    public void fill(byte b) {
        this.delegate.fill(b);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public byte get(int i) {
        return this.delegate.get(i);
    }

    @Override
    public int getInt(int i) {
        return this.delegate.getInt(i);
    }

    @Override
    public int toInt() {
        return this.delegate.toInt();
    }

    @Override
    public long getLong(int i) {
        return this.delegate.getLong(i);
    }

    @Override
    public long toLong() {
        return this.delegate.toLong();
    }

    @Override
    public BigInteger toBigInteger() {
        return this.delegate.toBigInteger();
    }

    @Override
    public BigInteger toUnsignedBigInteger() {
        return this.delegate.toUnsignedBigInteger();
    }

    @Override
    public boolean isZero() {
        return this.delegate.isZero();
    }

    @Override
    public int numberOfLeadingZeros() {
        return this.delegate.numberOfLeadingZeros();
    }

    @Override
    public int numberOfLeadingZeroBytes() {
        return this.delegate.numberOfLeadingZeroBytes();
    }

    @Override
    public boolean hasLeadingZeroByte() {
        return this.delegate.hasLeadingZeroByte();
    }

    @Override
    public boolean hasLeadingZero() {
        return this.delegate.hasLeadingZero();
    }

    @Override
    public int bitLength() {
        return this.delegate.bitLength();
    }

    @Override
    public Bytes and(Bytes other) {
        return this.delegate.and(other);
    }

    @Override
    public <T extends MutableBytes> T and(Bytes other, T result) {
        return this.delegate.and(other, result);
    }

    @Override
    public Bytes or(Bytes other) {
        return this.delegate.or(other);
    }

    @Override
    public <T extends MutableBytes> T or(Bytes other, T result) {
        return this.delegate.or(other, result);
    }

    @Override
    public Bytes xor(Bytes other) {
        return this.delegate.xor(other);
    }

    @Override
    public <T extends MutableBytes> T xor(Bytes other, T result) {
        return this.delegate.xor(other, result);
    }

    @Override
    public <T extends MutableBytes> T not(T result) {
        return this.delegate.not(result);
    }

    @Override
    public <T extends MutableBytes> T shiftRight(int distance, T result) {
        return this.delegate.shiftRight(distance, result);
    }

    @Override
    public <T extends MutableBytes> T shiftLeft(int distance, T result) {
        return this.delegate.shiftLeft(distance, result);
    }

    @Override
    public Bytes slice(int index) {
        return this.delegate.slice(index);
    }

    @Override
    public Bytes slice(int index, int length) {
        return this.delegate.slice(index, length);
    }

    @Override
    public Bytes32 copy() {
        return Bytes32.wrap(this.delegate.toArray());
    }

    @Override
    public MutableBytes32 mutableCopy() {
        return MutableBytes32.wrap(this.delegate.toArray());
    }

    @Override
    public void copyTo(MutableBytes destination) {
        this.delegate.copyTo(destination);
    }

    @Override
    public void copyTo(MutableBytes destination, int destinationOffset) {
        this.delegate.copyTo(destination, destinationOffset);
    }

    @Override
    public void appendTo(ByteBuffer byteBuffer) {
        this.delegate.appendTo(byteBuffer);
    }

    @Override
    public void appendTo(Buffer buffer) {
        this.delegate.appendTo(buffer);
    }

    @Override
    public int commonPrefixLength(Bytes other) {
        return this.delegate.commonPrefixLength(other);
    }

    @Override
    public Bytes commonPrefix(Bytes other) {
        return this.delegate.commonPrefix(other);
    }

    @Override
    public void update(MessageDigest digest) {
        this.delegate.update(digest);
    }

    @Override
    public byte[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public byte[] toArrayUnsafe() {
        return this.delegate.toArrayUnsafe();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public String toHexString() {
        return this.delegate.toHexString();
    }

    @Override
    public String toShortHexString() {
        return this.delegate.toShortHexString();
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }
}

