/*
 * Decompiled with CFR 0.152.
 */
package io.matthewnelson.encoding.base16;

import io.matthewnelson.encoding.base16.Base16ConfigBuilder;
import io.matthewnelson.encoding.core.Decoder;
import io.matthewnelson.encoding.core.Encoder;
import io.matthewnelson.encoding.core.EncoderDecoder;
import io.matthewnelson.encoding.core.EncodingException;
import io.matthewnelson.encoding.core.EncodingSizeException;
import io.matthewnelson.encoding.core.util.DecoderInput;
import io.matthewnelson.encoding.core.util.FeedBuffer;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u0011\u0012\u0013B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0006\u001a\f0\u0007R\b\u0012\u0004\u0012\u00020\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u001a\u0010\u000b\u001a\f0\fR\b\u0012\u0004\u0012\u00020\u00020\r2\u0006\u0010\t\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\u0010H\u0014\u00a8\u0006\u0014"}, d2={"Lio/matthewnelson/encoding/base16/Base16;", "Lio/matthewnelson/encoding/core/EncoderDecoder;", "Lio/matthewnelson/encoding/base16/Base16$Config;", "config", "<init>", "(Lio/matthewnelson/encoding/base16/Base16$Config;)V", "newDecoderFeedProtected", "Lio/matthewnelson/encoding/core/Decoder$Feed;", "Lio/matthewnelson/encoding/core/Decoder;", "out", "Lio/matthewnelson/encoding/core/Decoder$OutFeed;", "newEncoderFeedProtected", "Lio/matthewnelson/encoding/core/Encoder$Feed;", "Lio/matthewnelson/encoding/core/Encoder;", "Lio/matthewnelson/encoding/core/Encoder$OutFeed;", "name", "", "Config", "Companion", "DecodingBuffer", "io.matthewnelson.encoding_base16_jvm"})
public final class Base16
extends EncoderDecoder<Config> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String CHARS_UPPER = "0123456789ABCDEF";
    @NotNull
    public static final String CHARS_LOWER = "0123456789abcdef";
    @NotNull
    private static final Base16 DELEGATE = new Base16((Config)Companion.getConfig());

    public Base16(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
        super((EncoderDecoder.Config)config);
    }

    @NotNull
    protected Decoder.Feed newDecoderFeedProtected(@NotNull Decoder.OutFeed out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        return new Decoder.Feed(this, out){
            private final DecodingBuffer buffer;
            {
                this.buffer = $receiver.new DecodingBuffer($out);
            }

            protected void consumeProtected(char input) throws EncodingException {
                char code = input;
                int ge0 = code >= '0' ? 1 : 0;
                int le9 = code <= '9' ? 1 : 0;
                int geA = code >= 'A' ? 1 : 0;
                int leF = code <= 'F' ? 1 : 0;
                int gea = code >= 'a' ? 1 : 0;
                int lef = code <= 'f' ? 1 : 0;
                int diff = 0;
                diff += ge0 + le9 == 2 ? -48 : 0;
                diff += geA + leF == 2 ? -55 : 0;
                if ((diff += gea + lef == 2 ? -87 : 0) == 0) {
                    throw new EncodingException("Char[" + input + "] is not a valid Base16 character");
                }
                this.buffer.update(code + diff);
            }

            protected void doFinalProtected() throws EncodingException {
                this.buffer.finalize();
            }
        };
    }

    @NotNull
    protected Encoder.Feed newEncoderFeedProtected(@NotNull Encoder.OutFeed out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        return new Encoder.Feed(this, out){
            private final String table;
            final /* synthetic */ Encoder.OutFeed $out;
            {
                this.$out = $out;
                super((Encoder)$receiver);
                this.table = ((Config)this.getConfig()).encodeToLowercase ? "0123456789abcdef" : "0123456789ABCDEF";
            }

            protected void consumeProtected(byte input) {
                int bits = input & 0xFF;
                int i1 = bits >> 4;
                int i2 = bits & 0xF;
                this.$out.output(this.table.charAt(i1));
                this.$out.output(this.table.charAt(i2));
            }

            protected void doFinalProtected() {
            }
        };
    }

    @NotNull
    protected String name() {
        return "Base16";
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\n\u001a\u00020\u0006H\u0014J\u001a\u0010\u000b\u001a\f0\fR\b\u0012\u0004\u0012\u00020\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u001a\u0010\u0010\u001a\f0\u0011R\b\u0012\u0004\u0012\u00020\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u0013H\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/matthewnelson/encoding/base16/Base16$Companion;", "Lio/matthewnelson/encoding/core/EncoderDecoder;", "Lio/matthewnelson/encoding/base16/Base16$Config;", "<init>", "()V", "CHARS_UPPER", "", "CHARS_LOWER", "DELEGATE", "Lio/matthewnelson/encoding/base16/Base16;", "name", "newDecoderFeedProtected", "Lio/matthewnelson/encoding/core/Decoder$Feed;", "Lio/matthewnelson/encoding/core/Decoder;", "out", "Lio/matthewnelson/encoding/core/Decoder$OutFeed;", "newEncoderFeedProtected", "Lio/matthewnelson/encoding/core/Encoder$Feed;", "Lio/matthewnelson/encoding/core/Encoder;", "Lio/matthewnelson/encoding/core/Encoder$OutFeed;", "io.matthewnelson.encoding_base16_jvm"})
    @SourceDebugExtension(value={"SMAP\nBase16.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Base16.kt\nio/matthewnelson/encoding/base16/Base16$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,248:1\n1#2:249\n*E\n"})
    public static final class Companion
    extends EncoderDecoder<Config> {
        private Companion() {
            Base16ConfigBuilder base16ConfigBuilder;
            Base16ConfigBuilder base16ConfigBuilder2 = base16ConfigBuilder = new Base16ConfigBuilder();
            Companion companion = this;
            boolean bl = false;
            $this$_init__u24lambda_u240.lineBreakInterval = (byte)64;
            super((EncoderDecoder.Config)base16ConfigBuilder.build());
        }

        @NotNull
        protected String name() {
            return DELEGATE.name();
        }

        @NotNull
        protected Decoder.Feed newDecoderFeedProtected(@NotNull Decoder.OutFeed out) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            return DELEGATE.newDecoderFeedProtected(out);
        }

        @NotNull
        protected Encoder.Feed newEncoderFeedProtected(@NotNull Encoder.OutFeed out) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            return DELEGATE.newEncoderFeedProtected(out);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0014J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\nH\u0014J\u0012\u0010\u0012\u001a\f\u0012\b\u0012\u00060\u0014R\u00020\u00010\u0013H\u0014R\u0010\u0010\u0006\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u00020\u00038\u0006X\u0087D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/matthewnelson/encoding/base16/Base16$Config;", "Lio/matthewnelson/encoding/core/EncoderDecoder$Config;", "isLenient", "", "lineBreakInterval", "", "encodeToLowercase", "<init>", "(ZBZ)V", "decodeOutMaxSizeProtected", "", "encodedSize", "decodeOutMaxSizeOrFailProtected", "", "input", "Lio/matthewnelson/encoding/core/util/DecoderInput;", "encodeOutSizeProtected", "unEncodedSize", "toStringAddSettings", "", "Lio/matthewnelson/encoding/core/EncoderDecoder$Config$Setting;", "isConstantTime", "Companion", "io.matthewnelson.encoding_base16_jvm"})
    public static final class Config
    extends EncoderDecoder.Config {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @JvmField
        public final boolean encodeToLowercase;
        @JvmField
        public final boolean isConstantTime;

        private Config(boolean isLenient, byte lineBreakInterval, boolean encodeToLowercase) {
            super(Boolean.valueOf(isLenient), lineBreakInterval, null);
            this.encodeToLowercase = encodeToLowercase;
            this.isConstantTime = true;
        }

        protected long decodeOutMaxSizeProtected(long encodedSize) {
            return encodedSize / 2L;
        }

        protected int decodeOutMaxSizeOrFailProtected(int encodedSize, @NotNull DecoderInput input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return encodedSize / 2;
        }

        protected long encodeOutSizeProtected(long unEncodedSize) throws EncodingSizeException {
            if (unEncodedSize > 0x3FFFFFFFFFFFFFFFL) {
                throw EncoderDecoder.Config.Companion.outSizeExceedsMaxEncodingSizeException((Number)unEncodedSize, (Number)Long.MAX_VALUE);
            }
            return unEncodedSize * 2L;
        }

        @NotNull
        protected Set<EncoderDecoder.Config.Setting> toStringAddSettings() {
            LinkedHashSet<EncoderDecoder.Config.Setting> linkedHashSet;
            LinkedHashSet<EncoderDecoder.Config.Setting> $this$toStringAddSettings_u24lambda_u240 = linkedHashSet = new LinkedHashSet<EncoderDecoder.Config.Setting>(3, 1.0f);
            boolean bl = false;
            $this$toStringAddSettings_u24lambda_u240.add(new EncoderDecoder.Config.Setting((EncoderDecoder.Config)this, "encodeToLowercase", (Object)this.encodeToLowercase));
            $this$toStringAddSettings_u24lambda_u240.add(new EncoderDecoder.Config.Setting((EncoderDecoder.Config)this, "isConstantTime", (Object)this.isConstantTime));
            return linkedHashSet;
        }

        public /* synthetic */ Config(boolean isLenient, byte lineBreakInterval, boolean encodeToLowercase, DefaultConstructorMarker $constructor_marker) {
            this(isLenient, lineBreakInterval, encodeToLowercase);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\b\u00a8\u0006\t"}, d2={"Lio/matthewnelson/encoding/base16/Base16$Config$Companion;", "", "<init>", "()V", "from", "Lio/matthewnelson/encoding/base16/Base16$Config;", "builder", "Lio/matthewnelson/encoding/base16/Base16ConfigBuilder;", "from$io_matthewnelson_encoding_base16_jvm", "io.matthewnelson.encoding_base16_jvm"})
        public static final class Companion {
            private Companion() {
            }

            public final /* synthetic */ Config from$io_matthewnelson_encoding_base16_jvm(Base16ConfigBuilder builder) {
                Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                return new Config(builder.isLenient, builder.lineBreakInterval, builder.encodeToLowercase, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lio/matthewnelson/encoding/base16/Base16$DecodingBuffer;", "Lio/matthewnelson/encoding/core/util/FeedBuffer;", "out", "Lio/matthewnelson/encoding/core/Decoder$OutFeed;", "<init>", "(Lio/matthewnelson/encoding/base16/Base16;Lio/matthewnelson/encoding/core/Decoder$OutFeed;)V", "io.matthewnelson.encoding_base16_jvm"})
    private final class DecodingBuffer
    extends FeedBuffer {
        public DecodingBuffer(Decoder.OutFeed out) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            super(2, arg_0 -> DecodingBuffer._init_$lambda$0(out, arg_0), DecodingBuffer::_init_$lambda$1);
        }

        private static final void _init_$lambda$0(Decoder.OutFeed $out, int[] buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            int bitBuffer = 0;
            for (int bits : buffer) {
                bitBuffer = bitBuffer << 4 | bits;
            }
            $out.output((byte)bitBuffer);
        }

        private static final void _init_$lambda$1(int modulus, int[] nArray) {
            Intrinsics.checkNotNullParameter((Object)nArray, (String)"<unused var>");
            if (modulus != 0) {
                throw FeedBuffer.Companion.truncatedInputEncodingException(modulus);
            }
        }
    }
}

