/*
 * Decompiled with CFR 0.152.
 */
package io.matthewnelson.encoding.base32;

import io.matthewnelson.encoding.base32.Base32;
import io.matthewnelson.encoding.base32.Base32CrockfordConfigBuilder;
import io.matthewnelson.encoding.base32.Base32DefaultConfigBuilder;
import io.matthewnelson.encoding.base32.Base32HexConfigBuilder;
import io.matthewnelson.encoding.core.Decoder;
import io.matthewnelson.encoding.core.Encoder;
import io.matthewnelson.encoding.core.EncoderDecoder;
import io.matthewnelson.encoding.core.EncodingException;
import io.matthewnelson.encoding.core.util.DecoderInput;
import io.matthewnelson.encoding.core.util.FeedBuffer;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0005\u0007\b\t\n\u000bB\u0011\b\u0004\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006\u0082\u0001\u0003\f\r\u000e\u00a8\u0006\u000f"}, d2={"Lio/matthewnelson/encoding/base32/Base32;", "C", "Lio/matthewnelson/encoding/core/EncoderDecoder$Config;", "Lio/matthewnelson/encoding/core/EncoderDecoder;", "config", "<init>", "(Lio/matthewnelson/encoding/core/EncoderDecoder$Config;)V", "Crockford", "Default", "Hex", "DecodingBuffer", "EncodingBuffer", "Lio/matthewnelson/encoding/base32/Base32$Crockford;", "Lio/matthewnelson/encoding/base32/Base32$Default;", "Lio/matthewnelson/encoding/base32/Base32$Hex;", "io.matthewnelson.encoding_base32_jvm"})
public abstract class Base32<C extends EncoderDecoder.Config>
extends EncoderDecoder<C> {
    private Base32(C config) {
        super(config);
    }

    public /* synthetic */ Base32(EncoderDecoder.Config config, DefaultConstructorMarker $constructor_marker) {
        this(config);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0011\u0012B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0006\u001a\f0\u0007R\b\u0012\u0004\u0012\u00020\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u001a\u0010\u000b\u001a\f0\fR\b\u0012\u0004\u0012\u00020\u00020\r2\u0006\u0010\t\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\u0010H\u0014\u00a8\u0006\u0013"}, d2={"Lio/matthewnelson/encoding/base32/Base32$Crockford;", "Lio/matthewnelson/encoding/base32/Base32;", "Lio/matthewnelson/encoding/base32/Base32$Crockford$Config;", "config", "<init>", "(Lio/matthewnelson/encoding/base32/Base32$Crockford$Config;)V", "newDecoderFeedProtected", "Lio/matthewnelson/encoding/core/Decoder$Feed;", "Lio/matthewnelson/encoding/core/Decoder;", "out", "Lio/matthewnelson/encoding/core/Decoder$OutFeed;", "newEncoderFeedProtected", "Lio/matthewnelson/encoding/core/Encoder$Feed;", "Lio/matthewnelson/encoding/core/Encoder;", "Lio/matthewnelson/encoding/core/Encoder$OutFeed;", "name", "", "Config", "Companion", "io.matthewnelson.encoding_base32_jvm"})
    public static final class Crockford
    extends Base32<Config> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        public static final String CHARS_UPPER = "0123456789ABCDEFGHJKMNPQRSTVWXYZ";
        @NotNull
        public static final String CHARS_LOWER = "0123456789abcdefghjkmnpqrstvwxyz";
        @NotNull
        private static final Crockford DELEGATE = new Crockford((Config)Companion.getConfig());

        public Crockford(@NotNull Config config) {
            Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
            super(config, null);
        }

        @NotNull
        protected Decoder.Feed newDecoderFeedProtected(@NotNull Decoder.OutFeed out) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            return new Decoder.Feed(this, out){
                private boolean isCheckSymbolSet;
                private final DecodingBuffer buffer;
                {
                    this.buffer = $receiver.new DecodingBuffer($out);
                }

                protected void consumeProtected(char input) throws EncodingException {
                    boolean bl;
                    block6: {
                        if (this.isCheckSymbolSet) {
                            throw new EncodingException("CheckSymbol[" + ((Config)this.getConfig()).checkSymbol + "] was set");
                        }
                        if (input == '-') {
                            return;
                        }
                        char code = input;
                        int ge0 = code >= '0' ? 1 : 0;
                        int le9 = code <= '9' ? 1 : 0;
                        int geA = code >= 'A' ? 1 : 0;
                        int leH = code <= 'H' ? 1 : 0;
                        int eqI = code == 'I' ? 1 : 0;
                        int eqL = code == 'L' ? 1 : 0;
                        int eqJ = code == 'J' ? 1 : 0;
                        int eqK = code == 'K' ? 1 : 0;
                        int eqM = code == 'M' ? 1 : 0;
                        int eqN = code == 'N' ? 1 : 0;
                        int eqO = code == 'O' ? 1 : 0;
                        int geP = code >= 'P' ? 1 : 0;
                        int leT = code <= 'T' ? 1 : 0;
                        int geV = code >= 'V' ? 1 : 0;
                        int leZ = code <= 'Z' ? 1 : 0;
                        int gea = code >= 'a' ? 1 : 0;
                        int leh = code <= 'h' ? 1 : 0;
                        int eqi = code == 'i' ? 1 : 0;
                        int eql = code == 'l' ? 1 : 0;
                        int eqj = code == 'j' ? 1 : 0;
                        int eqk = code == 'k' ? 1 : 0;
                        int eqm = code == 'm' ? 1 : 0;
                        int eqn = code == 'n' ? 1 : 0;
                        int eqo = code == 'o' ? 1 : 0;
                        int gep = code >= 'p' ? 1 : 0;
                        int let = code <= 't' ? 1 : 0;
                        int gev = code >= 'v' ? 1 : 0;
                        int lez = code <= 'z' ? 1 : 0;
                        int diff = 0;
                        diff += ge0 + le9 == 2 ? -48 : 0;
                        diff += geA + leH == 2 ? -55 : 0;
                        int h = '\u0001' - code;
                        diff += eqI + eqi + eqL + eql == 1 ? h : 0;
                        diff += eqJ + eqK == 1 ? -56 : 0;
                        diff += eqM + eqN == 1 ? -57 : 0;
                        int k = '\u0000' - code;
                        diff += eqO + eqo == 1 ? k : 0;
                        diff += geP + leT == 2 ? -58 : 0;
                        diff += geV + leZ == 2 ? -59 : 0;
                        diff += gea + leh == 2 ? -87 : 0;
                        diff += eqj + eqk == 1 ? -88 : 0;
                        diff += eqm + eqn == 1 ? -89 : 0;
                        diff += gep + let == 2 ? -90 : 0;
                        if ((diff += gev + lez == 2 ? -91 : 0) != 0) {
                            this.buffer.update(code + diff);
                            return;
                        }
                        char $this$isCheckSymbol_u24default$iv = input;
                        boolean isConstantTime$iv = false;
                        boolean $i$f$isCheckSymbol = false;
                        boolean isSymbol$iv = false;
                        int n = "*~$=Uu".length();
                        for (int i = 0; i < n; ++i) {
                            char c$iv = "*~$=Uu".charAt(i);
                            if ($this$isCheckSymbol_u24default$iv != c$iv) continue;
                            bl = true;
                            break block6;
                        }
                        bl = isSymbol$iv;
                    }
                    if (!bl) {
                        throw new EncodingException("Char[" + input + "] is not a valid Base32 Crockford character");
                    }
                    Character c = ((Config)this.getConfig()).checkSymbol;
                    boolean bl2 = c != null ? Character.toUpperCase(c.charValue()) == Character.toUpperCase(input) : false;
                    if (bl2) {
                        this.isCheckSymbolSet = true;
                        return;
                    }
                    throw new EncodingException("Char[" + input + "] IS a checkSymbol, but did not match config's Checksymbol[" + ((Config)this.getConfig()).checkSymbol + ']');
                }

                protected void doFinalProtected() throws EncodingException {
                    this.buffer.finalize();
                    this.isCheckSymbolSet = false;
                }
            };
        }

        @NotNull
        protected Encoder.Feed newEncoderFeedProtected(@NotNull Encoder.OutFeed out) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            return new Encoder.Feed(this, out){
                private byte outCount;
                private boolean outputHyphenOnNext;
                private final EncodingBuffer buffer;
                final /* synthetic */ Encoder.OutFeed $out;
                {
                    this.$out = $out;
                    super((Encoder)$receiver);
                    this.buffer = $receiver.new EncodingBuffer(arg_0 -> newEncoderFeedProtected.1.buffer$lambda$0(this, $out, arg_0), ((Config)this.getConfig()).encodeToLowercase ? "0123456789abcdefghjkmnpqrstvwxyz" : "0123456789ABCDEFGHJKMNPQRSTVWXYZ", null);
                }

                protected void consumeProtected(byte input) {
                    this.buffer.update(input);
                }

                protected void doFinalProtected() {
                    this.buffer.finalize();
                    if (((Config)this.getConfig()).finalizeWhenFlushed || this.isClosed()) {
                        Character c = ((Config)this.getConfig()).checkSymbol;
                        if (c != null) {
                            Character c2 = c;
                            Encoder.OutFeed outFeed = this.$out;
                            char symbol = c2.charValue();
                            boolean bl = false;
                            if (this.outputHyphenOnNext) {
                                outFeed.output('-');
                            }
                            if (((Config)this.getConfig()).encodeToLowercase) {
                                outFeed.output(Character.toLowerCase(symbol));
                            } else {
                                outFeed.output(Character.toUpperCase(symbol));
                            }
                        }
                        this.outCount = 0;
                        this.outputHyphenOnNext = false;
                    }
                }

                /*
                 * Unable to fully structure code
                 */
                private static final void buffer$lambda$0(newEncoderFeedProtected.1 this$0, Encoder.OutFeed $out, char byte) {
                    if (this$0.outputHyphenOnNext) {
                        $out.output('-');
                        this$0.outCount = 0;
                        this$0.outputHyphenOnNext = false;
                    }
                    $out.output(byte);
                    if (((Config)this$0.getConfig()).hyphenInterval <= 0) ** GOTO lbl-1000
                    this$0.outCount = (byte)(this$0.outCount + 1);
                    if (this$0.outCount == ((Config)this$0.getConfig()).hyphenInterval) {
                        v0 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v0 = false;
                    }
                    this$0.outputHyphenOnNext = v0;
                }
            };
        }

        @NotNull
        protected String name() {
            return "Base32.Crockford";
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\n\u001a\u00020\u0006H\u0014J\u001a\u0010\u000b\u001a\f0\fR\b\u0012\u0004\u0012\u00020\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u001a\u0010\u0010\u001a\f0\u0011R\b\u0012\u0004\u0012\u00020\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u0013H\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/matthewnelson/encoding/base32/Base32$Crockford$Companion;", "Lio/matthewnelson/encoding/core/EncoderDecoder;", "Lio/matthewnelson/encoding/base32/Base32$Crockford$Config;", "<init>", "()V", "CHARS_UPPER", "", "CHARS_LOWER", "DELEGATE", "Lio/matthewnelson/encoding/base32/Base32$Crockford;", "name", "newDecoderFeedProtected", "Lio/matthewnelson/encoding/core/Decoder$Feed;", "Lio/matthewnelson/encoding/core/Decoder;", "out", "Lio/matthewnelson/encoding/core/Decoder$OutFeed;", "newEncoderFeedProtected", "Lio/matthewnelson/encoding/core/Encoder$Feed;", "Lio/matthewnelson/encoding/core/Encoder;", "Lio/matthewnelson/encoding/core/Encoder$OutFeed;", "io.matthewnelson.encoding_base32_jvm"})
        @SourceDebugExtension(value={"SMAP\nBase32.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Base32.kt\nio/matthewnelson/encoding/base32/Base32$Crockford$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1012:1\n1#2:1013\n*E\n"})
        public static final class Companion
        extends EncoderDecoder<Config> {
            private Companion() {
                Base32CrockfordConfigBuilder base32CrockfordConfigBuilder;
                Base32CrockfordConfigBuilder base32CrockfordConfigBuilder2 = base32CrockfordConfigBuilder = new Base32CrockfordConfigBuilder();
                Companion companion = this;
                boolean bl = false;
                $this$_init__u24lambda_u240.hyphenInterval = (byte)4;
                super((EncoderDecoder.Config)base32CrockfordConfigBuilder.build());
            }

            @NotNull
            protected String name() {
                return DELEGATE.name();
            }

            @NotNull
            protected Decoder.Feed newDecoderFeedProtected(@NotNull Decoder.OutFeed out) {
                Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                return DELEGATE.newDecoderFeedProtected(out);
            }

            @NotNull
            protected Encoder.Feed newEncoderFeedProtected(@NotNull Encoder.OutFeed out) {
                Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                return DELEGATE.newEncoderFeedProtected(out);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB3\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0014J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u000eH\u0014J\u0012\u0010\u0016\u001a\f\u0012\b\u0012\u00060\u0018R\u00020\u00010\u0017H\u0014R\u0010\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u0004\u0018\u00010\b8\u0006X\u0087\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0010\u0010\t\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u00020\u00038\u0006X\u0087D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lio/matthewnelson/encoding/base32/Base32$Crockford$Config;", "Lio/matthewnelson/encoding/core/EncoderDecoder$Config;", "isLenient", "", "encodeToLowercase", "hyphenInterval", "", "checkSymbol", "", "finalizeWhenFlushed", "<init>", "(ZZBLjava/lang/Character;Z)V", "Ljava/lang/Character;", "decodeOutMaxSizeProtected", "", "encodedSize", "decodeOutMaxSizeOrFailProtected", "", "input", "Lio/matthewnelson/encoding/core/util/DecoderInput;", "encodeOutSizeProtected", "unEncodedSize", "toStringAddSettings", "", "Lio/matthewnelson/encoding/core/EncoderDecoder$Config$Setting;", "isConstantTime", "Companion", "io.matthewnelson.encoding_base32_jvm"})
        @SourceDebugExtension(value={"SMAP\nBase32.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Base32.kt\nio/matthewnelson/encoding/base32/Base32$Crockford$Config\n+ 2 -Math.kt\nio/matthewnelson/encoding/base32/internal/_MathKt\n+ 3 -Helpers.kt\nio/matthewnelson/encoding/base32/internal/_HelpersKt\n*L\n1#1,1012:1\n21#2:1013\n21#2:1032\n25#2,12:1033\n22#3,9:1014\n22#3,9:1023\n*S KotlinDebug\n*F\n+ 1 Base32.kt\nio/matthewnelson/encoding/base32/Base32$Crockford$Config\n*L\n101#1:1013\n144#1:1032\n148#1:1033,12\n119#1:1014,9\n135#1:1023,9\n*E\n"})
        public static final class Config
        extends EncoderDecoder.Config {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @JvmField
            public final boolean encodeToLowercase;
            @JvmField
            public final byte hyphenInterval;
            @JvmField
            @Nullable
            public final Character checkSymbol;
            @JvmField
            public final boolean finalizeWhenFlushed;
            @JvmField
            public final boolean isConstantTime;

            private Config(boolean isLenient, boolean encodeToLowercase, byte hyphenInterval, Character checkSymbol, boolean finalizeWhenFlushed) {
                super(Boolean.valueOf(isLenient), (byte)0, null);
                this.encodeToLowercase = encodeToLowercase;
                this.hyphenInterval = hyphenInterval;
                this.checkSymbol = checkSymbol;
                this.finalizeWhenFlushed = finalizeWhenFlushed;
                this.isConstantTime = true;
            }

            protected long decodeOutMaxSizeProtected(long encodedSize) {
                long $this$decodeOutMaxSize$iv = encodedSize;
                boolean $i$f$decodeOutMaxSize = false;
                return $this$decodeOutMaxSize$iv * 5L / 8L;
            }

            protected int decodeOutMaxSizeOrFailProtected(int encodedSize, @NotNull DecoderInput input) throws EncodingException {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                int outSize = encodedSize;
                char actual = input.get(encodedSize - 1);
                if (this.checkSymbol != null) {
                    char expectedUpper = Character.toUpperCase(this.checkSymbol.charValue());
                    char actualUpper = Character.toUpperCase(actual);
                    if (actualUpper != expectedUpper) {
                        boolean bl;
                        block7: {
                            char $this$isCheckSymbol_u24default$iv = actual;
                            boolean isConstantTime$iv = false;
                            boolean $i$f$isCheckSymbol = false;
                            boolean isSymbol$iv = false;
                            int n = "*~$=Uu".length();
                            for (int i = 0; i < n; ++i) {
                                char c$iv = "*~$=Uu".charAt(i);
                                if ($this$isCheckSymbol_u24default$iv != c$iv) continue;
                                bl = true;
                                break block7;
                            }
                            bl = isSymbol$iv;
                        }
                        if (bl) {
                            throw new EncodingException("Check symbol did not match. Expected[" + expectedUpper + "], Actual[" + actual + ']');
                        }
                        throw new EncodingException("Check symbol not found. Expected[" + expectedUpper + ']');
                    }
                    --outSize;
                } else {
                    boolean bl;
                    block8: {
                        char $this$isCheckSymbol_u24default$iv = actual;
                        boolean isConstantTime$iv = false;
                        boolean $i$f$isCheckSymbol = false;
                        boolean isSymbol$iv = false;
                        int n = "*~$=Uu".length();
                        for (int i = 0; i < n; ++i) {
                            char c$iv = "*~$=Uu".charAt(i);
                            if ($this$isCheckSymbol_u24default$iv != c$iv) continue;
                            bl = true;
                            break block8;
                        }
                        bl = isSymbol$iv;
                    }
                    if (bl) {
                        throw new EncodingException("Decoder Misconfiguration.\nEncoded data had Checksymbol[" + actual + "], but the decoder is configured to reject.");
                    }
                }
                long $this$decodeOutMaxSize$iv = outSize;
                boolean $i$f$decodeOutMaxSize = false;
                return (int)($this$decodeOutMaxSize$iv * 5L / 8L);
            }

            /*
             * WARNING - void declaration
             */
            protected long encodeOutSizeProtected(long unEncodedSize) {
                float hyphenCount;
                void $this$encodeOutSize$iv;
                long l = unEncodedSize;
                boolean willBePadded$iv = false;
                boolean $i$f$encodeOutSize = false;
                void outSize$iv = ($this$encodeOutSize$iv + 4L) / 5L * 8L;
                void var11_7 = $this$encodeOutSize$iv - ($this$encodeOutSize$iv - $this$encodeOutSize$iv % (long)5);
                if (var11_7 != 0L) {
                    if (var11_7 == 1L) {
                        outSize$iv -= 6L;
                    } else if (var11_7 == 2L) {
                        outSize$iv -= 4L;
                    } else if (var11_7 == 3L) {
                        outSize$iv -= 3L;
                    } else if (var11_7 == 4L) {
                        --outSize$iv;
                    }
                }
                void outSize = outSize$iv;
                if (this.checkSymbol != null) {
                    $this$encodeOutSize$iv = outSize;
                    outSize = $this$encodeOutSize$iv + 1L;
                }
                if (this.hyphenInterval > 0 && (hyphenCount = (float)outSize / (float)this.hyphenInterval - 1.0f) > 0.0f) {
                    outSize += (long)hyphenCount;
                    if (hyphenCount % 1.0f > 0.0f) {
                        void var6_9 = outSize;
                        outSize = var6_9 + 1L;
                    }
                }
                return (long)outSize;
            }

            @NotNull
            protected Set<EncoderDecoder.Config.Setting> toStringAddSettings() {
                LinkedHashSet<EncoderDecoder.Config.Setting> linkedHashSet;
                LinkedHashSet<EncoderDecoder.Config.Setting> $this$toStringAddSettings_u24lambda_u240 = linkedHashSet = new LinkedHashSet<EncoderDecoder.Config.Setting>(6, 1.0f);
                boolean bl = false;
                $this$toStringAddSettings_u24lambda_u240.add(new EncoderDecoder.Config.Setting((EncoderDecoder.Config)this, "encodeToLowercase", (Object)this.encodeToLowercase));
                $this$toStringAddSettings_u24lambda_u240.add(new EncoderDecoder.Config.Setting((EncoderDecoder.Config)this, "hyphenInterval", (Object)this.hyphenInterval));
                $this$toStringAddSettings_u24lambda_u240.add(new EncoderDecoder.Config.Setting((EncoderDecoder.Config)this, "checkSymbol", (Object)this.checkSymbol));
                $this$toStringAddSettings_u24lambda_u240.add(new EncoderDecoder.Config.Setting((EncoderDecoder.Config)this, "finalizeWhenFlushed", (Object)this.finalizeWhenFlushed));
                $this$toStringAddSettings_u24lambda_u240.add(new EncoderDecoder.Config.Setting((EncoderDecoder.Config)this, "isConstantTime", (Object)this.isConstantTime));
                return linkedHashSet;
            }

            public /* synthetic */ Config(boolean isLenient, boolean encodeToLowercase, byte hyphenInterval, Character checkSymbol, boolean finalizeWhenFlushed, DefaultConstructorMarker $constructor_marker) {
                this(isLenient, encodeToLowercase, hyphenInterval, checkSymbol, finalizeWhenFlushed);
            }

            @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\b\u00a8\u0006\t"}, d2={"Lio/matthewnelson/encoding/base32/Base32$Crockford$Config$Companion;", "", "<init>", "()V", "from", "Lio/matthewnelson/encoding/base32/Base32$Crockford$Config;", "builder", "Lio/matthewnelson/encoding/base32/Base32CrockfordConfigBuilder;", "from$io_matthewnelson_encoding_base32_jvm", "io.matthewnelson.encoding_base32_jvm"})
            public static final class Companion {
                private Companion() {
                }

                public final /* synthetic */ Config from$io_matthewnelson_encoding_base32_jvm(Base32CrockfordConfigBuilder builder) {
                    Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                    return new Config(builder.isLenient, builder.encodeToLowercase, builder.hyphenInterval > 0 ? builder.hyphenInterval : (byte)0, builder.checkSymbol(), builder.finalizeWhenFlushed, null);
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lio/matthewnelson/encoding/base32/Base32$DecodingBuffer;", "Lio/matthewnelson/encoding/core/util/FeedBuffer;", "out", "Lio/matthewnelson/encoding/core/Decoder$OutFeed;", "<init>", "(Lio/matthewnelson/encoding/base32/Base32;Lio/matthewnelson/encoding/core/Decoder$OutFeed;)V", "io.matthewnelson.encoding_base32_jvm"})
    private final class DecodingBuffer
    extends FeedBuffer {
        public DecodingBuffer(Decoder.OutFeed out) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            super(8, arg_0 -> DecodingBuffer._init_$lambda$0(out, arg_0), (arg_0, arg_1) -> DecodingBuffer._init_$lambda$1(out, arg_0, arg_1));
        }

        private static final void _init_$lambda$0(Decoder.OutFeed $out, int[] buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            long bitBuffer = 0L;
            for (int bits : buffer) {
                bitBuffer = bitBuffer << 5 | (long)bits;
            }
            $out.output((byte)(bitBuffer >> 32));
            $out.output((byte)(bitBuffer >> 24));
            $out.output((byte)(bitBuffer >> 16));
            $out.output((byte)(bitBuffer >> 8));
            $out.output((byte)bitBuffer);
        }

        private static final void _init_$lambda$1(Decoder.OutFeed $out, int modulus, int[] buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            switch (modulus) {
                case 1: 
                case 3: 
                case 6: {
                    throw FeedBuffer.Companion.truncatedInputEncodingException(modulus);
                }
            }
            long bitBuffer = 0L;
            for (int i = 0; i < modulus; ++i) {
                bitBuffer = bitBuffer << 5 | (long)buffer[i];
            }
            switch (modulus) {
                case 0: {
                    break;
                }
                case 2: {
                    $out.output((byte)(bitBuffer >>= 2));
                    break;
                }
                case 4: {
                    $out.output((byte)((bitBuffer >>= 4) >> 8));
                    $out.output((byte)bitBuffer);
                    break;
                }
                case 5: {
                    $out.output((byte)((bitBuffer >>= 1) >> 16));
                    $out.output((byte)(bitBuffer >> 8));
                    $out.output((byte)bitBuffer);
                    break;
                }
                case 7: {
                    $out.output((byte)((bitBuffer >>= 3) >> 24));
                    $out.output((byte)(bitBuffer >> 16));
                    $out.output((byte)(bitBuffer >> 8));
                    $out.output((byte)bitBuffer);
                }
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0011\u0012B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0006\u001a\f0\u0007R\b\u0012\u0004\u0012\u00020\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u001a\u0010\u000b\u001a\f0\fR\b\u0012\u0004\u0012\u00020\u00020\r2\u0006\u0010\t\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\u0010H\u0014\u00a8\u0006\u0013"}, d2={"Lio/matthewnelson/encoding/base32/Base32$Default;", "Lio/matthewnelson/encoding/base32/Base32;", "Lio/matthewnelson/encoding/base32/Base32$Default$Config;", "config", "<init>", "(Lio/matthewnelson/encoding/base32/Base32$Default$Config;)V", "newDecoderFeedProtected", "Lio/matthewnelson/encoding/core/Decoder$Feed;", "Lio/matthewnelson/encoding/core/Decoder;", "out", "Lio/matthewnelson/encoding/core/Decoder$OutFeed;", "newEncoderFeedProtected", "Lio/matthewnelson/encoding/core/Encoder$Feed;", "Lio/matthewnelson/encoding/core/Encoder;", "Lio/matthewnelson/encoding/core/Encoder$OutFeed;", "name", "", "Config", "Companion", "io.matthewnelson.encoding_base32_jvm"})
    public static final class Default
    extends Base32<Config> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        public static final String CHARS_UPPER = "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567";
        @NotNull
        public static final String CHARS_LOWER = "abcdefghijklmnopqrstuvwxyz234567";
        @NotNull
        private static final Default DELEGATE = new Default((Config)Companion.getConfig());

        public Default(@NotNull Config config) {
            Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
            super(config, null);
        }

        @NotNull
        protected Decoder.Feed newDecoderFeedProtected(@NotNull Decoder.OutFeed out) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            return new Decoder.Feed(this, out){
                private final DecodingBuffer buffer;
                {
                    this.buffer = $receiver.new DecodingBuffer($out);
                }

                protected void consumeProtected(char input) throws EncodingException {
                    char code = input;
                    int ge2 = code >= '2' ? 1 : 0;
                    int le7 = code <= '7' ? 1 : 0;
                    int geA = code >= 'A' ? 1 : 0;
                    int leZ = code <= 'Z' ? 1 : 0;
                    int gea = code >= 'a' ? 1 : 0;
                    int lez = code <= 'z' ? 1 : 0;
                    int diff = 0;
                    diff += ge2 + le7 == 2 ? -24 : 0;
                    diff += geA + leZ == 2 ? -65 : 0;
                    if ((diff += gea + lez == 2 ? -97 : 0) == 0) {
                        throw new EncodingException("Char[" + input + "] is not a valid Base32 Default character");
                    }
                    this.buffer.update(code + diff);
                }

                protected void doFinalProtected() throws EncodingException {
                    this.buffer.finalize();
                }
            };
        }

        @NotNull
        protected Encoder.Feed newEncoderFeedProtected(@NotNull Encoder.OutFeed out) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            return new Encoder.Feed(this, out){
                private final EncodingBuffer buffer;
                {
                    this.buffer = $receiver.new EncodingBuffer($out, ((Config)this.getConfig()).encodeToLowercase ? "abcdefghijklmnopqrstuvwxyz234567" : "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567", ((Config)this.getConfig()).padEncoded ? ((Config)this.getConfig()).paddingChar : null);
                }

                protected void consumeProtected(byte input) {
                    this.buffer.update(input);
                }

                protected void doFinalProtected() {
                    this.buffer.finalize();
                }
            };
        }

        @NotNull
        protected String name() {
            return "Base32.Default";
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\n\u001a\u00020\u0006H\u0014J\u001a\u0010\u000b\u001a\f0\fR\b\u0012\u0004\u0012\u00020\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u001a\u0010\u0010\u001a\f0\u0011R\b\u0012\u0004\u0012\u00020\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u0013H\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/matthewnelson/encoding/base32/Base32$Default$Companion;", "Lio/matthewnelson/encoding/core/EncoderDecoder;", "Lio/matthewnelson/encoding/base32/Base32$Default$Config;", "<init>", "()V", "CHARS_UPPER", "", "CHARS_LOWER", "DELEGATE", "Lio/matthewnelson/encoding/base32/Base32$Default;", "name", "newDecoderFeedProtected", "Lio/matthewnelson/encoding/core/Decoder$Feed;", "Lio/matthewnelson/encoding/core/Decoder;", "out", "Lio/matthewnelson/encoding/core/Decoder$OutFeed;", "newEncoderFeedProtected", "Lio/matthewnelson/encoding/core/Encoder$Feed;", "Lio/matthewnelson/encoding/core/Encoder;", "Lio/matthewnelson/encoding/core/Encoder$OutFeed;", "io.matthewnelson.encoding_base32_jvm"})
        @SourceDebugExtension(value={"SMAP\nBase32.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Base32.kt\nio/matthewnelson/encoding/base32/Base32$Default$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1012:1\n1#2:1013\n*E\n"})
        public static final class Companion
        extends EncoderDecoder<Config> {
            private Companion() {
                Base32DefaultConfigBuilder base32DefaultConfigBuilder;
                Base32DefaultConfigBuilder base32DefaultConfigBuilder2 = base32DefaultConfigBuilder = new Base32DefaultConfigBuilder();
                Companion companion = this;
                boolean bl = false;
                $this$_init__u24lambda_u240.lineBreakInterval = (byte)64;
                super((EncoderDecoder.Config)base32DefaultConfigBuilder.build());
            }

            @NotNull
            protected String name() {
                return DELEGATE.name();
            }

            @NotNull
            protected Decoder.Feed newDecoderFeedProtected(@NotNull Decoder.OutFeed out) {
                Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                return DELEGATE.newDecoderFeedProtected(out);
            }

            @NotNull
            protected Encoder.Feed newEncoderFeedProtected(@NotNull Encoder.OutFeed out) {
                Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                return DELEGATE.newEncoderFeedProtected(out);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B)\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0014J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000bH\u0014J\u0012\u0010\u0013\u001a\f\u0012\b\u0012\u00060\u0015R\u00020\u00010\u0014H\u0014R\u0010\u0010\u0006\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u00020\u00038\u0006X\u0087D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/matthewnelson/encoding/base32/Base32$Default$Config;", "Lio/matthewnelson/encoding/core/EncoderDecoder$Config;", "isLenient", "", "lineBreakInterval", "", "encodeToLowercase", "padEncoded", "<init>", "(ZBZZ)V", "decodeOutMaxSizeProtected", "", "encodedSize", "decodeOutMaxSizeOrFailProtected", "", "input", "Lio/matthewnelson/encoding/core/util/DecoderInput;", "encodeOutSizeProtected", "unEncodedSize", "toStringAddSettings", "", "Lio/matthewnelson/encoding/core/EncoderDecoder$Config$Setting;", "isConstantTime", "Companion", "io.matthewnelson.encoding_base32_jvm"})
        @SourceDebugExtension(value={"SMAP\nBase32.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Base32.kt\nio/matthewnelson/encoding/base32/Base32$Default$Config\n+ 2 -Math.kt\nio/matthewnelson/encoding/base32/internal/_MathKt\n*L\n1#1,1012:1\n21#2:1013\n21#2:1014\n25#2,12:1015\n*S KotlinDebug\n*F\n+ 1 Base32.kt\nio/matthewnelson/encoding/base32/Base32$Default$Config\n*L\n491#1:1013\n495#1:1014\n499#1:1015,12\n*E\n"})
        public static final class Config
        extends EncoderDecoder.Config {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @JvmField
            public final boolean encodeToLowercase;
            @JvmField
            public final boolean padEncoded;
            @JvmField
            public final boolean isConstantTime;

            private Config(boolean isLenient, byte lineBreakInterval, boolean encodeToLowercase, boolean padEncoded) {
                super(Boolean.valueOf(isLenient), lineBreakInterval, Character.valueOf('='));
                this.encodeToLowercase = encodeToLowercase;
                this.padEncoded = padEncoded;
                this.isConstantTime = true;
            }

            protected long decodeOutMaxSizeProtected(long encodedSize) {
                long $this$decodeOutMaxSize$iv = encodedSize;
                boolean $i$f$decodeOutMaxSize = false;
                return $this$decodeOutMaxSize$iv * 5L / 8L;
            }

            protected int decodeOutMaxSizeOrFailProtected(int encodedSize, @NotNull DecoderInput input) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                long $this$decodeOutMaxSize$iv = encodedSize;
                boolean $i$f$decodeOutMaxSize = false;
                return (int)($this$decodeOutMaxSize$iv * 5L / 8L);
            }

            /*
             * WARNING - void declaration
             */
            protected long encodeOutSizeProtected(long unEncodedSize) {
                void v0;
                void $this$encodeOutSize$iv;
                long l = unEncodedSize;
                boolean willBePadded$iv = this.padEncoded;
                boolean $i$f$encodeOutSize = false;
                void outSize$iv = ($this$encodeOutSize$iv + 4L) / 5L * 8L;
                if (willBePadded$iv) {
                    v0 = outSize$iv;
                } else {
                    void var9_6 = $this$encodeOutSize$iv - ($this$encodeOutSize$iv - $this$encodeOutSize$iv % (long)5);
                    if (var9_6 != 0L) {
                        if (var9_6 == 1L) {
                            outSize$iv -= 6L;
                        } else if (var9_6 == 2L) {
                            outSize$iv -= 4L;
                        } else if (var9_6 == 3L) {
                            outSize$iv -= 3L;
                        } else if (var9_6 == 4L) {
                            // empty if block
                        }
                    }
                    v0 = --outSize$iv;
                }
                return (long)v0;
            }

            @NotNull
            protected Set<EncoderDecoder.Config.Setting> toStringAddSettings() {
                LinkedHashSet<EncoderDecoder.Config.Setting> linkedHashSet;
                LinkedHashSet<EncoderDecoder.Config.Setting> $this$toStringAddSettings_u24lambda_u240 = linkedHashSet = new LinkedHashSet<EncoderDecoder.Config.Setting>(4, 1.0f);
                boolean bl = false;
                $this$toStringAddSettings_u24lambda_u240.add(new EncoderDecoder.Config.Setting((EncoderDecoder.Config)this, "encodeToLowercase", (Object)this.encodeToLowercase));
                $this$toStringAddSettings_u24lambda_u240.add(new EncoderDecoder.Config.Setting((EncoderDecoder.Config)this, "padEncoded", (Object)this.padEncoded));
                $this$toStringAddSettings_u24lambda_u240.add(new EncoderDecoder.Config.Setting((EncoderDecoder.Config)this, "isConstantTime", (Object)this.isConstantTime));
                return linkedHashSet;
            }

            public /* synthetic */ Config(boolean isLenient, byte lineBreakInterval, boolean encodeToLowercase, boolean padEncoded, DefaultConstructorMarker $constructor_marker) {
                this(isLenient, lineBreakInterval, encodeToLowercase, padEncoded);
            }

            @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\b\u00a8\u0006\t"}, d2={"Lio/matthewnelson/encoding/base32/Base32$Default$Config$Companion;", "", "<init>", "()V", "from", "Lio/matthewnelson/encoding/base32/Base32$Default$Config;", "builder", "Lio/matthewnelson/encoding/base32/Base32DefaultConfigBuilder;", "from$io_matthewnelson_encoding_base32_jvm", "io.matthewnelson.encoding_base32_jvm"})
            public static final class Companion {
                private Companion() {
                }

                public final /* synthetic */ Config from$io_matthewnelson_encoding_base32_jvm(Base32DefaultConfigBuilder builder) {
                    Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                    return new Config(builder.isLenient, builder.lineBreakInterval, builder.encodeToLowercase, builder.padEncoded, null);
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lio/matthewnelson/encoding/base32/Base32$EncodingBuffer;", "Lio/matthewnelson/encoding/core/util/FeedBuffer;", "out", "Lio/matthewnelson/encoding/core/Encoder$OutFeed;", "table", "", "paddingChar", "", "<init>", "(Lio/matthewnelson/encoding/base32/Base32;Lio/matthewnelson/encoding/core/Encoder$OutFeed;Ljava/lang/CharSequence;Ljava/lang/Character;)V", "io.matthewnelson.encoding_base32_jvm"})
    @SourceDebugExtension(value={"SMAP\nBase32.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Base32.kt\nio/matthewnelson/encoding/base32/Base32$EncodingBuffer\n+ 2 -Math.kt\nio/matthewnelson/encoding/base32/internal/_MathKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1012:1\n40#2:1013\n40#2:1014\n1#3:1015\n*S KotlinDebug\n*F\n+ 1 Base32.kt\nio/matthewnelson/encoding/base32/Base32$EncodingBuffer\n*L\n910#1:1013\n938#1:1014\n*E\n"})
    private final class EncodingBuffer
    extends FeedBuffer {
        public EncodingBuffer(@NotNull Encoder.OutFeed out, @Nullable CharSequence table, Character paddingChar) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            super(5, arg_0 -> EncodingBuffer._init_$lambda$0(out, table, arg_0), (arg_0, arg_1) -> EncodingBuffer._init_$lambda$2(out, table, paddingChar, arg_0, arg_1));
        }

        private static final void _init_$lambda$0(Encoder.OutFeed $out, CharSequence $table, int[] buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            long bitBuffer = 0L;
            for (int bits : buffer) {
                byte $this$toBits$iv = (byte)bits;
                boolean $i$f$toBits = false;
                bitBuffer = (bitBuffer << 8) + ($this$toBits$iv < 0 ? (long)$this$toBits$iv + 256L : (long)$this$toBits$iv);
            }
            int i1 = (int)(bitBuffer >> 35 & 0x1FL);
            int i2 = (int)(bitBuffer >> 30 & 0x1FL);
            int i3 = (int)(bitBuffer >> 25 & 0x1FL);
            int i4 = (int)(bitBuffer >> 20 & 0x1FL);
            int i5 = (int)(bitBuffer >> 15 & 0x1FL);
            int i6 = (int)(bitBuffer >> 10 & 0x1FL);
            int i7 = (int)(bitBuffer >> 5 & 0x1FL);
            int i8 = (int)(bitBuffer & 0x1FL);
            $out.output($table.charAt(i1));
            $out.output($table.charAt(i2));
            $out.output($table.charAt(i3));
            $out.output($table.charAt(i4));
            $out.output($table.charAt(i5));
            $out.output($table.charAt(i6));
            $out.output($table.charAt(i7));
            $out.output($table.charAt(i8));
        }

        private static final void _init_$lambda$2(Encoder.OutFeed $out, CharSequence $table, Character $paddingChar, int modulus, int[] buffer) {
            int padCount;
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            long bitBuffer = 0L;
            for (int i = 0; i < modulus; ++i) {
                byte $this$toBits$iv = (byte)buffer[i];
                boolean $i$f$toBits = false;
                bitBuffer = (bitBuffer << 8) + ($this$toBits$iv < 0 ? (long)$this$toBits$iv + 256L : (long)$this$toBits$iv);
            }
            switch (modulus) {
                case 0: {
                    int n = 0;
                    break;
                }
                case 1: {
                    int i1 = (int)(bitBuffer >> 3 & 0x1FL);
                    int i2 = (int)(bitBuffer << 2 & 0x1FL);
                    $out.output($table.charAt(i1));
                    $out.output($table.charAt(i2));
                    int n = 6;
                    break;
                }
                case 2: {
                    int i1 = (int)(bitBuffer >> 11 & 0x1FL);
                    int i2 = (int)(bitBuffer >> 6 & 0x1FL);
                    int i3 = (int)(bitBuffer >> 1 & 0x1FL);
                    int i4 = (int)(bitBuffer << 4 & 0x1FL);
                    $out.output($table.charAt(i1));
                    $out.output($table.charAt(i2));
                    $out.output($table.charAt(i3));
                    $out.output($table.charAt(i4));
                    int n = 4;
                    break;
                }
                case 3: {
                    int i1 = (int)(bitBuffer >> 19 & 0x1FL);
                    int i2 = (int)(bitBuffer >> 14 & 0x1FL);
                    int i3 = (int)(bitBuffer >> 9 & 0x1FL);
                    int i4 = (int)(bitBuffer >> 4 & 0x1FL);
                    int i5 = (int)(bitBuffer << 1 & 0x1FL);
                    $out.output($table.charAt(i1));
                    $out.output($table.charAt(i2));
                    $out.output($table.charAt(i3));
                    $out.output($table.charAt(i4));
                    $out.output($table.charAt(i5));
                    int n = 3;
                    break;
                }
                default: {
                    int i1 = (int)(bitBuffer >> 27 & 0x1FL);
                    int i2 = (int)(bitBuffer >> 22 & 0x1FL);
                    int i3 = (int)(bitBuffer >> 17 & 0x1FL);
                    int i4 = (int)(bitBuffer >> 12 & 0x1FL);
                    int i5 = (int)(bitBuffer >> 7 & 0x1FL);
                    int i6 = (int)(bitBuffer >> 2 & 0x1FL);
                    int i7 = (int)(bitBuffer << 3 & 0x1FL);
                    $out.output($table.charAt(i1));
                    $out.output($table.charAt(i2));
                    $out.output($table.charAt(i3));
                    $out.output($table.charAt(i4));
                    $out.output($table.charAt(i5));
                    $out.output($table.charAt(i6));
                    $out.output($table.charAt(i7));
                    int n = padCount = 1;
                }
            }
            if ($paddingChar != null) {
                int n = 0;
                while (n < padCount) {
                    int it = n++;
                    boolean bl = false;
                    $out.output($paddingChar.charValue());
                }
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0011\u0012B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0006\u001a\f0\u0007R\b\u0012\u0004\u0012\u00020\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u001a\u0010\u000b\u001a\f0\fR\b\u0012\u0004\u0012\u00020\u00020\r2\u0006\u0010\t\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\u0010H\u0014\u00a8\u0006\u0013"}, d2={"Lio/matthewnelson/encoding/base32/Base32$Hex;", "Lio/matthewnelson/encoding/base32/Base32;", "Lio/matthewnelson/encoding/base32/Base32$Hex$Config;", "config", "<init>", "(Lio/matthewnelson/encoding/base32/Base32$Hex$Config;)V", "newDecoderFeedProtected", "Lio/matthewnelson/encoding/core/Decoder$Feed;", "Lio/matthewnelson/encoding/core/Decoder;", "out", "Lio/matthewnelson/encoding/core/Decoder$OutFeed;", "newEncoderFeedProtected", "Lio/matthewnelson/encoding/core/Encoder$Feed;", "Lio/matthewnelson/encoding/core/Encoder;", "Lio/matthewnelson/encoding/core/Encoder$OutFeed;", "name", "", "Config", "Companion", "io.matthewnelson.encoding_base32_jvm"})
    public static final class Hex
    extends Base32<Config> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        public static final String CHARS_UPPER = "0123456789ABCDEFGHIJKLMNOPQRSTUV";
        @NotNull
        public static final String CHARS_LOWER = "0123456789abcdefghijklmnopqrstuv";
        @NotNull
        private static final Hex DELEGATE = new Hex((Config)Companion.getConfig());

        public Hex(@NotNull Config config) {
            Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
            super(config, null);
        }

        @NotNull
        protected Decoder.Feed newDecoderFeedProtected(@NotNull Decoder.OutFeed out) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            return new Decoder.Feed(this, out){
                private final DecodingBuffer buffer;
                {
                    this.buffer = $receiver.new DecodingBuffer($out);
                }

                protected void consumeProtected(char input) throws EncodingException {
                    char code = input;
                    int ge0 = code >= '0' ? 1 : 0;
                    int le9 = code <= '9' ? 1 : 0;
                    int geA = code >= 'A' ? 1 : 0;
                    int leV = code <= 'V' ? 1 : 0;
                    int gea = code >= 'a' ? 1 : 0;
                    int lev = code <= 'v' ? 1 : 0;
                    int diff = 0;
                    diff += ge0 + le9 == 2 ? -48 : 0;
                    diff += geA + leV == 2 ? -55 : 0;
                    if ((diff += gea + lev == 2 ? -87 : 0) == 0) {
                        throw new EncodingException("Char[" + input + "] is not a valid Base32 Hex character");
                    }
                    this.buffer.update(code + diff);
                }

                protected void doFinalProtected() throws EncodingException {
                    this.buffer.finalize();
                }
            };
        }

        @NotNull
        protected Encoder.Feed newEncoderFeedProtected(@NotNull Encoder.OutFeed out) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            return new Encoder.Feed(this, out){
                private final EncodingBuffer buffer;
                {
                    this.buffer = $receiver.new EncodingBuffer($out, ((Config)this.getConfig()).encodeToLowercase ? "0123456789abcdefghijklmnopqrstuv" : "0123456789ABCDEFGHIJKLMNOPQRSTUV", ((Config)this.getConfig()).padEncoded ? ((Config)this.getConfig()).paddingChar : null);
                }

                protected void consumeProtected(byte input) {
                    this.buffer.update(input);
                }

                protected void doFinalProtected() {
                    this.buffer.finalize();
                }
            };
        }

        @NotNull
        protected String name() {
            return "Base32.Hex";
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\n\u001a\u00020\u0006H\u0014J\u001a\u0010\u000b\u001a\f0\fR\b\u0012\u0004\u0012\u00020\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u001a\u0010\u0010\u001a\f0\u0011R\b\u0012\u0004\u0012\u00020\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u0013H\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/matthewnelson/encoding/base32/Base32$Hex$Companion;", "Lio/matthewnelson/encoding/core/EncoderDecoder;", "Lio/matthewnelson/encoding/base32/Base32$Hex$Config;", "<init>", "()V", "CHARS_UPPER", "", "CHARS_LOWER", "DELEGATE", "Lio/matthewnelson/encoding/base32/Base32$Hex;", "name", "newDecoderFeedProtected", "Lio/matthewnelson/encoding/core/Decoder$Feed;", "Lio/matthewnelson/encoding/core/Decoder;", "out", "Lio/matthewnelson/encoding/core/Decoder$OutFeed;", "newEncoderFeedProtected", "Lio/matthewnelson/encoding/core/Encoder$Feed;", "Lio/matthewnelson/encoding/core/Encoder;", "Lio/matthewnelson/encoding/core/Encoder$OutFeed;", "io.matthewnelson.encoding_base32_jvm"})
        @SourceDebugExtension(value={"SMAP\nBase32.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Base32.kt\nio/matthewnelson/encoding/base32/Base32$Hex$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1012:1\n1#2:1013\n*E\n"})
        public static final class Companion
        extends EncoderDecoder<Config> {
            private Companion() {
                Base32HexConfigBuilder base32HexConfigBuilder;
                Base32HexConfigBuilder base32HexConfigBuilder2 = base32HexConfigBuilder = new Base32HexConfigBuilder();
                Companion companion = this;
                boolean bl = false;
                $this$_init__u24lambda_u240.lineBreakInterval = (byte)64;
                super((EncoderDecoder.Config)base32HexConfigBuilder.build());
            }

            @NotNull
            protected String name() {
                return DELEGATE.name();
            }

            @NotNull
            protected Decoder.Feed newDecoderFeedProtected(@NotNull Decoder.OutFeed out) {
                Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                return DELEGATE.newDecoderFeedProtected(out);
            }

            @NotNull
            protected Encoder.Feed newEncoderFeedProtected(@NotNull Encoder.OutFeed out) {
                Intrinsics.checkNotNullParameter((Object)out, (String)"out");
                return DELEGATE.newEncoderFeedProtected(out);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B)\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0014J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000bH\u0014J\u0012\u0010\u0013\u001a\f\u0012\b\u0012\u00060\u0015R\u00020\u00010\u0014H\u0014R\u0010\u0010\u0006\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u00020\u00038\u0006X\u0087D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/matthewnelson/encoding/base32/Base32$Hex$Config;", "Lio/matthewnelson/encoding/core/EncoderDecoder$Config;", "isLenient", "", "lineBreakInterval", "", "encodeToLowercase", "padEncoded", "<init>", "(ZBZZ)V", "decodeOutMaxSizeProtected", "", "encodedSize", "decodeOutMaxSizeOrFailProtected", "", "input", "Lio/matthewnelson/encoding/core/util/DecoderInput;", "encodeOutSizeProtected", "unEncodedSize", "toStringAddSettings", "", "Lio/matthewnelson/encoding/core/EncoderDecoder$Config$Setting;", "isConstantTime", "Companion", "io.matthewnelson.encoding_base32_jvm"})
        @SourceDebugExtension(value={"SMAP\nBase32.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Base32.kt\nio/matthewnelson/encoding/base32/Base32$Hex$Config\n+ 2 -Math.kt\nio/matthewnelson/encoding/base32/internal/_MathKt\n*L\n1#1,1012:1\n21#2:1013\n21#2:1014\n25#2,12:1015\n*S KotlinDebug\n*F\n+ 1 Base32.kt\nio/matthewnelson/encoding/base32/Base32$Hex$Config\n*L\n687#1:1013\n691#1:1014\n695#1:1015,12\n*E\n"})
        public static final class Config
        extends EncoderDecoder.Config {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @JvmField
            public final boolean encodeToLowercase;
            @JvmField
            public final boolean padEncoded;
            @JvmField
            public final boolean isConstantTime;

            private Config(boolean isLenient, byte lineBreakInterval, boolean encodeToLowercase, boolean padEncoded) {
                super(Boolean.valueOf(isLenient), lineBreakInterval, Character.valueOf('='));
                this.encodeToLowercase = encodeToLowercase;
                this.padEncoded = padEncoded;
                this.isConstantTime = true;
            }

            protected long decodeOutMaxSizeProtected(long encodedSize) {
                long $this$decodeOutMaxSize$iv = encodedSize;
                boolean $i$f$decodeOutMaxSize = false;
                return $this$decodeOutMaxSize$iv * 5L / 8L;
            }

            protected int decodeOutMaxSizeOrFailProtected(int encodedSize, @NotNull DecoderInput input) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                long $this$decodeOutMaxSize$iv = encodedSize;
                boolean $i$f$decodeOutMaxSize = false;
                return (int)($this$decodeOutMaxSize$iv * 5L / 8L);
            }

            /*
             * WARNING - void declaration
             */
            protected long encodeOutSizeProtected(long unEncodedSize) {
                void v0;
                void $this$encodeOutSize$iv;
                long l = unEncodedSize;
                boolean willBePadded$iv = this.padEncoded;
                boolean $i$f$encodeOutSize = false;
                void outSize$iv = ($this$encodeOutSize$iv + 4L) / 5L * 8L;
                if (willBePadded$iv) {
                    v0 = outSize$iv;
                } else {
                    void var9_6 = $this$encodeOutSize$iv - ($this$encodeOutSize$iv - $this$encodeOutSize$iv % (long)5);
                    if (var9_6 != 0L) {
                        if (var9_6 == 1L) {
                            outSize$iv -= 6L;
                        } else if (var9_6 == 2L) {
                            outSize$iv -= 4L;
                        } else if (var9_6 == 3L) {
                            outSize$iv -= 3L;
                        } else if (var9_6 == 4L) {
                            // empty if block
                        }
                    }
                    v0 = --outSize$iv;
                }
                return (long)v0;
            }

            @NotNull
            protected Set<EncoderDecoder.Config.Setting> toStringAddSettings() {
                LinkedHashSet<EncoderDecoder.Config.Setting> linkedHashSet;
                LinkedHashSet<EncoderDecoder.Config.Setting> $this$toStringAddSettings_u24lambda_u240 = linkedHashSet = new LinkedHashSet<EncoderDecoder.Config.Setting>(4, 1.0f);
                boolean bl = false;
                $this$toStringAddSettings_u24lambda_u240.add(new EncoderDecoder.Config.Setting((EncoderDecoder.Config)this, "encodeToLowercase", (Object)this.encodeToLowercase));
                $this$toStringAddSettings_u24lambda_u240.add(new EncoderDecoder.Config.Setting((EncoderDecoder.Config)this, "padEncoded", (Object)this.padEncoded));
                $this$toStringAddSettings_u24lambda_u240.add(new EncoderDecoder.Config.Setting((EncoderDecoder.Config)this, "isConstantTime", (Object)this.isConstantTime));
                return linkedHashSet;
            }

            public /* synthetic */ Config(boolean isLenient, byte lineBreakInterval, boolean encodeToLowercase, boolean padEncoded, DefaultConstructorMarker $constructor_marker) {
                this(isLenient, lineBreakInterval, encodeToLowercase, padEncoded);
            }

            @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\b\u00a8\u0006\t"}, d2={"Lio/matthewnelson/encoding/base32/Base32$Hex$Config$Companion;", "", "<init>", "()V", "from", "Lio/matthewnelson/encoding/base32/Base32$Hex$Config;", "builder", "Lio/matthewnelson/encoding/base32/Base32HexConfigBuilder;", "from$io_matthewnelson_encoding_base32_jvm", "io.matthewnelson.encoding_base32_jvm"})
            public static final class Companion {
                private Companion() {
                }

                public final /* synthetic */ Config from$io_matthewnelson_encoding_base32_jvm(Base32HexConfigBuilder builder) {
                    Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                    return new Config(builder.isLenient, builder.lineBreakInterval, builder.encodeToLowercase, builder.padEncoded, null);
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }
}

