/*
 * Decompiled with CFR 0.152.
 */
package io.matthewnelson.encoding.base64;

import io.matthewnelson.encoding.base64.Base64ConfigBuilder;
import io.matthewnelson.encoding.core.Decoder;
import io.matthewnelson.encoding.core.Encoder;
import io.matthewnelson.encoding.core.EncoderDecoder;
import io.matthewnelson.encoding.core.EncodingException;
import io.matthewnelson.encoding.core.util.DecoderInput;
import io.matthewnelson.encoding.core.util.FeedBuffer;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0005\u0011\u0012\u0013\u0014\u0015B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0006\u001a\f0\u0007R\b\u0012\u0004\u0012\u00020\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u001a\u0010\u000b\u001a\f0\fR\b\u0012\u0004\u0012\u00020\u00020\r2\u0006\u0010\t\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\u0010H\u0014\u00a8\u0006\u0016"}, d2={"Lio/matthewnelson/encoding/base64/Base64;", "Lio/matthewnelson/encoding/core/EncoderDecoder;", "Lio/matthewnelson/encoding/base64/Base64$Config;", "config", "<init>", "(Lio/matthewnelson/encoding/base64/Base64$Config;)V", "newDecoderFeedProtected", "Lio/matthewnelson/encoding/core/Decoder$Feed;", "Lio/matthewnelson/encoding/core/Decoder;", "out", "Lio/matthewnelson/encoding/core/Decoder$OutFeed;", "newEncoderFeedProtected", "Lio/matthewnelson/encoding/core/Encoder$Feed;", "Lio/matthewnelson/encoding/core/Encoder;", "Lio/matthewnelson/encoding/core/Encoder$OutFeed;", "name", "", "Config", "Default", "UrlSafe", "DecodingBuffer", "EncodingBuffer", "io.matthewnelson.encoding_base64_jvm"})
public final class Base64
extends EncoderDecoder<Config> {
    public Base64(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)((Object)config), (String)"config");
        super((EncoderDecoder.Config)config);
    }

    @NotNull
    protected Decoder.Feed newDecoderFeedProtected(@NotNull Decoder.OutFeed out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        return new Decoder.Feed(this, out){
            private final DecodingBuffer buffer;
            {
                this.buffer = $receiver.new DecodingBuffer($out);
            }

            protected void consumeProtected(char input) throws EncodingException {
                char code = input;
                int ge0 = code >= '0' ? 1 : 0;
                int le9 = code <= '9' ? 1 : 0;
                int geA = code >= 'A' ? 1 : 0;
                int leZ = code <= 'Z' ? 1 : 0;
                int gea = code >= 'a' ? 1 : 0;
                int lez = code <= 'z' ? 1 : 0;
                int eqPlu = code == '+' ? 1 : 0;
                int eqMin = code == '-' ? 1 : 0;
                int eqSla = code == '/' ? 1 : 0;
                int eqUSc = code == '_' ? 1 : 0;
                int diff = 0;
                diff += ge0 + le9 == 2 ? 4 : 0;
                diff += geA + leZ == 2 ? -65 : 0;
                diff += gea + lez == 2 ? -71 : 0;
                int h = 62 - code;
                int k = 63 - code;
                diff += eqPlu + eqMin == 1 ? h : 0;
                if ((diff += eqSla + eqUSc == 1 ? k : 0) == 0) {
                    throw new EncodingException("Char[" + input + "] is not a valid Base64 character");
                }
                this.buffer.update(code + diff);
            }

            protected void doFinalProtected() throws EncodingException {
                this.buffer.finalize();
            }
        };
    }

    @NotNull
    protected Encoder.Feed newEncoderFeedProtected(@NotNull Encoder.OutFeed out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        return new Encoder.Feed(this, out){
            private final EncodingBuffer buffer;
            {
                this.buffer = $receiver.new EncodingBuffer($out, ((Config)this.getConfig()).encodeToUrlSafe ? "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_" : "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/", ((Config)this.getConfig()).padEncoded ? ((Config)this.getConfig()).paddingChar : null);
            }

            protected void consumeProtected(byte input) {
                this.buffer.update(input);
            }

            protected void doFinalProtected() {
                this.buffer.finalize();
            }
        };
    }

    @NotNull
    protected String name() {
        return "Base64";
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B)\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0014J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000bH\u0014J\u0012\u0010\u0013\u001a\f\u0012\b\u0012\u00060\u0015R\u00020\u00010\u0014H\u0014R\u0010\u0010\u0006\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u00020\u00038\u0006X\u0087D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/matthewnelson/encoding/base64/Base64$Config;", "Lio/matthewnelson/encoding/core/EncoderDecoder$Config;", "isLenient", "", "lineBreakInterval", "", "encodeToUrlSafe", "padEncoded", "<init>", "(ZBZZ)V", "decodeOutMaxSizeProtected", "", "encodedSize", "decodeOutMaxSizeOrFailProtected", "", "input", "Lio/matthewnelson/encoding/core/util/DecoderInput;", "encodeOutSizeProtected", "unEncodedSize", "toStringAddSettings", "", "Lio/matthewnelson/encoding/core/EncoderDecoder$Config$Setting;", "isConstantTime", "Companion", "io.matthewnelson.encoding_base64_jvm"})
    public static final class Config
    extends EncoderDecoder.Config {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @JvmField
        public final boolean encodeToUrlSafe;
        @JvmField
        public final boolean padEncoded;
        @JvmField
        public final boolean isConstantTime;

        private Config(boolean isLenient, byte lineBreakInterval, boolean encodeToUrlSafe, boolean padEncoded) {
            super(Boolean.valueOf(isLenient), lineBreakInterval, Character.valueOf('='));
            this.encodeToUrlSafe = encodeToUrlSafe;
            this.padEncoded = padEncoded;
            this.isConstantTime = true;
        }

        protected long decodeOutMaxSizeProtected(long encodedSize) {
            return encodedSize * 6L / 8L;
        }

        protected int decodeOutMaxSizeOrFailProtected(int encodedSize, @NotNull DecoderInput input) throws EncodingException {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return (int)this.decodeOutMaxSizeProtected(encodedSize);
        }

        protected long encodeOutSizeProtected(long unEncodedSize) {
            long outSize = (unEncodedSize + 2L) / 3L * 4L;
            if (this.padEncoded) {
                return outSize;
            }
            long l = unEncodedSize - (unEncodedSize - unEncodedSize % (long)3);
            if (l != 0L) {
                if (l == 1L) {
                    outSize -= 2L;
                } else if (l == 2L) {
                    --outSize;
                }
            }
            return outSize;
        }

        @NotNull
        protected Set<EncoderDecoder.Config.Setting> toStringAddSettings() {
            LinkedHashSet<EncoderDecoder.Config.Setting> linkedHashSet;
            LinkedHashSet<EncoderDecoder.Config.Setting> $this$toStringAddSettings_u24lambda_u240 = linkedHashSet = new LinkedHashSet<EncoderDecoder.Config.Setting>(4, 1.0f);
            boolean bl = false;
            $this$toStringAddSettings_u24lambda_u240.add(new EncoderDecoder.Config.Setting((EncoderDecoder.Config)this, "encodeToUrlSafe", (Object)this.encodeToUrlSafe));
            $this$toStringAddSettings_u24lambda_u240.add(new EncoderDecoder.Config.Setting((EncoderDecoder.Config)this, "padEncoded", (Object)this.padEncoded));
            $this$toStringAddSettings_u24lambda_u240.add(new EncoderDecoder.Config.Setting((EncoderDecoder.Config)this, "isConstantTime", (Object)this.isConstantTime));
            return linkedHashSet;
        }

        public /* synthetic */ Config(boolean isLenient, byte lineBreakInterval, boolean encodeToUrlSafe, boolean padEncoded, DefaultConstructorMarker $constructor_marker) {
            this(isLenient, lineBreakInterval, encodeToUrlSafe, padEncoded);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\b\u00a8\u0006\t"}, d2={"Lio/matthewnelson/encoding/base64/Base64$Config$Companion;", "", "<init>", "()V", "from", "Lio/matthewnelson/encoding/base64/Base64$Config;", "builder", "Lio/matthewnelson/encoding/base64/Base64ConfigBuilder;", "from$io_matthewnelson_encoding_base64_jvm", "io.matthewnelson.encoding_base64_jvm"})
        public static final class Companion {
            private Companion() {
            }

            public final /* synthetic */ Config from$io_matthewnelson_encoding_base64_jvm(Base64ConfigBuilder builder) {
                Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
                return new Config(builder.isLenient, builder.lineBreakInterval, builder.encodeToUrlSafe, builder.padEncoded, null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lio/matthewnelson/encoding/base64/Base64$DecodingBuffer;", "Lio/matthewnelson/encoding/core/util/FeedBuffer;", "out", "Lio/matthewnelson/encoding/core/Decoder$OutFeed;", "<init>", "(Lio/matthewnelson/encoding/base64/Base64;Lio/matthewnelson/encoding/core/Decoder$OutFeed;)V", "io.matthewnelson.encoding_base64_jvm"})
    private final class DecodingBuffer
    extends FeedBuffer {
        public DecodingBuffer(Decoder.OutFeed out) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            super(4, arg_0 -> DecodingBuffer._init_$lambda$0(out, arg_0), (arg_0, arg_1) -> DecodingBuffer._init_$lambda$1(out, arg_0, arg_1));
        }

        private static final void _init_$lambda$0(Decoder.OutFeed $out, int[] buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            int bitBuffer = 0;
            for (int bits : buffer) {
                bitBuffer = bitBuffer << 6 | bits;
            }
            $out.output((byte)(bitBuffer >> 16));
            $out.output((byte)(bitBuffer >> 8));
            $out.output((byte)bitBuffer);
        }

        private static final void _init_$lambda$1(Decoder.OutFeed $out, int modulus, int[] buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            if (modulus == 1) {
                throw FeedBuffer.Companion.truncatedInputEncodingException(modulus);
            }
            int bitBuffer = 0;
            for (int i = 0; i < modulus; ++i) {
                bitBuffer = bitBuffer << 6 | buffer[i];
            }
            switch (modulus) {
                case 0: {
                    break;
                }
                case 2: {
                    $out.output((byte)((bitBuffer <<= 12) >> 16));
                    break;
                }
                case 3: {
                    $out.output((byte)((bitBuffer <<= 6) >> 16));
                    $out.output((byte)(bitBuffer >> 8));
                }
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\t\u001a\u00020\u0006H\u0014J\u001a\u0010\n\u001a\f0\u000bR\b\u0012\u0004\u0012\u00020\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u001a\u0010\u000f\u001a\f0\u0010R\b\u0012\u0004\u0012\u00020\u00020\u00112\u0006\u0010\r\u001a\u00020\u0012H\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/matthewnelson/encoding/base64/Base64$Default;", "Lio/matthewnelson/encoding/core/EncoderDecoder;", "Lio/matthewnelson/encoding/base64/Base64$Config;", "<init>", "()V", "CHARS", "", "DELEGATE", "Lio/matthewnelson/encoding/base64/Base64;", "name", "newDecoderFeedProtected", "Lio/matthewnelson/encoding/core/Decoder$Feed;", "Lio/matthewnelson/encoding/core/Decoder;", "out", "Lio/matthewnelson/encoding/core/Decoder$OutFeed;", "newEncoderFeedProtected", "Lio/matthewnelson/encoding/core/Encoder$Feed;", "Lio/matthewnelson/encoding/core/Encoder;", "Lio/matthewnelson/encoding/core/Encoder$OutFeed;", "io.matthewnelson.encoding_base64_jvm"})
    @SourceDebugExtension(value={"SMAP\nBase64.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Base64.kt\nio/matthewnelson/encoding/base64/Base64$Default\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,382:1\n1#2:383\n*E\n"})
    public static final class Default
    extends EncoderDecoder<Config> {
        @NotNull
        public static final Default INSTANCE = new Default();
        @NotNull
        public static final String CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
        @NotNull
        private static final Base64 DELEGATE = new Base64((Config)INSTANCE.getConfig());

        private Default() {
            Base64ConfigBuilder base64ConfigBuilder;
            Base64ConfigBuilder base64ConfigBuilder2 = base64ConfigBuilder = new Base64ConfigBuilder();
            Default default_ = this;
            boolean bl = false;
            $this$_init__u24lambda_u240.lineBreakInterval = (byte)64;
            super((EncoderDecoder.Config)base64ConfigBuilder.build());
        }

        @NotNull
        protected String name() {
            return DELEGATE.name();
        }

        @NotNull
        protected Decoder.Feed newDecoderFeedProtected(@NotNull Decoder.OutFeed out) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            return DELEGATE.newDecoderFeedProtected(out);
        }

        @NotNull
        protected Encoder.Feed newEncoderFeedProtected(@NotNull Encoder.OutFeed out) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            return DELEGATE.newEncoderFeedProtected(out);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lio/matthewnelson/encoding/base64/Base64$EncodingBuffer;", "Lio/matthewnelson/encoding/core/util/FeedBuffer;", "out", "Lio/matthewnelson/encoding/core/Encoder$OutFeed;", "table", "", "paddingChar", "", "<init>", "(Lio/matthewnelson/encoding/base64/Base64;Lio/matthewnelson/encoding/core/Encoder$OutFeed;Ljava/lang/CharSequence;Ljava/lang/Character;)V", "io.matthewnelson.encoding_base64_jvm"})
    @SourceDebugExtension(value={"SMAP\nBase64.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Base64.kt\nio/matthewnelson/encoding/base64/Base64$EncodingBuffer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,382:1\n1#2:383\n*E\n"})
    private final class EncodingBuffer
    extends FeedBuffer {
        public EncodingBuffer(@NotNull Encoder.OutFeed out, @Nullable CharSequence table, Character paddingChar) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            Intrinsics.checkNotNullParameter((Object)table, (String)"table");
            super(3, arg_0 -> EncodingBuffer._init_$lambda$0(out, table, arg_0), (arg_0, arg_1) -> EncodingBuffer._init_$lambda$2(out, table, paddingChar, arg_0, arg_1));
        }

        private static final void _init_$lambda$0(Encoder.OutFeed $out, CharSequence $table, int[] buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            int b0 = buffer[0];
            int b1 = buffer[1];
            int b2 = buffer[2];
            int i1 = (b0 & 0xFF) >> 2;
            int i2 = (b0 & 3) << 4 | (b1 & 0xFF) >> 4;
            int i3 = (b1 & 0xF) << 2 | (b2 & 0xFF) >> 6;
            int i4 = b2 & 0x3F;
            $out.output($table.charAt(i1));
            $out.output($table.charAt(i2));
            $out.output($table.charAt(i3));
            $out.output($table.charAt(i4));
        }

        private static final void _init_$lambda$2(Encoder.OutFeed $out, CharSequence $table, Character $paddingChar, int modulus, int[] buffer) {
            int padCount;
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            switch (modulus) {
                case 0: {
                    int n = 0;
                    break;
                }
                case 1: {
                    int b0 = buffer[0];
                    int i1 = (b0 & 0xFF) >> 2;
                    int i2 = (b0 & 3) << 4;
                    $out.output($table.charAt(i1));
                    $out.output($table.charAt(i2));
                    int n = 2;
                    break;
                }
                default: {
                    int b0 = buffer[0];
                    int b1 = buffer[1];
                    int i1 = (b0 & 0xFF) >> 2;
                    int i2 = (b0 & 3) << 4 | (b1 & 0xFF) >> 4;
                    int i3 = (b1 & 0xF) << 2;
                    $out.output($table.charAt(i1));
                    $out.output($table.charAt(i2));
                    $out.output($table.charAt(i3));
                    int n = padCount = 1;
                }
            }
            if ($paddingChar != null) {
                int n = 0;
                while (n < padCount) {
                    int it = n++;
                    boolean bl = false;
                    $out.output($paddingChar.charValue());
                }
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\t\u001a\u00020\u0006H\u0014J\u001a\u0010\n\u001a\f0\u000bR\b\u0012\u0004\u0012\u00020\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u001a\u0010\u000f\u001a\f0\u0010R\b\u0012\u0004\u0012\u00020\u00020\u00112\u0006\u0010\r\u001a\u00020\u0012H\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/matthewnelson/encoding/base64/Base64$UrlSafe;", "Lio/matthewnelson/encoding/core/EncoderDecoder;", "Lio/matthewnelson/encoding/base64/Base64$Config;", "<init>", "()V", "CHARS", "", "DELEGATE", "Lio/matthewnelson/encoding/base64/Base64;", "name", "newDecoderFeedProtected", "Lio/matthewnelson/encoding/core/Decoder$Feed;", "Lio/matthewnelson/encoding/core/Decoder;", "out", "Lio/matthewnelson/encoding/core/Decoder$OutFeed;", "newEncoderFeedProtected", "Lio/matthewnelson/encoding/core/Encoder$Feed;", "Lio/matthewnelson/encoding/core/Encoder;", "Lio/matthewnelson/encoding/core/Encoder$OutFeed;", "io.matthewnelson.encoding_base64_jvm"})
    @SourceDebugExtension(value={"SMAP\nBase64.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Base64.kt\nio/matthewnelson/encoding/base64/Base64$UrlSafe\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,382:1\n1#2:383\n*E\n"})
    public static final class UrlSafe
    extends EncoderDecoder<Config> {
        @NotNull
        public static final UrlSafe INSTANCE = new UrlSafe();
        @NotNull
        public static final String CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_";
        @NotNull
        private static final Base64 DELEGATE = new Base64((Config)INSTANCE.getConfig());

        private UrlSafe() {
            Base64ConfigBuilder base64ConfigBuilder;
            Base64ConfigBuilder base64ConfigBuilder2 = base64ConfigBuilder = new Base64ConfigBuilder((Config)Default.INSTANCE.getConfig());
            UrlSafe urlSafe = this;
            boolean bl = false;
            $this$_init__u24lambda_u240.encodeToUrlSafe = true;
            super((EncoderDecoder.Config)base64ConfigBuilder.build());
        }

        @NotNull
        protected String name() {
            return DELEGATE.name();
        }

        @NotNull
        protected Decoder.Feed newDecoderFeedProtected(@NotNull Decoder.OutFeed out) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            return DELEGATE.newDecoderFeedProtected(out);
        }

        @NotNull
        protected Encoder.Feed newEncoderFeedProtected(@NotNull Encoder.OutFeed out) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            return DELEGATE.newEncoderFeedProtected(out);
        }
    }
}

