/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.vercred.vcverifier;

import io.mosip.vercred.vcverifier.exception.DidResolverExceptions;
import io.mosip.vercred.vcverifier.networkManager.HTTP_METHOD;
import io.mosip.vercred.vcverifier.networkManager.NetworkManagerClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0002\u000b\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\b\u001a\u00020\u0007H\u0002J\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/mosip/vercred/vcverifier/DidWebResolver;", "", "didUrl", "", "(Ljava/lang/String;)V", "constructDIDUrl", "parsedDid", "Lio/mosip/vercred/vcverifier/DidWebResolver$ParsedDID;", "parseDidUrl", "resolve", "", "Companion", "ParsedDID", "vcverifier_release"})
@SourceDebugExtension(value={"SMAP\nDidWebResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DidWebResolver.kt\nio/mosip/vercred/vcverifier/DidWebResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n1549#2:93\n1620#2,3:94\n766#2:97\n857#2,2:98\n1179#2,2:100\n1253#2,4:102\n*S KotlinDebug\n*F\n+ 1 DidWebResolver.kt\nio/mosip/vercred/vcverifier/DidWebResolver\n*L\n40#1:93\n40#1:94,3\n68#1:97\n68#1:98,2\n69#1:100,2\n69#1:102,4\n*E\n"})
public final class DidWebResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String didUrl;
    @NotNull
    private static final String PCT_ENCODED = "(?:%[0-9a-fA-F]{2})";
    @NotNull
    private static final String ID_CHAR = "(?:[a-zA-Z0-9._-]|(?:%[0-9a-fA-F]{2}))";
    @NotNull
    private static final String METHOD = "([a-z0-9]+)";
    @NotNull
    private static final String METHOD_ID = "((?:(?:[a-zA-Z0-9._-]|(?:%[0-9a-fA-F]{2}))*:)*((?:[a-zA-Z0-9._-]|(?:%[0-9a-fA-F]{2}))+))";
    @NotNull
    private static final String PARAM_CHAR = "[a-zA-Z0-9_.:%-]";
    @NotNull
    private static final String PARAM = ";[a-zA-Z0-9_.:%-]+=[a-zA-Z0-9_.:%-]*";
    @NotNull
    private static final String PARAMS = "((;[a-zA-Z0-9_.:%-]+=[a-zA-Z0-9_.:%-]*)*)";
    @NotNull
    private static final String PATH = "(/[^#?]*)?";
    @NotNull
    private static final String QUERY = "([?][^#]*)?";
    @NotNull
    private static final String FRAGMENT = "(#.*)?";
    @NotNull
    private static final Regex DID_MATCHER = new Regex("^did:([a-z0-9]+):((?:(?:[a-zA-Z0-9._-]|(?:%[0-9a-fA-F]{2}))*:)*((?:[a-zA-Z0-9._-]|(?:%[0-9a-fA-F]{2}))+))((;[a-zA-Z0-9_.:%-]+=[a-zA-Z0-9_.:%-]*)*)(/[^#?]*)?([?][^#]*)?(#.*)?$");
    @NotNull
    private static final String DOC_PATH = "/did.json";
    @NotNull
    private static final String WELL_KNOWN_PATH = ".well-known";

    public DidWebResolver(@NotNull String didUrl) {
        Intrinsics.checkNotNullParameter((Object)didUrl, (String)"didUrl");
        this.didUrl = didUrl;
    }

    @NotNull
    public final Map<String, Object> resolve() {
        ParsedDID parsedDid = this.parseDidUrl();
        try {
            String url = this.constructDIDUrl(parsedDid);
            Map map = NetworkManagerClient.Companion.sendHTTPRequest$default(NetworkManagerClient.Companion, url, HTTP_METHOD.GET, null, null, 12, null);
            if (map == null) {
                throw new DidResolverExceptions.DidDocumentNotFound("Did document could not be fetched");
            }
            return map;
        }
        catch (Exception e) {
            throw new DidResolverExceptions.DidResolutionFailed(e.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final String constructDIDUrl(ParsedDID parsedDid) {
        void $this$mapTo$iv$iv;
        String[] stringArray = new String[]{":"};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)parsedDid.getId(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it);
        }
        List idComponents = (List)destination$iv$iv;
        String baseDomain = (String)CollectionsKt.first((List)idComponents);
        String path = CollectionsKt.joinToString$default((Iterable)CollectionsKt.drop((Iterable)idComponents, (int)1), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
        Object urlPath = ((CharSequence)path).length() == 0 ? ".well-known/did.json" : path + DOC_PATH;
        return "https://" + baseDomain + "/" + (String)urlPath;
    }

    /*
     * WARNING - void declaration
     */
    private final ParsedDID parseDidUrl() {
        ParsedDID parsedDID;
        MatchResult matchResult = Regex.find$default((Regex)DID_MATCHER, (CharSequence)this.didUrl, (int)0, (int)2, null);
        if (matchResult == null) {
            throw new DidResolverExceptions.UnsupportedDidUrl();
        }
        MatchResult matchResult2 = matchResult;
        List sections = matchResult2.getGroupValues();
        if (!Intrinsics.areEqual(sections.get(1), (Object)"web")) {
            throw new DidResolverExceptions.UnsupportedDidUrl();
        }
        List it = sections;
        boolean bl = false;
        ParsedDID $this$parseDidUrl_u24lambda_u244_u24lambda_u243 = parsedDID = new ParsedDID("did:" + it.get(1) + ":" + it.get(2), (String)it.get(1), (String)it.get(2), this.didUrl, null, null, null, null, 240, null);
        boolean bl2 = false;
        if (((CharSequence)it.get(4)).length() > 0) {
            void $this$associateTo$iv$iv;
            void $this$associate$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            String string = ((String)it.get(4)).substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            Object object = new String[]{";"};
            object = StringsKt.split$default((CharSequence)string, (String[])object, (boolean)false, (int)0, (int)6, null);
            ParsedDID parsedDID2 = $this$parseDidUrl_u24lambda_u244_u24lambda_u243;
            boolean $i$f$filter = false;
            void var11_11 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String param = (String)element$iv$iv;
                boolean bl3 = false;
                boolean bl4 = ((CharSequence)param).length() > 0;
                if (!bl4) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            destination$iv$iv = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv2;
                String param = (String)element$iv$iv;
                boolean bl5 = false;
                String[] stringArray = new String[]{"="};
                List kv = StringsKt.split$default((CharSequence)param, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                Object e = kv.get(0);
                String string2 = (String)CollectionsKt.getOrNull((List)kv, (int)1);
                if (string2 == null) {
                    string2 = "";
                }
                Pair pair = TuplesKt.to(e, (Object)string2);
                map.put(pair.getFirst(), pair.getSecond());
            }
            parsedDID2.setParams(destination$iv$iv2);
        }
        if (((CharSequence)it.get(6)).length() > 0) {
            $this$parseDidUrl_u24lambda_u244_u24lambda_u243.setPath((String)it.get(6));
        }
        if (((CharSequence)it.get(7)).length() > 0) {
            String string = ((String)it.get(7)).substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            $this$parseDidUrl_u24lambda_u244_u24lambda_u243.setQuery(string);
        }
        if (((CharSequence)it.get(8)).length() > 0) {
            String string = ((String)it.get(8)).substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            $this$parseDidUrl_u24lambda_u244_u24lambda_u243.setFragment(string);
        }
        return parsedDID;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lio/mosip/vercred/vcverifier/DidWebResolver$Companion;", "", "()V", "DID_MATCHER", "Lkotlin/text/Regex;", "DOC_PATH", "", "FRAGMENT", "ID_CHAR", "METHOD", "METHOD_ID", "PARAM", "PARAMS", "PARAM_CHAR", "PATH", "PCT_ENCODED", "QUERY", "WELL_KNOWN_PATH", "vcverifier_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u001e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001Ba\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0016\b\u0002\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\b\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\fJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\u0017\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\bH\u00c6\u0003J\u000b\u0010\"\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010#\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010$\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003Jm\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\u0016\b\u0002\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010)\u001a\u00020*H\u00d6\u0001J\t\u0010+\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u000e\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000eR(\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001c\u0010\t\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u000e\"\u0004\b\u001a\u0010\u0012R\u001c\u0010\n\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u000e\"\u0004\b\u001c\u0010\u0012\u00a8\u0006,"}, d2={"Lio/mosip/vercred/vcverifier/DidWebResolver$ParsedDID;", "", "did", "", "method", "id", "didUrl", "params", "", "path", "query", "fragment", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getDid", "()Ljava/lang/String;", "getDidUrl", "getFragment", "setFragment", "(Ljava/lang/String;)V", "getId", "getMethod", "getParams", "()Ljava/util/Map;", "setParams", "(Ljava/util/Map;)V", "getPath", "setPath", "getQuery", "setQuery", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "", "other", "hashCode", "", "toString", "vcverifier_release"})
    public static final class ParsedDID {
        @NotNull
        private final String did;
        @NotNull
        private final String method;
        @NotNull
        private final String id;
        @NotNull
        private final String didUrl;
        @Nullable
        private Map<String, String> params;
        @Nullable
        private String path;
        @Nullable
        private String query;
        @Nullable
        private String fragment;

        public ParsedDID(@NotNull String did, @NotNull String method, @NotNull String id, @NotNull String didUrl, @Nullable Map<String, String> params, @Nullable String path, @Nullable String query, @Nullable String fragment) {
            Intrinsics.checkNotNullParameter((Object)did, (String)"did");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)didUrl, (String)"didUrl");
            this.did = did;
            this.method = method;
            this.id = id;
            this.didUrl = didUrl;
            this.params = params;
            this.path = path;
            this.query = query;
            this.fragment = fragment;
        }

        public /* synthetic */ ParsedDID(String string, String string2, String string3, String string4, Map map, String string5, String string6, String string7, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x10) != 0) {
                map = null;
            }
            if ((n & 0x20) != 0) {
                string5 = null;
            }
            if ((n & 0x40) != 0) {
                string6 = null;
            }
            if ((n & 0x80) != 0) {
                string7 = null;
            }
            this(string, string2, string3, string4, map, string5, string6, string7);
        }

        @NotNull
        public final String getDid() {
            return this.did;
        }

        @NotNull
        public final String getMethod() {
            return this.method;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getDidUrl() {
            return this.didUrl;
        }

        @Nullable
        public final Map<String, String> getParams() {
            return this.params;
        }

        public final void setParams(@Nullable Map<String, String> map) {
            this.params = map;
        }

        @Nullable
        public final String getPath() {
            return this.path;
        }

        public final void setPath(@Nullable String string) {
            this.path = string;
        }

        @Nullable
        public final String getQuery() {
            return this.query;
        }

        public final void setQuery(@Nullable String string) {
            this.query = string;
        }

        @Nullable
        public final String getFragment() {
            return this.fragment;
        }

        public final void setFragment(@Nullable String string) {
            this.fragment = string;
        }

        @NotNull
        public final String component1() {
            return this.did;
        }

        @NotNull
        public final String component2() {
            return this.method;
        }

        @NotNull
        public final String component3() {
            return this.id;
        }

        @NotNull
        public final String component4() {
            return this.didUrl;
        }

        @Nullable
        public final Map<String, String> component5() {
            return this.params;
        }

        @Nullable
        public final String component6() {
            return this.path;
        }

        @Nullable
        public final String component7() {
            return this.query;
        }

        @Nullable
        public final String component8() {
            return this.fragment;
        }

        @NotNull
        public final ParsedDID copy(@NotNull String did, @NotNull String method, @NotNull String id, @NotNull String didUrl, @Nullable Map<String, String> params, @Nullable String path, @Nullable String query, @Nullable String fragment) {
            Intrinsics.checkNotNullParameter((Object)did, (String)"did");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)didUrl, (String)"didUrl");
            return new ParsedDID(did, method, id, didUrl, params, path, query, fragment);
        }

        public static /* synthetic */ ParsedDID copy$default(ParsedDID parsedDID, String string, String string2, String string3, String string4, Map map, String string5, String string6, String string7, int n, Object object) {
            if ((n & 1) != 0) {
                string = parsedDID.did;
            }
            if ((n & 2) != 0) {
                string2 = parsedDID.method;
            }
            if ((n & 4) != 0) {
                string3 = parsedDID.id;
            }
            if ((n & 8) != 0) {
                string4 = parsedDID.didUrl;
            }
            if ((n & 0x10) != 0) {
                map = parsedDID.params;
            }
            if ((n & 0x20) != 0) {
                string5 = parsedDID.path;
            }
            if ((n & 0x40) != 0) {
                string6 = parsedDID.query;
            }
            if ((n & 0x80) != 0) {
                string7 = parsedDID.fragment;
            }
            return parsedDID.copy(string, string2, string3, string4, map, string5, string6, string7);
        }

        @NotNull
        public String toString() {
            return "ParsedDID(did=" + this.did + ", method=" + this.method + ", id=" + this.id + ", didUrl=" + this.didUrl + ", params=" + this.params + ", path=" + this.path + ", query=" + this.query + ", fragment=" + this.fragment + ")";
        }

        public int hashCode() {
            int result = this.did.hashCode();
            result = result * 31 + this.method.hashCode();
            result = result * 31 + this.id.hashCode();
            result = result * 31 + this.didUrl.hashCode();
            result = result * 31 + (this.params == null ? 0 : ((Object)this.params).hashCode());
            result = result * 31 + (this.path == null ? 0 : this.path.hashCode());
            result = result * 31 + (this.query == null ? 0 : this.query.hashCode());
            result = result * 31 + (this.fragment == null ? 0 : this.fragment.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ParsedDID)) {
                return false;
            }
            ParsedDID parsedDID = (ParsedDID)other;
            if (!Intrinsics.areEqual((Object)this.did, (Object)parsedDID.did)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.method, (Object)parsedDID.method)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.id, (Object)parsedDID.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.didUrl, (Object)parsedDID.didUrl)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.params, parsedDID.params)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.path, (Object)parsedDID.path)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.query, (Object)parsedDID.query)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.fragment, (Object)parsedDID.fragment);
        }
    }
}

