/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.vercred.vcverifier.signature.impl;

import co.nstant.in.cbor.model.DataItem;
import com.android.identity.internal.Util;
import io.mosip.vercred.vcverifier.exception.SignatureVerificationException;
import io.mosip.vercred.vcverifier.signature.SignatureVerifier;
import io.mosip.vercred.vcverifier.utils.CborDataItemUtils;
import java.security.PublicKey;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a8\u0006\f"}, d2={"Lio/mosip/vercred/vcverifier/signature/impl/CoseSignatureVerifierImpl;", "Lio/mosip/vercred/vcverifier/signature/SignatureVerifier;", "()V", "verify", "", "publicKey", "Ljava/security/PublicKey;", "signData", "", "signature", "provider", "Lorg/bouncycastle/jce/provider/BouncyCastleProvider;", "vcverifier_release"})
public final class CoseSignatureVerifierImpl
implements SignatureVerifier {
    @Override
    public boolean verify(@NotNull PublicKey publicKey, @NotNull byte[] signData, @Nullable byte[] signature, @Nullable BouncyCastleProvider provider) {
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        Intrinsics.checkNotNullParameter((Object)signData, (String)"signData");
        DataItem coseSign1 = CborDataItemUtils.INSTANCE.fromByteArray(signData);
        boolean coseSign1CheckSignature = Util.coseSign1CheckSignature((DataItem)coseSign1, (byte[])new byte[0], (PublicKey)publicKey);
        if (!coseSign1CheckSignature) {
            throw new SignatureVerificationException("Error while doing COSE signature verification with algorithm - " + publicKey.getAlgorithm());
        }
        return true;
    }
}

