/*
 * Decompiled with CFR 0.152.
 */
package io.mosip.vercred.vcverifier.signature.impl;

import io.mosip.vercred.vcverifier.exception.SignatureVerificationException;
import io.mosip.vercred.vcverifier.signature.SignatureVerifier;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a8\u0006\f"}, d2={"Lio/mosip/vercred/vcverifier/signature/impl/PS256SignatureVerifierImpl;", "Lio/mosip/vercred/vcverifier/signature/SignatureVerifier;", "()V", "verify", "", "publicKey", "Ljava/security/PublicKey;", "signData", "", "signature", "provider", "Lorg/bouncycastle/jce/provider/BouncyCastleProvider;", "vcverifier_release"})
public final class PS256SignatureVerifierImpl
implements SignatureVerifier {
    @Override
    public boolean verify(@NotNull PublicKey publicKey, @NotNull byte[] signData, @Nullable byte[] signature, @Nullable BouncyCastleProvider provider) {
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        Intrinsics.checkNotNullParameter((Object)signData, (String)"signData");
        try {
            Signature signature2 = Signature.getInstance("SHA256withRSA/PSS");
            Intrinsics.checkNotNullExpressionValue((Object)signature2, (String)"getInstance(...)");
            Signature psSignature = signature2;
            PSSParameterSpec pssParamSpec = new PSSParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, 32, 1);
            Signature $this$verify_u24lambda_u240 = psSignature;
            boolean bl = false;
            $this$verify_u24lambda_u240.setParameter(pssParamSpec);
            $this$verify_u24lambda_u240.initVerify(publicKey);
            $this$verify_u24lambda_u240.update(signData);
            return $this$verify_u24lambda_u240.verify(signature);
        }
        catch (Exception e) {
            throw new SignatureVerificationException("Error while doing signature verification using PS256 algorithm");
        }
    }
}

