/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid;

import com.subgraph.orchid.CircuitManager;
import com.subgraph.orchid.ConnectionCache;
import com.subgraph.orchid.Directory;
import com.subgraph.orchid.DirectoryStore;
import com.subgraph.orchid.OpenFailedException;
import com.subgraph.orchid.SocksPortListener;
import com.subgraph.orchid.Stream;
import com.subgraph.orchid.Tor;
import com.subgraph.orchid.TorConfig;
import com.subgraph.orchid.TorException;
import com.subgraph.orchid.TorInitializationListener;
import com.subgraph.orchid.circuits.TorInitializationTracker;
import com.subgraph.orchid.crypto.PRNGFixes;
import com.subgraph.orchid.dashboard.Dashboard;
import com.subgraph.orchid.directory.downloader.DirectoryDownloaderImpl;
import com.subgraph.orchid.sockets.OrchidSocketFactory;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.net.SocketFactory;

public class TorClient {
    private static final Logger logger = Logger.getLogger(TorClient.class.getName());
    private final TorConfig config;
    private final Directory directory;
    private final TorInitializationTracker initializationTracker;
    private final ConnectionCache connectionCache;
    private final CircuitManager circuitManager;
    private final SocksPortListener socksListener;
    private final DirectoryDownloaderImpl directoryDownloader;
    private final Dashboard dashboard;
    private boolean isStarted = false;
    private boolean isStopped = false;
    private final CountDownLatch readyLatch;

    public TorClient() {
        this(null);
    }

    public TorClient(DirectoryStore customDirectoryStore) {
        if (Tor.isAndroidRuntime()) {
            PRNGFixes.apply();
        }
        this.config = Tor.createConfig();
        this.directory = Tor.createDirectory(this.config, customDirectoryStore);
        this.initializationTracker = Tor.createInitalizationTracker();
        this.initializationTracker.addListener(this.createReadyFlagInitializationListener());
        this.connectionCache = Tor.createConnectionCache(this.config, this.initializationTracker);
        this.directoryDownloader = Tor.createDirectoryDownloader(this.config, this.initializationTracker);
        this.circuitManager = Tor.createCircuitManager(this.config, this.directoryDownloader, this.directory, this.connectionCache, this.initializationTracker);
        this.socksListener = Tor.createSocksPortListener(this.config, this.circuitManager);
        this.readyLatch = new CountDownLatch(1);
        this.dashboard = new Dashboard();
        this.dashboard.addRenderables(this.circuitManager, this.directoryDownloader, this.socksListener);
    }

    public TorConfig getConfig() {
        return this.config;
    }

    public SocketFactory getSocketFactory() {
        return new OrchidSocketFactory(this);
    }

    public synchronized void start() {
        if (this.isStarted) {
            return;
        }
        if (this.isStopped) {
            throw new IllegalStateException("Cannot restart a TorClient instance.  Create a new instance instead.");
        }
        logger.info("Starting Orchid (version: " + Tor.getFullVersion() + ")");
        this.verifyUnlimitedStrengthPolicyInstalled();
        this.directoryDownloader.start(this.directory);
        this.circuitManager.startBuildingCircuits();
        if (this.dashboard.isEnabledByProperty()) {
            this.dashboard.startListening();
        }
        this.isStarted = true;
    }

    public synchronized void stop() {
        if (!this.isStarted || this.isStopped) {
            return;
        }
        try {
            this.socksListener.stop();
            if (this.dashboard.isListening()) {
                this.dashboard.stopListening();
            }
            this.directoryDownloader.stop();
            this.circuitManager.stopBuildingCircuits(true);
            this.directory.close();
            this.connectionCache.close();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Unexpected exception while shutting down TorClient instance: " + e, e);
        }
        finally {
            this.isStopped = true;
        }
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public ConnectionCache getConnectionCache() {
        return this.connectionCache;
    }

    public CircuitManager getCircuitManager() {
        return this.circuitManager;
    }

    public void waitUntilReady() throws InterruptedException {
        this.readyLatch.await();
    }

    public void waitUntilReady(long timeout) throws InterruptedException, TimeoutException {
        if (!this.readyLatch.await(timeout, TimeUnit.MILLISECONDS)) {
            throw new TimeoutException();
        }
    }

    public Stream openExitStreamTo(String hostname, int port) throws InterruptedException, TimeoutException, OpenFailedException {
        this.ensureStarted();
        return this.circuitManager.openExitStreamTo(hostname, port);
    }

    private synchronized void ensureStarted() {
        if (!this.isStarted) {
            throw new IllegalStateException("Must call start() first");
        }
    }

    public void enableSocksListener(int port) {
        this.socksListener.addListeningPort(port);
    }

    public void enableSocksListener() {
        this.enableSocksListener(9150);
    }

    public void enableDashboard() {
        if (!this.dashboard.isListening()) {
            this.dashboard.startListening();
        }
    }

    public void enableDashboard(int port) {
        this.dashboard.setListeningPort(port);
        this.enableDashboard();
    }

    public void disableDashboard() {
        if (this.dashboard.isListening()) {
            this.dashboard.stopListening();
        }
    }

    public void addInitializationListener(TorInitializationListener listener) {
        this.initializationTracker.addListener(listener);
    }

    public void removeInitializationListener(TorInitializationListener listener) {
        this.initializationTracker.removeListener(listener);
    }

    private TorInitializationListener createReadyFlagInitializationListener() {
        return new TorInitializationListener(){

            @Override
            public void initializationProgress(String message, int percent) {
            }

            @Override
            public void initializationCompleted() {
                TorClient.this.readyLatch.countDown();
            }
        };
    }

    public static void main(String[] args) {
        TorClient client = new TorClient();
        client.addInitializationListener(TorClient.createInitalizationListner());
        client.start();
        client.enableSocksListener();
    }

    private static TorInitializationListener createInitalizationListner() {
        return new TorInitializationListener(){

            @Override
            public void initializationProgress(String message, int percent) {
                System.out.println(">>> [ " + percent + "% ]: " + message);
            }

            @Override
            public void initializationCompleted() {
                System.out.println("Tor is ready to go!");
            }
        };
    }

    private void verifyUnlimitedStrengthPolicyInstalled() {
        try {
            if (Cipher.getMaxAllowedKeyLength("AES") < 256) {
                String message = "Unlimited Strength Jurisdiction Policy Files are required but not installed.";
                logger.severe("Unlimited Strength Jurisdiction Policy Files are required but not installed.");
                throw new TorException("Unlimited Strength Jurisdiction Policy Files are required but not installed.");
            }
        }
        catch (NoSuchAlgorithmException e) {
            logger.log(Level.SEVERE, "No AES provider found");
            throw new TorException(e);
        }
        catch (NoSuchMethodError e) {
            logger.info("Skipped check for Unlimited Strength Jurisdiction Policy Files");
        }
    }
}

