/*
 * Decompiled with CFR 0.152.
 */
package org.noear.snack.core.exts;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import org.noear.snack.annotation.NodeName;
import org.noear.snack.annotation.ONodeAttr;
import org.noear.snack.core.utils.StringUtil;
import org.noear.snack.exception.SnackException;

public class FieldWrap {
    public final Field field;
    public final Class<?> type;
    public final Type genericType;
    public final boolean readonly;
    private String name;
    private String format;
    private boolean serialize = true;
    private boolean deserialize = true;

    public FieldWrap(Class<?> clz, Field f, boolean isFinal) {
        ONodeAttr attr;
        this.field = f;
        this.type = f.getType();
        this.genericType = f.getGenericType();
        this.readonly = isFinal;
        NodeName anno = f.getAnnotation(NodeName.class);
        if (anno != null) {
            this.name = anno.value();
        }
        if ((attr = f.getAnnotation(ONodeAttr.class)) != null) {
            this.name = attr.name();
            this.format = attr.format();
            this.serialize = attr.serialize();
            this.deserialize = attr.deserialize();
        }
        if (StringUtil.isEmpty(this.name)) {
            this.name = this.field.getName();
        }
    }

    @Deprecated
    public String name() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public String getFormat() {
        return this.format;
    }

    public boolean isDeserialize() {
        return this.deserialize;
    }

    public boolean isSerialize() {
        return this.serialize;
    }

    public void setValue(Object tObj, Object val) {
        if (this.readonly) {
            return;
        }
        try {
            this.field.set(tObj, val);
        }
        catch (IllegalAccessException e) {
            throw new SnackException(e);
        }
    }

    public Object getValue(Object tObj) {
        try {
            return this.field.get(tObj);
        }
        catch (IllegalAccessException ex) {
            throw new SnackException(ex);
        }
    }
}

