/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.mailer.internal;

import java.io.UnsupportedEncodingException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.api.email.Email;
import org.simplejavamail.api.internal.authenticatedsockssupport.socks5server.AnonymousSocks5Server;
import org.simplejavamail.api.mailer.config.OperationalConfig;
import org.simplejavamail.converter.EmailConverter;
import org.simplejavamail.converter.internal.mimemessage.MimeMessageProducerHelper;
import org.simplejavamail.mailer.internal.AbstractProxyServerSyncingClosure;
import org.simplejavamail.mailer.internal.MailerException;
import org.simplejavamail.mailer.internal.util.SessionLogger;
import org.simplejavamail.mailer.internal.util.TransportRunner;

class SendMailClosure
extends AbstractProxyServerSyncingClosure {
    @NotNull
    private final OperationalConfig operationalConfig;
    @NotNull
    private final Session session;
    @NotNull
    private final Email email;
    private final boolean asyncForLoggingPurpose;
    private final boolean transportModeLoggingOnly;

    SendMailClosure(@NotNull OperationalConfig operationalConfig, @NotNull Session session, @NotNull Email email, @Nullable AnonymousSocks5Server proxyServer, boolean asyncForLoggingPurpose, boolean transportModeLoggingOnly, @NotNull AtomicInteger smtpConnectionCounter) {
        super(smtpConnectionCounter, proxyServer);
        this.operationalConfig = operationalConfig;
        this.session = session;
        this.email = email;
        this.asyncForLoggingPurpose = asyncForLoggingPurpose;
        this.transportModeLoggingOnly = transportModeLoggingOnly;
    }

    @Override
    public void executeClosure() {
        LOGGER.trace("sending email...");
        try {
            MimeMessage message = MimeMessageProducerHelper.produceMimeMessage(this.email, this.session);
            SessionLogger.logSession(this.session, this.asyncForLoggingPurpose, "mail");
            message.saveChanges();
            this.email.internalSetId(message.getMessageID());
            this.logEmail(message);
            if (this.transportModeLoggingOnly) {
                LOGGER.info("TRANSPORT_MODE_LOGGING_ONLY: skipping actual sending...");
            } else if (this.operationalConfig.getCustomMailer() != null) {
                this.operationalConfig.getCustomMailer().sendMessage(this.operationalConfig, this.session, this.email, message);
            } else {
                TransportRunner.sendMessage(this.operationalConfig.getClusterKey(), this.session, message, message.getAllRecipients());
            }
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error("Failed to send email:\n{}", (Object)this.email);
            throw new MailerException("Encoding not accepted", e);
        }
        catch (MessagingException e) {
            LOGGER.error("Failed to send email:\n{}", (Object)this.email);
            throw new MailerException("Third party error", (Exception)((Object)e));
        }
        catch (Exception e) {
            LOGGER.error("Failed to send email:\n{}", (Object)this.email);
            throw e;
        }
    }

    private void logEmail(MimeMessage message) {
        if (this.transportModeLoggingOnly) {
            LOGGER.info("\n\nEmail: {}\n", (Object)this.email);
            LOGGER.info("\n\nMimeMessage: {}\n", (Object)EmailConverter.mimeMessageToEML(message));
        } else {
            LOGGER.trace("\t\nEmail: {}", (Object)this.email);
            LOGGER.trace("\t\nMimeMessage: {}\n", (Object)EmailConverter.mimeMessageToEML(message));
        }
    }
}

