/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.mailer.internal;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.api.mailer.config.ServerConfig;
import org.simplejavamail.internal.util.MiscUtil;

class ServerConfigImpl
implements ServerConfig {
    @NotNull
    private final String host;
    @NotNull
    private final Integer port;
    @Nullable
    private final String username;
    @Nullable
    private final String password;

    ServerConfigImpl(@NotNull String host, @NotNull Integer port, @Nullable String username, @Nullable String password) {
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        if (MiscUtil.valueNullOrEmpty((Object)this.username) && !MiscUtil.valueNullOrEmpty((Object)this.password)) {
            throw new IllegalArgumentException("Password provided but not a username");
        }
    }

    public String toString() {
        String str = String.format("%s:%s", this.host, this.port);
        if (this.username != null) {
            str = str + String.format(", username: %s", this.username);
        }
        if (this.password != null) {
            str = str + " (authenticated)";
        }
        return str;
    }

    @NotNull
    public String getHost() {
        return this.host;
    }

    @NotNull
    public Integer getPort() {
        return this.port;
    }

    @Nullable
    public String getUsername() {
        return this.username;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }
}

