/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.ssl.pem;

import org.springframework.util.StringUtils;

public record PemSslStoreDetails(String type, String certificate, String privateKey, String privateKeyPassword) {
    public PemSslStoreDetails(String type, String certificate, String privateKey) {
        this(type, certificate, privateKey, null);
    }

    public PemSslStoreDetails withPrivateKey(String privateKey) {
        return new PemSslStoreDetails(this.type, this.certificate, privateKey, this.privateKeyPassword);
    }

    public PemSslStoreDetails withPrivateKeyPassword(String password) {
        return new PemSslStoreDetails(this.type, this.certificate, this.privateKey, password);
    }

    boolean isEmpty() {
        return this.isEmpty(this.type) && this.isEmpty(this.certificate) && this.isEmpty(this.privateKey);
    }

    private boolean isEmpty(String value) {
        return !StringUtils.hasText((String)value);
    }

    public static PemSslStoreDetails forCertificate(String certificate) {
        return new PemSslStoreDetails(null, certificate, null);
    }
}

