/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.abi;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import org.web3j.abi.DefaultFunctionReturnDecoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.Utils;
import org.web3j.abi.datatypes.AbiTypes;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Array;
import org.web3j.abi.datatypes.Bool;
import org.web3j.abi.datatypes.Bytes;
import org.web3j.abi.datatypes.BytesType;
import org.web3j.abi.datatypes.DynamicArray;
import org.web3j.abi.datatypes.DynamicBytes;
import org.web3j.abi.datatypes.DynamicStruct;
import org.web3j.abi.datatypes.Fixed;
import org.web3j.abi.datatypes.FixedPointType;
import org.web3j.abi.datatypes.Int;
import org.web3j.abi.datatypes.IntType;
import org.web3j.abi.datatypes.NumericType;
import org.web3j.abi.datatypes.StaticArray;
import org.web3j.abi.datatypes.StaticStruct;
import org.web3j.abi.datatypes.StructType;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.Ufixed;
import org.web3j.abi.datatypes.Uint;
import org.web3j.abi.datatypes.Utf8String;
import org.web3j.abi.datatypes.generated.Uint160;
import org.web3j.abi.datatypes.primitive.Double;
import org.web3j.abi.datatypes.primitive.Float;
import org.web3j.utils.Numeric;

public class TypeDecoder {
    static final int MAX_BYTE_LENGTH_FOR_HEX_STRING = 64;

    public static Type instantiateType(String solidityType, Object value) throws InvocationTargetException, NoSuchMethodException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        return TypeDecoder.instantiateType(TypeReference.makeTypeReference(solidityType), value);
    }

    public static Type instantiateType(TypeReference ref, Object value) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, ClassNotFoundException {
        Class rc = ref.getClassType();
        if (Array.class.isAssignableFrom(rc)) {
            return TypeDecoder.instantiateArrayType(ref, value);
        }
        return TypeDecoder.instantiateAtomicType(rc, value);
    }

    public static <T extends Array> T decode(String input, int offset, TypeReference<T> typeReference) {
        Class<?> cls = ((ParameterizedType)typeReference.getType()).getRawType().getClass();
        if (StaticArray.class.isAssignableFrom(cls)) {
            return (T)((Array)TypeDecoder.decodeStaticArray(input, offset, typeReference, 1));
        }
        if (DynamicArray.class.isAssignableFrom(cls)) {
            return (T)((Array)TypeDecoder.decodeDynamicArray(input, offset, typeReference));
        }
        throw new UnsupportedOperationException("Unsupported TypeReference: " + cls.getName() + ", only Array types can be passed as TypeReferences");
    }

    public static <T extends Type> T decode(String input, int offset, Class<T> type) {
        if (NumericType.class.isAssignableFrom(type)) {
            return TypeDecoder.decodeNumeric(input.substring(offset), type);
        }
        if (Address.class.isAssignableFrom(type)) {
            return (T)TypeDecoder.decodeAddress(input.substring(offset));
        }
        if (Bool.class.isAssignableFrom(type)) {
            return (T)TypeDecoder.decodeBool(input, offset);
        }
        if (Bytes.class.isAssignableFrom(type)) {
            return TypeDecoder.decodeBytes(input, offset, type);
        }
        if (DynamicBytes.class.isAssignableFrom(type)) {
            return (T)TypeDecoder.decodeDynamicBytes(input, offset);
        }
        if (Utf8String.class.isAssignableFrom(type)) {
            return (T)TypeDecoder.decodeUtf8String(input, offset);
        }
        if (Array.class.isAssignableFrom(type)) {
            throw new UnsupportedOperationException("Array types must be wrapped in a TypeReference");
        }
        throw new UnsupportedOperationException("Type cannot be encoded: " + type.getClass());
    }

    public static <T extends Type> T decode(String input, Class<T> type) {
        return TypeDecoder.decode(input, 0, type);
    }

    public static <T extends Type> T decode(String input, TypeReference<?> type) throws ClassNotFoundException {
        return (T)TypeDecoder.decode(input, 0, type.getClassType());
    }

    public static Address decodeAddress(String input) {
        return new Address(TypeDecoder.decodeNumeric(input, Uint160.class));
    }

    public static <T extends NumericType> T decodeNumeric(String input, Class<T> type) {
        try {
            byte[] inputByteArray = Numeric.hexStringToByteArray((String)input);
            int typeLengthAsBytes = TypeDecoder.getTypeLengthInBytes(type);
            int valueOffset = 32 - typeLengthAsBytes;
            BigInteger numericValue = Uint.class.isAssignableFrom(type) || Ufixed.class.isAssignableFrom(type) ? new BigInteger(1, inputByteArray, valueOffset, typeLengthAsBytes) : new BigInteger(inputByteArray, valueOffset, typeLengthAsBytes);
            return (T)((NumericType)type.getConstructor(BigInteger.class).newInstance(numericValue));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new UnsupportedOperationException("Unable to create instance of " + type.getName(), e);
        }
    }

    static <T extends NumericType> int getTypeLengthInBytes(Class<T> type) {
        return TypeDecoder.getTypeLength(type) >> 3;
    }

    static <T extends NumericType> int getTypeLength(Class<T> type) {
        if (IntType.class.isAssignableFrom(type)) {
            String regex = "(" + Uint.class.getSimpleName() + "|" + Int.class.getSimpleName() + ")";
            String[] splitName = type.getSimpleName().split(regex);
            if (splitName.length == 2) {
                return Integer.parseInt(splitName[1]);
            }
        } else if (FixedPointType.class.isAssignableFrom(type)) {
            String regex = "(" + Ufixed.class.getSimpleName() + "|" + Fixed.class.getSimpleName() + ")";
            String[] splitName = type.getSimpleName().split(regex);
            if (splitName.length == 2) {
                String[] bitsCounts = splitName[1].split("x");
                return Integer.parseInt(bitsCounts[0]) + Integer.parseInt(bitsCounts[1]);
            }
        }
        return 256;
    }

    static Type instantiateArrayType(TypeReference ref, Object value) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, ClassNotFoundException {
        Constructor<Object> listcons;
        int arraySize;
        List values;
        if (value instanceof List) {
            values = (List)value;
        } else if (value.getClass().isArray()) {
            values = TypeDecoder.arrayToList(value);
        } else {
            throw new ClassCastException("Arg of type " + value.getClass() + " should be a list to instantiate web3j Array");
        }
        int n = arraySize = ref instanceof TypeReference.StaticArrayTypeReference ? ((TypeReference.StaticArrayTypeReference)ref).getSize() : -1;
        if (arraySize <= 0) {
            listcons = DynamicArray.class.getConstructor(Class.class, List.class);
        } else {
            Class<?> arrayClass = Class.forName("org.web3j.abi.datatypes.generated.StaticArray" + arraySize);
            listcons = arrayClass.getConstructor(Class.class, List.class);
        }
        ArrayList<Type> transformedList = new ArrayList<Type>(values.size());
        TypeReference subTypeReference = ref.getSubTypeReference();
        for (Object o : values) {
            transformedList.add(TypeDecoder.instantiateType(subTypeReference, o));
        }
        return (Type)listcons.newInstance(subTypeReference.getClassType(), transformedList);
    }

    static Type instantiateAtomicType(Class<?> referenceClass, Object value) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, ClassNotFoundException {
        Object constructorArg = null;
        if (NumericType.class.isAssignableFrom(referenceClass)) {
            constructorArg = TypeDecoder.asBigInteger(value);
        } else if (BytesType.class.isAssignableFrom(referenceClass)) {
            if (value instanceof byte[]) {
                constructorArg = value;
            } else if (value instanceof BigInteger) {
                constructorArg = ((BigInteger)value).toByteArray();
            } else if (value instanceof String) {
                constructorArg = Numeric.hexStringToByteArray((String)((String)value));
            }
        } else if (Utf8String.class.isAssignableFrom(referenceClass)) {
            constructorArg = value.toString();
        } else if (Address.class.isAssignableFrom(referenceClass)) {
            constructorArg = value instanceof BigInteger || value instanceof Uint160 ? value : value.toString();
        } else if (Bool.class.isAssignableFrom(referenceClass)) {
            if (value instanceof Boolean) {
                constructorArg = value;
            } else {
                BigInteger bival = TypeDecoder.asBigInteger(value);
                Object object = bival == null ? null : (constructorArg = Boolean.valueOf(!bival.equals(BigInteger.ZERO)));
            }
        }
        if (constructorArg == null) {
            throw new InstantiationException("Could not create type " + referenceClass + " from arg " + value.toString() + " of type " + value.getClass());
        }
        Class[] types = new Class[]{constructorArg.getClass()};
        Constructor<?> cons = referenceClass.getConstructor(types);
        return (Type)cons.newInstance(constructorArg);
    }

    static <T extends Type> int getSingleElementLength(String input, int offset, Class<T> type) {
        if (input.length() == offset) {
            return 0;
        }
        if (DynamicBytes.class.isAssignableFrom(type) || Utf8String.class.isAssignableFrom(type)) {
            return TypeDecoder.decodeUintAsInt(input, offset) / 32 + 2;
        }
        if (StaticStruct.class.isAssignableFrom(type)) {
            return Utils.staticStructNestedPublicFieldsFlatList(type).size();
        }
        return 1;
    }

    static int decodeUintAsInt(String rawInput, int offset) {
        String input = rawInput.substring(offset, offset + 64);
        return TypeDecoder.decode(input, 0, Uint.class).getValue().intValue();
    }

    public static Bool decodeBool(String rawInput, int offset) {
        String input = rawInput.substring(offset, offset + 64);
        BigInteger numericValue = Numeric.toBigInt((String)input);
        boolean value = numericValue.equals(BigInteger.ONE);
        return new Bool(value);
    }

    public static <T extends Bytes> T decodeBytes(String input, Class<T> type) {
        return TypeDecoder.decodeBytes(input, 0, type);
    }

    public static <T extends Bytes> T decodeBytes(String input, int offset, Class<T> type) {
        try {
            String simpleName = type.getSimpleName();
            String[] splitName = simpleName.split(Bytes.class.getSimpleName());
            int length = Integer.parseInt(splitName[1]);
            int hexStringLength = length << 1;
            byte[] bytes = Numeric.hexStringToByteArray((String)input.substring(offset, offset + hexStringLength));
            return (T)((Bytes)type.getConstructor(byte[].class).newInstance(new Object[]{bytes}));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new UnsupportedOperationException("Unable to create instance of " + type.getName(), e);
        }
    }

    public static DynamicBytes decodeDynamicBytes(String input, int offset) {
        int encodedLength = TypeDecoder.decodeUintAsInt(input, offset);
        int hexStringEncodedLength = encodedLength << 1;
        int valueOffset = offset + 64;
        String data = input.substring(valueOffset, valueOffset + hexStringEncodedLength);
        byte[] bytes = Numeric.hexStringToByteArray((String)data);
        return new DynamicBytes(bytes);
    }

    public static Utf8String decodeUtf8String(String input, int offset) {
        DynamicBytes dynamicBytesResult = TypeDecoder.decodeDynamicBytes(input, offset);
        byte[] bytes = dynamicBytesResult.getValue();
        return new Utf8String(new String(bytes, StandardCharsets.UTF_8));
    }

    public static <T extends Type> T decodeStaticArray(String input, int offset, TypeReference<T> typeReference, int length) {
        BiFunction<List, String, Type> function = (elements, typeName) -> {
            if (elements.isEmpty()) {
                throw new UnsupportedOperationException("Zero length fixed array is invalid type");
            }
            return TypeDecoder.instantiateStaticArray(elements, length);
        };
        return (T)TypeDecoder.decodeArrayElements(input, offset, typeReference, length, function);
    }

    public static <T extends Type> T decodeStaticStruct(String input, int offset, TypeReference<T> typeReference) {
        BiFunction<List, String, Type> function = (elements, typeName) -> {
            if (elements.isEmpty()) {
                throw new UnsupportedOperationException("Zero length fixed array is invalid type");
            }
            return TypeDecoder.instantiateStruct(typeReference, elements);
        };
        if (typeReference.getInnerTypes() != null) {
            return (T)TypeDecoder.decodeStaticStructElementFromInnerTypes(input, offset, typeReference, function);
        }
        return (T)TypeDecoder.decodeStaticStructElement(input, offset, typeReference, function);
    }

    private static <T extends Type> int countNestedFields(TypeReference<T> typeReference) {
        try {
            if (StaticStruct.class.isAssignableFrom(typeReference.getClassType())) {
                return typeReference.getInnerTypes().stream().map(tr -> TypeDecoder.countNestedFields(tr)).reduce(0, (a, b) -> a + b);
            }
            return 1;
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("countNestedFields failed for " + Utils.getTypeName(typeReference.getType()), e);
        }
    }

    private static <T extends Type> T decodeStaticStructElementFromInnerTypes(String input, int offset, TypeReference<T> typeReference, BiFunction<List<T>, String, T> consumer) {
        try {
            List<TypeReference<?>> innerTypes = typeReference.getInnerTypes();
            ArrayList elements = new ArrayList(innerTypes.size());
            int currOffset = offset;
            for (int i = 0; i < innerTypes.size(); ++i) {
                Object value;
                TypeReference<?> innerType = innerTypes.get(i);
                Class<?> declaredField = innerType.getClassType();
                if (StaticStruct.class.isAssignableFrom(declaredField)) {
                    int nestedStructLength = TypeDecoder.countNestedFields(innerType) * 64;
                    value = TypeDecoder.decodeStaticStruct(input.substring(currOffset, currOffset + nestedStructLength), 0, innerType);
                    currOffset += nestedStructLength;
                } else {
                    value = TypeDecoder.decode(input.substring(currOffset, currOffset + 64), 0, declaredField);
                    currOffset += 64;
                }
                elements.add(value);
            }
            return (T)((Type)consumer.apply(elements, Utils.getSimpleTypeName(typeReference.getClassType())));
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("Unable to access parameterized type " + Utils.getTypeName(typeReference.getType()), e);
        }
    }

    private static <T extends Type> T decodeStaticStructElement(String input, int offset, TypeReference<T> typeReference, BiFunction<List<T>, String, T> consumer) {
        try {
            Class<T> classType = typeReference.getClassType();
            Constructor constructor = Utils.findStructConstructor(classType);
            int length = constructor.getParameterCount();
            ArrayList elements = new ArrayList(length);
            int currOffset = offset;
            for (int i = 0; i < length; ++i) {
                Object value;
                Class<?> declaredField = constructor.getParameterTypes()[i];
                if (StaticStruct.class.isAssignableFrom(declaredField)) {
                    int nestedStructLength = classType.getDeclaredFields()[i].getType().getConstructors()[0].getParameters().length * 64;
                    value = TypeDecoder.decodeStaticStruct(input.substring(currOffset, currOffset + nestedStructLength), 0, TypeReference.create(declaredField));
                    currOffset += nestedStructLength;
                } else {
                    value = TypeDecoder.decode(input.substring(currOffset, currOffset + 64), 0, declaredField);
                    currOffset += 64;
                }
                elements.add(value);
            }
            String typeName = Utils.getSimpleTypeName(classType);
            return (T)((Type)consumer.apply(elements, typeName));
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("Unable to access parameterized type " + Utils.getTypeName(typeReference.getType()), e);
        }
    }

    private static <T extends Type> T instantiateStruct(TypeReference<T> typeReference, List<T> parameters) {
        try {
            Class<T> classType = typeReference.getClassType();
            if (classType.isAssignableFrom(DynamicStruct.class)) {
                return (T)new DynamicStruct(parameters);
            }
            if (classType.isAssignableFrom(StaticStruct.class)) {
                return (T)new StaticStruct(parameters);
            }
            Constructor ctor = Utils.findStructConstructor(classType);
            ctor.setAccessible(true);
            return (T)((Type)ctor.newInstance(parameters.toArray()));
        }
        catch (ReflectiveOperationException e) {
            throw new UnsupportedOperationException("Constructor cannot accept" + Arrays.toString(parameters.toArray()), e);
        }
    }

    public static <T extends Type> T decodeDynamicArray(String input, int offset, TypeReference<T> typeReference) {
        int length = TypeDecoder.decodeUintAsInt(input, offset);
        BiFunction<List, String, Type> function = (elements, typeName) -> new DynamicArray<Type>(AbiTypes.getType(typeName), (List<? extends Type>)elements);
        int valueOffset = offset + 64;
        return (T)TypeDecoder.decodeArrayElements(input, valueOffset, typeReference, length, function);
    }

    public static <T extends Type> T decodeDynamicStruct(String input, int offset, TypeReference<T> typeReference) throws ClassNotFoundException {
        BiFunction<List, String, Type> function = (elements, typeName) -> {
            if (elements.isEmpty()) {
                throw new UnsupportedOperationException("Zero length fixed array is invalid type");
            }
            return TypeDecoder.instantiateStruct(typeReference, elements);
        };
        if (typeReference.getClassType().isAssignableFrom(DynamicStruct.class) && typeReference.getInnerTypes() != null) {
            return (T)TypeDecoder.decodeDynamicStructElementsFromInnerTypes(input, offset, typeReference, function);
        }
        return (T)TypeDecoder.decodeDynamicStructElements(input, offset, typeReference, function);
    }

    private static <T extends Type> ParameterOffsetTracker<T> getDynamicOffsetsAndNonDynamicParameters(String input, int offset, TypeReference<T> typeReference) throws ClassNotFoundException {
        ParameterOffsetTracker tracker = new ParameterOffsetTracker(new HashMap(), new ArrayList<Integer>(), 0, 0);
        List<TypeReference<?>> innerTypes = typeReference.getInnerTypes();
        for (int i = 0; i < innerTypes.size(); ++i) {
            Object value;
            TypeReference<?> innerType = innerTypes.get(i);
            Class<?> declaredField = innerType.getClassType();
            int beginIndex = offset + tracker.staticOffset;
            if (TypeDecoder.isDynamic(declaredField)) {
                int parameterOffset = TypeDecoder.decodeDynamicStructDynamicParameterOffset(input.substring(beginIndex, beginIndex + 64)) + offset;
                tracker.parameterOffsets.add(parameterOffset);
                tracker.staticOffset += 64;
                ++tracker.dynamicParametersToProcess;
                continue;
            }
            if (StaticStruct.class.isAssignableFrom(declaredField)) {
                value = TypeDecoder.decodeStaticStruct(input.substring(beginIndex), 0, innerType);
                tracker.staticOffset += TypeDecoder.countNestedFields(innerType) * 64;
            } else {
                value = TypeDecoder.decode(input.substring(beginIndex), 0, declaredField);
                tracker.staticOffset += value.bytes32PaddedLength() * 2;
            }
            tracker.parameters.put(i, value);
        }
        return tracker;
    }

    private static <T extends Type> List<T> getDynamicParametersWithTracker(String input, TypeReference<T> typeReference, ParameterOffsetTracker<T> tracker) throws ClassNotFoundException {
        List<TypeReference<?>> innerTypes = typeReference.getInnerTypes();
        int dynamicParametersProcessed = 0;
        for (int i = 0; i < innerTypes.size(); ++i) {
            TypeReference<?> parameterTypeReference = innerTypes.get(i);
            Class<?> declaredField = parameterTypeReference.getClassType();
            if (!TypeDecoder.isDynamic(declaredField)) continue;
            boolean isLastParameterInStruct = dynamicParametersProcessed == tracker.dynamicParametersToProcess - 1;
            int parameterLength = isLastParameterInStruct ? input.length() - tracker.parameterOffsets.get(dynamicParametersProcessed) : tracker.parameterOffsets.get(dynamicParametersProcessed + 1) - tracker.parameterOffsets.get(dynamicParametersProcessed);
            tracker.parameters.put(i, TypeDecoder.decodeDynamicParameterFromStructWithTypeReference(input, tracker.parameterOffsets.get(dynamicParametersProcessed), parameterLength, parameterTypeReference));
            ++dynamicParametersProcessed;
        }
        ArrayList<Type> elements = new ArrayList<Type>();
        for (int i = 0; i < innerTypes.size(); ++i) {
            elements.add((Type)tracker.parameters.get(i));
        }
        return elements;
    }

    private static <T extends Type> T decodeDynamicStructElementsFromInnerTypes(String input, int offset, TypeReference<T> typeReference, BiFunction<List<T>, String, T> consumer) throws ClassNotFoundException {
        ParameterOffsetTracker<T> tracker = TypeDecoder.getDynamicOffsetsAndNonDynamicParameters(input, offset, typeReference);
        List<T> parameters = TypeDecoder.getDynamicParametersWithTracker(input, typeReference, tracker);
        String typeName = Utils.getSimpleTypeName(typeReference.getClassType());
        return (T)((Type)consumer.apply(parameters, typeName));
    }

    private static <T extends Type> T decodeDynamicStructElements(String input, int offset, TypeReference<T> typeReference, BiFunction<List<T>, String, T> consumer) {
        try {
            Class<T> classType = typeReference.getClassType();
            Constructor constructor = Utils.findStructConstructor(classType);
            int length = constructor.getParameterCount();
            HashMap parameters = new HashMap();
            int staticOffset = 0;
            ArrayList<Integer> parameterOffsets = new ArrayList<Integer>();
            for (int i = 0; i < length; ++i) {
                Object value;
                Class<Type> declaredField = constructor.getParameterTypes()[i];
                int beginIndex = offset + staticOffset;
                if (TypeDecoder.isDynamic(declaredField)) {
                    int parameterOffset = TypeDecoder.decodeDynamicStructDynamicParameterOffset(input.substring(beginIndex, beginIndex + 64)) + offset;
                    parameterOffsets.add(parameterOffset);
                    staticOffset += 64;
                    continue;
                }
                if (StaticStruct.class.isAssignableFrom(declaredField)) {
                    value = TypeDecoder.decodeStaticStruct(input.substring(beginIndex), 0, TypeReference.create(declaredField));
                    staticOffset += Utils.staticStructNestedPublicFieldsFlatList(declaredField).size() * 64;
                } else {
                    value = TypeDecoder.decode(input.substring(beginIndex), 0, declaredField);
                    staticOffset += value.bytes32PaddedLength() * 2;
                }
                parameters.put(i, value);
            }
            int dynamicParametersProcessed = 0;
            int dynamicParametersToProcess = TypeDecoder.getDynamicStructDynamicParametersCount(constructor.getParameterTypes());
            for (int i = 0; i < length; ++i) {
                Class<?> declaredField = constructor.getParameterTypes()[i];
                if (!TypeDecoder.isDynamic(declaredField)) continue;
                boolean isLastParameterInStruct = dynamicParametersProcessed == dynamicParametersToProcess - 1;
                int parameterLength = isLastParameterInStruct ? input.length() - (Integer)parameterOffsets.get(dynamicParametersProcessed) : (Integer)parameterOffsets.get(dynamicParametersProcessed + 1) - (Integer)parameterOffsets.get(dynamicParametersProcessed);
                Class parameterFromAnnotation = Utils.extractParameterFromAnnotation(constructor.getParameterAnnotations()[i]);
                parameters.put(i, TypeDecoder.decodeDynamicParameterFromStruct(input, (Integer)parameterOffsets.get(dynamicParametersProcessed), parameterLength, declaredField, parameterFromAnnotation));
                ++dynamicParametersProcessed;
            }
            String typeName = Utils.getSimpleTypeName(classType);
            ArrayList<Type> elements = new ArrayList<Type>();
            for (int i = 0; i < length; ++i) {
                elements.add((Type)parameters.get(i));
            }
            return (T)((Type)consumer.apply(elements, typeName));
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("Unable to access parameterized type " + Utils.getTypeName(typeReference.getType()), e);
        }
    }

    private static <T extends Type> int getDynamicStructDynamicParametersCount(Class<?>[] cls) {
        return (int)Arrays.stream(cls).filter(c -> TypeDecoder.isDynamic(c)).count();
    }

    private static <T extends Type> T decodeDynamicParameterFromStruct(String input, int parameterOffset, int parameterLength, Class<T> declaredField, Class<T> parameter) throws ClassNotFoundException {
        Object value;
        String dynamicElementData = input.substring(parameterOffset, parameterOffset + parameterLength);
        if (DynamicStruct.class.isAssignableFrom(declaredField)) {
            value = TypeDecoder.decodeDynamicStruct(dynamicElementData, 0, TypeReference.create(declaredField));
        } else if (DynamicArray.class.isAssignableFrom(declaredField)) {
            if (parameter == null) {
                throw new RuntimeException("parameter can not be null, try to use annotation @Parameterized to specify the parameter type");
            }
            value = TypeDecoder.decodeDynamicArray(dynamicElementData, 0, Utils.getDynamicArrayTypeReference(parameter));
        } else {
            value = TypeDecoder.decode(dynamicElementData, declaredField);
        }
        return value;
    }

    private static <T extends Type> T decodeDynamicParameterFromStructWithTypeReference(String input, int parameterOffset, int parameterLength, TypeReference<T> parameterTypeReference) throws ClassNotFoundException {
        String dynamicElementData = input.substring(parameterOffset, parameterOffset + parameterLength);
        Class<T> declaredField = parameterTypeReference.getClassType();
        T value = DynamicStruct.class.isAssignableFrom(declaredField) ? TypeDecoder.decodeDynamicStruct(dynamicElementData, 0, parameterTypeReference) : (DynamicArray.class.isAssignableFrom(declaredField) ? TypeDecoder.decodeDynamicArray(dynamicElementData, 0, parameterTypeReference) : TypeDecoder.decode(dynamicElementData, declaredField));
        return value;
    }

    private static int decodeDynamicStructDynamicParameterOffset(String input) {
        return TypeDecoder.decodeUintAsInt(input, 0) * 2;
    }

    static <T extends Type> boolean isDynamic(Class<T> parameter) {
        return DynamicBytes.class.isAssignableFrom(parameter) || Utf8String.class.isAssignableFrom(parameter) || DynamicArray.class.isAssignableFrom(parameter) || DynamicStruct.class.isAssignableFrom(parameter);
    }

    static BigInteger asBigInteger(Object arg) {
        if (arg instanceof BigInteger) {
            return (BigInteger)arg;
        }
        if (arg instanceof BigDecimal) {
            return ((BigDecimal)arg).toBigInteger();
        }
        if (arg instanceof String) {
            return Numeric.toBigInt((String)((String)arg));
        }
        if (arg instanceof byte[]) {
            return Numeric.toBigInt((byte[])((byte[])arg));
        }
        if (arg instanceof Double || arg instanceof Float || arg instanceof java.lang.Double || arg instanceof java.lang.Float) {
            return BigDecimal.valueOf(((Number)arg).doubleValue()).toBigInteger();
        }
        if (arg instanceof Number) {
            return BigInteger.valueOf(((Number)arg).longValue());
        }
        return null;
    }

    static List arrayToList(Object array) {
        int len = java.lang.reflect.Array.getLength(array);
        ArrayList<Object> rslt = new ArrayList<Object>(len);
        for (int i = 0; i < len; ++i) {
            rslt.add(java.lang.reflect.Array.get(array, i));
        }
        return rslt;
    }

    private static <T extends Type> T instantiateStaticArray(List<T> elements, int length) {
        try {
            Class<?> arrayClass = Class.forName("org.web3j.abi.datatypes.generated.StaticArray" + length);
            return (T)((Type)arrayClass.getConstructor(List.class).newInstance(elements));
        }
        catch (ReflectiveOperationException e) {
            throw new UnsupportedOperationException(e);
        }
    }

    private static <T extends Type> T decodeArrayElements(String input, int offset, TypeReference<T> typeReference, int length, BiFunction<List<T>, String, T> consumer) {
        try {
            final Class cls = Utils.getParameterizedTypeFromArray(typeReference);
            ArrayList<Object> elements = new ArrayList<Object>(length);
            if (StructType.class.isAssignableFrom(cls)) {
                int currOffset = offset;
                for (int i = 0; i < length; ++i) {
                    Object value;
                    if (DynamicStruct.class.isAssignableFrom(cls)) {
                        if (Optional.ofNullable(typeReference).map(x -> x.getSubTypeReference()).map(x -> x.getInnerTypes()).isPresent()) {
                            value = TypeDecoder.decodeDynamicStruct(input, offset + DefaultFunctionReturnDecoder.getDataOffset(input, currOffset, typeReference), new TypeReference<DynamicStruct>(typeReference.isIndexed(), typeReference.getSubTypeReference().getInnerTypes()){});
                            currOffset += TypeDecoder.getSingleElementLength(input, currOffset, cls) * 64;
                        } else {
                            value = TypeDecoder.decodeDynamicStruct(input, offset + DefaultFunctionReturnDecoder.getDataOffset(input, currOffset, typeReference), TypeReference.create(cls));
                            currOffset += TypeDecoder.getSingleElementLength(input, currOffset, cls) * 64;
                        }
                    } else if (Optional.ofNullable(typeReference).map(x -> x.getSubTypeReference()).map(x -> x.getInnerTypes()).isPresent()) {
                        value = TypeDecoder.decodeStaticStruct(input, currOffset, typeReference.getSubTypeReference());
                        currOffset += TypeDecoder.countNestedFields(typeReference.getSubTypeReference()) * 64;
                    } else {
                        value = TypeDecoder.decodeStaticStruct(input, currOffset, TypeReference.create(cls));
                        currOffset += TypeDecoder.getSingleElementLength(input, currOffset, cls) * 64;
                    }
                    elements.add(value);
                }
                String typeName = Utils.getSimpleTypeName(cls);
                return (T)((Type)consumer.apply(elements, typeName));
            }
            if (Array.class.isAssignableFrom(cls)) {
                int currOffset = offset;
                for (int i = 0; i < length; ++i) {
                    Array value;
                    if (DynamicArray.class.isAssignableFrom(cls)) {
                        value = TypeDecoder.decodeDynamicArray(input, offset + DefaultFunctionReturnDecoder.getDataOffset(input, currOffset, typeReference), Utils.getDynamicArrayTypeReference(Utils.getFullParameterizedTypeFromArray(typeReference)));
                        currOffset += TypeDecoder.getSingleElementLength(input, currOffset, cls) * 64;
                    } else {
                        String typeName = cls.getSimpleName();
                        String extractedLength = typeName.substring(typeName.replaceAll("[0-9]+$", "").length());
                        int staticLength = extractedLength.isEmpty() ? 0 : Integer.parseInt(extractedLength);
                        final TypeReference innerType = TypeReference.create(Utils.getFullParameterizedTypeFromArray(typeReference));
                        TypeReference.StaticArrayTypeReference<StaticArray> staticReference = new TypeReference.StaticArrayTypeReference<StaticArray>(staticLength){

                            @Override
                            public TypeReference getSubTypeReference() {
                                return innerType;
                            }

                            @Override
                            public boolean isIndexed() {
                                return false;
                            }

                            @Override
                            public java.lang.reflect.Type getType() {
                                return new ParameterizedType(){

                                    @Override
                                    public java.lang.reflect.Type[] getActualTypeArguments() {
                                        return new java.lang.reflect.Type[]{innerType.getType()};
                                    }

                                    @Override
                                    public java.lang.reflect.Type getRawType() {
                                        return cls;
                                    }

                                    @Override
                                    public java.lang.reflect.Type getOwnerType() {
                                        return Class.class;
                                    }
                                };
                            }
                        };
                        value = TypeDecoder.decodeStaticArray(input, currOffset, staticReference, staticLength);
                        currOffset += (TypeDecoder.decodeUintAsInt(input, currOffset) / 32 + 2) * 64;
                    }
                    elements.add(value);
                }
                return (T)((Type)consumer.apply(elements, cls.getName()));
            }
            int currOffset = offset;
            for (int i = 0; i < length; ++i) {
                Object value;
                if (TypeDecoder.isDynamic(cls)) {
                    int hexStringDataOffset = DefaultFunctionReturnDecoder.getDataOffset(input, currOffset, typeReference);
                    value = TypeDecoder.decode(input, offset + hexStringDataOffset, cls);
                    currOffset += 64;
                } else {
                    value = TypeDecoder.decode(input, currOffset, cls);
                    currOffset += TypeDecoder.getSingleElementLength(input, currOffset, cls) * 64;
                }
                elements.add(value);
            }
            String typeName = Utils.getSimpleTypeName(cls);
            return (T)((Type)consumer.apply(elements, typeName));
        }
        catch (ClassNotFoundException e) {
            throw new UnsupportedOperationException("Unable to access parameterized type " + Utils.getTypeName(typeReference.getType()), e);
        }
    }

    private static class ParameterOffsetTracker<T extends Type> {
        public final Map<Integer, T> parameters;
        public final List<Integer> parameterOffsets;
        public int staticOffset;
        public int dynamicParametersToProcess;

        ParameterOffsetTracker(Map<Integer, T> parametersIn, List<Integer> parameterOffsetsIn, int staticOffsetIn, int dynamicParametersToProcessIn) {
            this.parameters = parametersIn;
            this.parameterOffsets = parameterOffsetsIn;
            this.staticOffset = staticOffsetIn;
            this.dynamicParametersToProcess = this.dynamicParametersToProcess;
        }
    }
}

