/*
 * Decompiled with CFR 0.152.
 */
package systems.comodal.jsoniter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.util.Arrays;
import java.util.Base64;
import systems.comodal.jsoniter.CharBufferConsumer;
import systems.comodal.jsoniter.CharBufferFunction;
import systems.comodal.jsoniter.CharBufferPredicate;
import systems.comodal.jsoniter.CharBufferToIntFunction;
import systems.comodal.jsoniter.CharBufferToLongFunction;
import systems.comodal.jsoniter.ContextCharBufferConsumer;
import systems.comodal.jsoniter.ContextCharBufferFunction;
import systems.comodal.jsoniter.ContextCharBufferPredicate;
import systems.comodal.jsoniter.ContextCharBufferToIntFunction;
import systems.comodal.jsoniter.ContextCharBufferToLongFunction;
import systems.comodal.jsoniter.ContextFieldBufferFunction;
import systems.comodal.jsoniter.ContextFieldBufferMaskedPredicate;
import systems.comodal.jsoniter.ContextFieldBufferPredicate;
import systems.comodal.jsoniter.FieldBufferFunction;
import systems.comodal.jsoniter.FieldBufferPredicate;
import systems.comodal.jsoniter.InstantParser;
import systems.comodal.jsoniter.JsonException;
import systems.comodal.jsoniter.JsonIterator;
import systems.comodal.jsoniter.ValueType;

abstract class BaseJsonIterator
implements JsonIterator {
    protected static final CharBufferFunction<String> READ_STRING_FUNCTION = String::new;
    static final int INVALID_CHAR_FOR_NUMBER = -1;
    static final int[] INT_DIGITS = INIT_INT_DIGITS.initIntDigits();
    private static final CharBufferFunction<BigDecimal> READ_BIG_DECIMAL_FUNCTION = (chars, offset, len) -> len == 0 ? null : new BigDecimal(chars, offset, len);
    private static final CharBufferFunction<BigDecimal> READ_BIG_DECIMAL_DROP_TRAILING_ZEROES_FUNCTION = (chars, offset, len) -> {
        if (len == 1) {
            return chars[offset] == '0' ? BigDecimal.ZERO : new BigDecimal(chars, offset, len);
        }
        if (len == 0) {
            return null;
        }
        int pos = offset + len - 1;
        if (chars[pos] != '0') {
            return new BigDecimal(chars, offset, len);
        }
        char c = chars[--pos];
        while (c == '0') {
            if (pos == offset) {
                return BigDecimal.ZERO;
            }
            c = chars[--pos];
        }
        int j = pos;
        while (c != '.') {
            if (c == 'e' || c == 'E') {
                return new BigDecimal(chars, offset, len).stripTrailingZeros();
            }
            if (j == offset) {
                return new BigDecimal(chars, offset, len);
            }
            c = chars[--j];
        }
        return new BigDecimal(chars, offset, pos + 1 - offset);
    };
    private static final CharBufferFunction<BigInteger> READ_BIG_INTEGER_FUNCTION = (chars, offset, len) -> new BigInteger(new String(chars, offset, len));
    int head;
    int tail;

    BaseJsonIterator(int head, int tail) {
        this.head = head;
        this.tail = tail;
    }

    @Override
    public int mark() {
        return this.head;
    }

    @Override
    public JsonIterator reset(int mark) {
        this.head = mark;
        return this;
    }

    abstract String getBufferString(int var1, int var2);

    final JsonException reportError(String op, String msg) {
        String peek = this.getBufferString(this.head <= 10 ? 0 : this.head - 10, Math.min(this.head, this.tail));
        throw new JsonException(op + ": " + msg + ", head: " + this.head + ", peek: " + peek + ", buf: " + this.getBufferString(0, 1024));
    }

    @Override
    public final String currentBuffer() {
        String peek = this.getBufferString(this.head <= 10 ? 0 : this.head - 10, this.head);
        return "head: " + this.head + ", peek: " + peek + ", buf: " + this.getBufferString(0, 1024);
    }

    abstract char readChar();

    abstract char peekChar();

    abstract char peekChar(int var1);

    abstract int peekIntDigitChar(int var1);

    abstract char nextToken();

    abstract char peekToken();

    boolean loadMore() {
        return false;
    }

    protected final void skip(int n) {
        this.head += n;
        if (this.head >= this.tail) {
            int more = this.head - this.tail;
            if (!this.loadMore()) {
                if (more == 0) {
                    this.head = this.tail;
                    return;
                }
                throw this.reportError("skip", "unexpected end");
            }
            this.head += more;
        }
    }

    @Override
    public final JsonIterator openArray() {
        char c = this.nextToken();
        if (c == '[') {
            return this;
        }
        throw this.reportError("openArray", "expected '[' but found: " + c);
    }

    @Override
    public final JsonIterator continueArray() {
        char c = this.nextToken();
        if (c == ',') {
            return this;
        }
        throw this.reportError("continueArray", "expected ',' but found: " + c);
    }

    @Override
    public final JsonIterator closeArray() {
        char c = this.nextToken();
        if (c == ']') {
            return this;
        }
        throw this.reportError("closeArray", "expected ']' but found: " + c);
    }

    @Override
    public final String readString() {
        char c = this.nextToken();
        if (c == '\"') {
            return this.parseString();
        }
        if (c == 'n') {
            this.skip(3);
            return null;
        }
        throw this.reportError("readString", "expected string or null, but " + c);
    }

    @Override
    public byte[] decodeBase64String() {
        return Base64.getDecoder().decode(this.readString());
    }

    abstract int parse();

    abstract void skipPastEndQuote();

    @Override
    public final <R> R applyChars(CharBufferFunction<R> applyChars) {
        char c = this.nextToken();
        if (c == '\"') {
            return this.parse(applyChars);
        }
        if (c == 'n') {
            this.skip(3);
            return null;
        }
        throw this.reportError("applyChars", "expected string or null, but " + c);
    }

    abstract <R> R parse(CharBufferFunction<R> var1);

    @Override
    public final <C, R> R applyChars(C context, ContextCharBufferFunction<C, R> applyChars) {
        char c = this.nextToken();
        if (c == '\"') {
            return this.parse(context, applyChars);
        }
        if (c == 'n') {
            this.skip(3);
            return null;
        }
        throw this.reportError("applyChars", "expected string or null, but " + c);
    }

    abstract <C, R> R parse(C var1, ContextCharBufferFunction<C, R> var2);

    @Override
    public final int applyCharsAsInt(CharBufferToIntFunction applyChars) {
        char c = this.nextToken();
        if (c == '\"') {
            return this.parse(applyChars);
        }
        if (c == 'n') {
            this.skip(3);
            return applyChars.applyAsInt(new char[0], 0, 0);
        }
        throw this.reportError("applyCharsAsInt", "expected string or null, but " + c);
    }

    abstract int parse(CharBufferToIntFunction var1);

    @Override
    public final <C> int applyCharsAsInt(C context, ContextCharBufferToIntFunction<C> applyChars) {
        char c = this.nextToken();
        if (c == '\"') {
            return this.parse(context, applyChars);
        }
        if (c == 'n') {
            this.skip(3);
            return applyChars.applyAsInt(context, new char[0], 0, 0);
        }
        throw this.reportError("applyCharsAsInt", "expected string or null, but " + c);
    }

    abstract <C> int parse(C var1, ContextCharBufferToIntFunction<C> var2);

    @Override
    public final long applyCharsAsLong(CharBufferToLongFunction applyChars) {
        char c = this.nextToken();
        if (c == '\"') {
            return this.parse(applyChars);
        }
        if (c == 'n') {
            this.skip(3);
            return applyChars.applyAsLong(new char[0], 0, 0);
        }
        throw this.reportError("applyCharsAsLong", "expected string or null, but " + c);
    }

    abstract long parse(CharBufferToLongFunction var1);

    @Override
    public final <C> long applyCharsAsLong(C context, ContextCharBufferToLongFunction<C> applyChars) {
        char c = this.nextToken();
        if (c == '\"') {
            return this.parse(context, applyChars);
        }
        if (c == 'n') {
            this.skip(3);
            return applyChars.applyAsLong(context, new char[0], 0, 0);
        }
        throw this.reportError("applyCharsAsLong", "expected string or null, but " + c);
    }

    abstract <C> long parse(C var1, ContextCharBufferToLongFunction<C> var2);

    @Override
    public final boolean testChars(CharBufferPredicate testChars) {
        char c = this.nextToken();
        if (c == '\"') {
            return this.parse(testChars);
        }
        if (c == 'n') {
            this.skip(3);
            return false;
        }
        throw this.reportError("testChars", "expected string or null, but " + c);
    }

    abstract boolean parse(CharBufferPredicate var1);

    @Override
    public final <C> boolean testChars(C context, ContextCharBufferPredicate<C> testChars) {
        char c = this.nextToken();
        if (c == '\"') {
            return this.parse(context, testChars);
        }
        if (c == 'n') {
            this.skip(3);
            return false;
        }
        throw this.reportError("testChars", "expected string or null, but " + c);
    }

    abstract <C> boolean parse(C var1, ContextCharBufferPredicate<C> var2);

    @Override
    public final void consumeChars(CharBufferConsumer testChars) {
        char c = this.nextToken();
        if (c == '\"') {
            this.parse(testChars);
        } else if (c == 'n') {
            this.skip(3);
        } else {
            throw this.reportError("consumeChars", "expected string or null, but " + c);
        }
    }

    abstract void parse(CharBufferConsumer var1);

    @Override
    public final <C> void consumeChars(C context, ContextCharBufferConsumer<C> testChars) {
        char c = this.nextToken();
        if (c == '\"') {
            this.parse(context, testChars);
        } else if (c == 'n') {
            this.skip(3);
        } else {
            throw this.reportError("consumeChars", "expected string or null, but " + c);
        }
    }

    abstract <C> void parse(C var1, ContextCharBufferConsumer<C> var2);

    abstract boolean fieldEquals(String var1, int var2, int var3);

    @Override
    public final JsonIterator skipUntil(String field) {
        char c;
        block9: {
            while (true) {
                int len;
                int offset;
                if ((c = this.nextToken()) == ',') {
                    c = this.nextToken();
                    if (c != '\"') {
                        throw this.reportError("skipUntil", "expected string field, but " + c);
                    }
                    offset = this.head;
                    len = this.parse();
                    c = this.nextToken();
                    if (c != ':') {
                        throw this.reportError("skipUntil", "expected :, but " + c);
                    }
                    if (this.fieldEquals(field, offset, len)) {
                        return this;
                    }
                    this.skip();
                    continue;
                }
                if (c != '{') break block9;
                c = this.nextToken();
                if (c != '\"') break;
                offset = this.head;
                len = this.parse();
                c = this.nextToken();
                if (c != ':') {
                    throw this.reportError("skipUntil", "expected :, but " + c);
                }
                if (this.fieldEquals(field, offset, len)) {
                    return this;
                }
                this.skip();
            }
            if (c == '}') {
                return null;
            }
            throw this.reportError("skipUntil", "expected \" after {");
        }
        if (c == '}') {
            return null;
        }
        throw this.reportError("skipUntil", "expected [\\{\\}n], but found: " + c);
    }

    @Override
    public final boolean testObjField(CharBufferPredicate testField) {
        char c = this.nextToken();
        if (c == ',') {
            c = this.nextToken();
            if (c != '\"') {
                throw this.reportError("testObjField", "expected field string, but " + c);
            }
            boolean result = this.parse(testField);
            c = this.nextToken();
            if (c != ':') {
                throw this.reportError("testObjField", "expected :, but " + c);
            }
            return result;
        }
        if (c == '{') {
            c = this.nextToken();
            if (c == '\"') {
                boolean result = this.parse(testField);
                c = this.nextToken();
                if (c != ':') {
                    throw this.reportError("testObjField", "expected :, but " + c);
                }
                return result;
            }
            if (c == '}') {
                return false;
            }
            throw this.reportError("testObjField", "expected \" after {");
        }
        if (c == '}') {
            return false;
        }
        if (c == 'n') {
            this.skip(3);
            return false;
        }
        throw this.reportError("testObjField", "expected [\\{\\}n], but found: " + c);
    }

    @Override
    public final <R> R applyObjField(CharBufferFunction<R> applyChars) {
        char c = this.nextToken();
        if (c == ',') {
            c = this.nextToken();
            if (c != '\"') {
                throw this.reportError("applyObjField", "expected field string, but " + c);
            }
            R result = this.parse(applyChars);
            c = this.nextToken();
            if (c != ':') {
                throw this.reportError("applyObjField", "expected :, but " + c);
            }
            return result;
        }
        if (c == '{') {
            c = this.nextToken();
            if (c == '\"') {
                R result = this.parse(applyChars);
                c = this.nextToken();
                if (c != ':') {
                    throw this.reportError("applyObjField", "expected :, but " + c);
                }
                return result;
            }
            if (c == '}') {
                return null;
            }
            throw this.reportError("applyObjField", "expected \" after {");
        }
        if (c == '}') {
            return null;
        }
        if (c == 'n') {
            R result = applyChars.apply(new char[0], 0, 0);
            this.skip(3);
            return result;
        }
        throw this.reportError("applyObjField", "expected [\\{\\}n], but found: " + c);
    }

    @Override
    public final int applyObjFieldAsInt(CharBufferToIntFunction applyChars, int terminalSentinel) {
        char c = this.nextToken();
        if (c == ',') {
            c = this.nextToken();
            if (c != '\"') {
                throw this.reportError("applyObjFieldAsInt", "expected field string, but " + c);
            }
            int result = this.parse(applyChars);
            c = this.nextToken();
            if (c != ':') {
                throw this.reportError("applyObjFieldAsInt", "expected :, but " + c);
            }
            return result;
        }
        if (c == '{') {
            c = this.nextToken();
            if (c == '\"') {
                int result = this.parse(applyChars);
                c = this.nextToken();
                if (c != ':') {
                    throw this.reportError("applyObjFieldAsInt", "expected :, but " + c);
                }
                return result;
            }
            if (c == '}') {
                return terminalSentinel;
            }
            throw this.reportError("applyObjFieldAsInt", "expected \" after {");
        }
        if (c == '}') {
            return terminalSentinel;
        }
        if (c == 'n') {
            int result = applyChars.applyAsInt(new char[0], 0, 0);
            this.skip(3);
            return result;
        }
        throw this.reportError("applyObjFieldAsInt", "expected [\\{\\}n], but found: " + c);
    }

    @Override
    public final <C> int applyObjFieldAsInt(C context, ContextCharBufferToIntFunction<C> applyChars, int terminalSentinel) {
        char c = this.nextToken();
        if (c == ',') {
            c = this.nextToken();
            if (c != '\"') {
                throw this.reportError("applyObjFieldAsInt", "expected field string, but " + c);
            }
            int result = this.parse(context, applyChars);
            c = this.nextToken();
            if (c != ':') {
                throw this.reportError("applyObjFieldAsInt", "expected :, but " + c);
            }
            return result;
        }
        if (c == '{') {
            c = this.nextToken();
            if (c == '\"') {
                int result = this.parse(context, applyChars);
                c = this.nextToken();
                if (c != ':') {
                    throw this.reportError("applyObjFieldAsInt", "expected :, but " + c);
                }
                return result;
            }
            if (c == '}') {
                return terminalSentinel;
            }
            throw this.reportError("applyObjFieldAsInt", "expected \" after {");
        }
        if (c == '}') {
            return terminalSentinel;
        }
        if (c == 'n') {
            int result = applyChars.applyAsInt(context, new char[0], 0, 0);
            this.skip(3);
            return result;
        }
        throw this.reportError("applyObjFieldAsInt", "expected [\\{\\}n], but found: " + c);
    }

    @Override
    public final long applyObjFieldAsLong(CharBufferToLongFunction applyChars, long terminalSentinel) {
        char c = this.nextToken();
        if (c == ',') {
            c = this.nextToken();
            if (c != '\"') {
                throw this.reportError("applyObjFieldAsLong", "expected field string, but " + c);
            }
            long result = this.parse(applyChars);
            c = this.nextToken();
            if (c != ':') {
                throw this.reportError("applyObjFieldAsLong", "expected :, but " + c);
            }
            return result;
        }
        if (c == '{') {
            c = this.nextToken();
            if (c == '\"') {
                long result = this.parse(applyChars);
                c = this.nextToken();
                if (c != ':') {
                    throw this.reportError("applyObjFieldAsLong", "expected :, but " + c);
                }
                return result;
            }
            if (c == '}') {
                return terminalSentinel;
            }
            throw this.reportError("applyObjFieldAsLong", "expected \" after {");
        }
        if (c == '}') {
            return terminalSentinel;
        }
        if (c == 'n') {
            long result = applyChars.applyAsLong(new char[0], 0, 0);
            this.skip(3);
            return result;
        }
        throw this.reportError("applyObjFieldAsLong", "expected [\\{\\}n], but found: " + c);
    }

    @Override
    public final <C> long applyObjFieldAsLong(C context, ContextCharBufferToLongFunction<C> applyChars, long terminalSentinel) {
        char c = this.nextToken();
        if (c == ',') {
            c = this.nextToken();
            if (c != '\"') {
                throw this.reportError("applyObjFieldAsLong", "expected field string, but " + c);
            }
            long result = this.parse(context, applyChars);
            c = this.nextToken();
            if (c != ':') {
                throw this.reportError("applyObjFieldAsLong", "expected :, but " + c);
            }
            return result;
        }
        if (c == '{') {
            c = this.nextToken();
            if (c == '\"') {
                long result = this.parse(context, applyChars);
                c = this.nextToken();
                if (c != ':') {
                    throw this.reportError("applyObjFieldAsLong", "expected :, but " + c);
                }
                return result;
            }
            if (c == '}') {
                return terminalSentinel;
            }
            throw this.reportError("applyObjFieldAsLong", "expected \" after {");
        }
        if (c == '}') {
            return terminalSentinel;
        }
        if (c == 'n') {
            long result = applyChars.applyAsLong(context, new char[0], 0, 0);
            this.skip(3);
            return result;
        }
        throw this.reportError("applyObjFieldAsLong", "expected [\\{\\}n], but found: " + c);
    }

    protected String parseString() {
        return this.parse(READ_STRING_FUNCTION);
    }

    @Override
    public final String readObjField() {
        char c = this.nextToken();
        if (c == ',') {
            c = this.nextToken();
            if (c == '\"') {
                String field = this.parseString();
                c = this.nextToken();
                if (c == ':') {
                    return field;
                }
                throw this.reportError("readObjField", "expected :, but " + c);
            }
            throw this.reportError("readObjField", "expected field string, but " + c);
        }
        if (c == '{') {
            c = this.nextToken();
            if (c == '\"') {
                String field = this.parseString();
                c = this.nextToken();
                if (c == ':') {
                    return field;
                }
                throw this.reportError("readObjField", "expected :, but " + c);
            }
            if (c == '}') {
                return null;
            }
            throw this.reportError("readObjField", "expected \" after {");
        }
        if (c == '}') {
            return null;
        }
        if (c == 'n') {
            this.skip(3);
            return null;
        }
        throw this.reportError("readObjField", "expected [\\{\\}n], but found: " + c);
    }

    @Override
    public final JsonIterator skipObjField() {
        char c = this.nextToken();
        if (c == ',') {
            c = this.nextToken();
            if (c != '\"') {
                throw this.reportError("skipObjField", "expected string field, but " + c);
            }
            this.skipPastEndQuote();
            c = this.nextToken();
            if (c == ':') {
                return this;
            }
            throw this.reportError("skipObjField", "expected :, but " + c);
        }
        if (c == '{') {
            c = this.nextToken();
            if (c == '\"') {
                this.skipPastEndQuote();
                c = this.nextToken();
                if (c == ':') {
                    return this;
                }
                throw this.reportError("skipObjField", "expected :, but " + c);
            }
            if (c == '}') {
                return null;
            }
            throw this.reportError("skipObjField", "expected \" after {");
        }
        if (c == '}') {
            return null;
        }
        if (c == 'n') {
            this.skip(3);
            return null;
        }
        throw this.reportError("skipObjField", "expected [,{}n], but found: " + c);
    }

    @Override
    public final JsonIterator closeObj() {
        char c = this.nextToken();
        if (c == '}') {
            return this;
        }
        throw this.reportError("closeObj", "expected '}' but found: " + c);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final void testObject(FieldBufferPredicate fieldBufferFunction) {
        block6: {
            block7: {
                do lbl-1000:
                // 3 sources

                {
                    block8: {
                        if ((c = this.nextToken()) != ',') break block8;
                        c = this.nextToken();
                        if (c != '\"') {
                            throw this.reportError("testObject", "expected string field, but " + c);
                        }
                        offset = this.head;
                        len = this.parse();
                        c = this.nextToken();
                        if (c != ':') {
                            throw this.reportError("testObject", "expected :, but " + c);
                        }
                        if (!this.breakOut(fieldBufferFunction, offset, len)) ** GOTO lbl-1000
                        return;
                    }
                    if (c != '{') break block6;
                    c = this.nextToken();
                    if (c != '\"') break block7;
                    offset = this.head;
                    len = this.parse();
                    c = this.nextToken();
                    if (c == ':') continue;
                    throw this.reportError("testObject", "expected :, but " + c);
                } while (!this.breakOut(fieldBufferFunction, offset, len));
                return;
            }
            if (c == '}') {
                return;
            }
            throw this.reportError("testObject", "expected \" after {");
        }
        if (c == '}') {
            return;
        }
        if (c == 'n') {
            this.skip(3);
            return;
        }
        throw this.reportError("testObject", "expected [,{}n], but found: " + c);
    }

    abstract boolean breakOut(FieldBufferPredicate var1, int var2, int var3);

    /*
     * Unable to fully structure code
     */
    @Override
    public final <C> C testObject(C context, ContextFieldBufferPredicate<C> fieldBufferFunction) {
        block6: {
            block7: {
                do lbl-1000:
                // 3 sources

                {
                    block8: {
                        if ((c = this.nextToken()) != ',') break block8;
                        c = this.nextToken();
                        if (c != '\"') {
                            throw this.reportError("testObject", "expected string field, but " + c);
                        }
                        offset = this.head;
                        len = this.parse();
                        c = this.nextToken();
                        if (c != ':') {
                            throw this.reportError("testObject", "expected :, but " + c);
                        }
                        if (!this.breakOut(context, fieldBufferFunction, offset, len)) ** GOTO lbl-1000
                        return context;
                    }
                    if (c != '{') break block6;
                    c = this.nextToken();
                    if (c != '\"') break block7;
                    offset = this.head;
                    len = this.parse();
                    c = this.nextToken();
                    if (c == ':') continue;
                    throw this.reportError("testObject", "expected :, but " + c);
                } while (!this.breakOut(context, fieldBufferFunction, offset, len));
                return context;
            }
            if (c == '}') {
                return context;
            }
            throw this.reportError("testObject", "expected \" after {");
        }
        if (c == '}') {
            return context;
        }
        if (c == 'n') {
            this.skip(3);
            return context;
        }
        throw this.reportError("testObject", "expected [,{}n], but found: " + c);
    }

    abstract <C> boolean breakOut(C var1, ContextFieldBufferPredicate<C> var2, int var3, int var4);

    /*
     * Unable to fully structure code
     */
    @Override
    public final <C> C testObject(C context, ContextFieldBufferMaskedPredicate<C> fieldBufferFunction) {
        block6: {
            block7: {
                mask = 0L;
                do lbl-1000:
                // 3 sources

                {
                    block8: {
                        if ((c = this.nextToken()) != ',') break block8;
                        c = this.nextToken();
                        if (c != '\"') {
                            throw this.reportError("testObject", "expected string field, but " + c);
                        }
                        offset = this.head;
                        len = this.parse();
                        c = this.nextToken();
                        if (c != ':') {
                            throw this.reportError("testObject", "expected :, but " + c);
                        }
                        if ((mask = this.test(context, mask, fieldBufferFunction, offset, len)) != -1L) ** GOTO lbl-1000
                        return context;
                    }
                    if (c != '{') break block6;
                    c = this.nextToken();
                    if (c != '\"') break block7;
                    offset = this.head;
                    len = this.parse();
                    c = this.nextToken();
                    if (c == ':') continue;
                    throw this.reportError("testObject", "expected :, but " + c);
                } while ((mask = this.test(context, mask, fieldBufferFunction, offset, len)) != -1L);
                return context;
            }
            if (c == '}') {
                return context;
            }
            throw this.reportError("testObject", "expected \" after {");
        }
        if (c == '}') {
            return context;
        }
        if (c == 'n') {
            this.skip(3);
            return context;
        }
        throw this.reportError("testObject", "expected [,{}n], but found: " + c);
    }

    abstract <C> long test(C var1, long var2, ContextFieldBufferMaskedPredicate<C> var4, int var5, int var6);

    @Override
    public final <R> R applyObject(FieldBufferFunction<R> fieldBufferFunction) {
        char c = this.nextToken();
        if (c == ',') {
            c = this.nextToken();
            if (c != '\"') {
                throw this.reportError("applyObject", "expected string field, but " + c);
            }
            int offset = this.head;
            int len = this.parse();
            c = this.nextToken();
            if (c != ':') {
                throw this.reportError("applyObject", "expected :, but " + c);
            }
            return this.apply(fieldBufferFunction, offset, len);
        }
        if (c == '{') {
            c = this.nextToken();
            if (c == '\"') {
                int offset = this.head;
                int len = this.parse();
                c = this.nextToken();
                if (c != ':') {
                    throw this.reportError("applyObject", "expected :, but " + c);
                }
                return this.apply(fieldBufferFunction, offset, len);
            }
            if (c == '}') {
                return null;
            }
            throw this.reportError("applyObject", "expected \" after {");
        }
        if (c == '}') {
            return null;
        }
        if (c == 'n') {
            this.skip(3);
            return null;
        }
        throw this.reportError("applyObject", "expected [,{}n], but found: " + c);
    }

    abstract <R> R apply(FieldBufferFunction<R> var1, int var2, int var3);

    @Override
    public final <C, R> R applyObject(C context, ContextFieldBufferFunction<C, R> fieldBufferFunction) {
        char c = this.nextToken();
        if (c == ',') {
            c = this.nextToken();
            if (c != '\"') {
                throw this.reportError("applyObject", "expected string field, but " + c);
            }
            int offset = this.head;
            int len = this.parse();
            c = this.nextToken();
            if (c != ':') {
                throw this.reportError("applyObject", "expected :, but " + c);
            }
            return this.apply(context, fieldBufferFunction, offset, len);
        }
        if (c == '{') {
            c = this.nextToken();
            if (c == '\"') {
                int offset = this.head;
                int len = this.parse();
                c = this.nextToken();
                if (c != ':') {
                    throw this.reportError("applyObject", "expected :, but " + c);
                }
                return this.apply(context, fieldBufferFunction, offset, len);
            }
            if (c == '}') {
                return null;
            }
            throw this.reportError("applyObject", "expected \" after {");
        }
        if (c == '}') {
            return null;
        }
        if (c == 'n') {
            this.skip(3);
            return null;
        }
        throw this.reportError("applyObject", "expected [,{}n], but found: " + c);
    }

    abstract <C, R> R apply(C var1, ContextFieldBufferFunction<C, R> var2, int var3, int var4);

    @Override
    public final double readDouble() {
        try {
            return Double.parseDouble(this.readNumberOrNumberString());
        }
        catch (NumberFormatException e) {
            throw this.reportError("readDouble", e.toString());
        }
    }

    @Override
    public final float readFloat() {
        try {
            return Float.parseFloat(this.readNumberOrNumberString());
        }
        catch (NumberFormatException e) {
            throw this.reportError("readFloat", e.toString());
        }
    }

    @Override
    public final BigDecimal readBigDecimal() {
        return this.readBigDecimal(READ_BIG_DECIMAL_FUNCTION);
    }

    @Override
    public final BigDecimal readBigDecimalDropZeroes() {
        return this.readBigDecimal(READ_BIG_DECIMAL_DROP_TRAILING_ZEROES_FUNCTION);
    }

    private BigDecimal readBigDecimal(CharBufferFunction<BigDecimal> parseChars) {
        ValueType valueType = this.whatIsNext();
        if (valueType == ValueType.STRING) {
            return this.applyChars(parseChars);
        }
        if (valueType == ValueType.NUMBER) {
            return this.parseBigDecimal(parseChars);
        }
        if (valueType == ValueType.NULL) {
            this.skip();
            return null;
        }
        throw this.reportError("readBigDecimal", "Must be a number, string or null but found " + String.valueOf((Object)valueType));
    }

    private long readLongSlowPath(long value, int scaleLimit) {
        boolean zero;
        if (value == 0L) {
            zero = true;
        } else {
            zero = false;
            value = -value;
        }
        int scale = 0;
        int i = this.head;
        while (true) {
            int ind;
            if (i == this.tail) {
                this.head = this.tail;
                if (!this.loadMore()) break;
                i = this.head;
            }
            if ((ind = this.peekIntDigitChar(i)) == -1) {
                this.head = i;
                break;
            }
            if (!zero && value < -922337203685477580L) {
                throw this.reportError("readLongSlowPath", "value is too large for long");
            }
            if (scale < scaleLimit) {
                if (zero) {
                    value = -ind;
                    zero = value == 0L;
                } else if ((value = (value << 3) + (value << 1) - (long)ind) >= 0L) {
                    throw this.reportError("readLongSlowPath", "value is too large for long");
                }
                ++scale;
            }
            ++i;
        }
        return zero ? 0L : this.scaleLong(value, scale, scaleLimit);
    }

    private long readUnscaledDigits(long integer, int scale) {
        char c;
        int mark = ++this.head;
        long unscaled = this.readLongSlowPath(integer, scale);
        if (this.head < this.tail && ((c = this.peekChar(this.head)) == 'e' || c == 'E')) {
            ++this.head;
            int exponent = this.readInt();
            if (exponent < 0) {
                return this.reduceScale(unscaled, exponent);
            }
            if (this.supportsMarkReset()) {
                int mark2 = this.head;
                this.head = mark;
                unscaled = this.readLongSlowPath(integer, scale + exponent);
                this.head = mark2;
            } else {
                throw this.reportError("readUnscaledAsLong", "Requires mark/reset.");
            }
        }
        return unscaled;
    }

    @Override
    public final long readUnscaledAsLong(int scale) {
        long unscaled;
        long integer;
        boolean negative;
        boolean closeString;
        char c = this.nextToken();
        ValueType valueType = ValueType.VALUE_TYPES[c];
        boolean bl = closeString = valueType == ValueType.STRING;
        if (closeString) {
            c = this.nextToken();
        } else if (valueType != ValueType.NUMBER) {
            throw this.reportError("readUnscaledAsLong", "Must be a number, string but found " + String.valueOf((Object)valueType));
        }
        if (c == '-') {
            negative = true;
            integer = this.readLong(this.readChar());
        } else {
            negative = false;
            integer = this.readLong(c);
            if (-integer == Long.MIN_VALUE) {
                throw this.reportError("readUnscaledAsLong", "value is too large for long");
            }
        }
        if (this.head == this.tail) {
            if (integer == 0L) {
                return 0L;
            }
            unscaled = this.scaleLong(-integer, 0, scale);
        } else {
            c = this.peekChar(this.head);
            if (c == '.') {
                unscaled = this.readUnscaledDigits(integer, scale);
            } else if (c == 'e' || c == 'E') {
                ++this.head;
                int exponent = scale + this.readInt();
                unscaled = exponent < 0 ? this.reduceScale(-integer, exponent) : this.scaleLong(-integer, 0, exponent);
            } else {
                if (integer == 0L) {
                    if (closeString) {
                        this.nextToken();
                    }
                    return 0L;
                }
                unscaled = this.scaleLong(-integer, 0, scale);
            }
        }
        if (closeString) {
            this.nextToken();
        }
        if (negative) {
            return unscaled;
        }
        if (unscaled == Long.MIN_VALUE) {
            throw this.reportError("readUnscaledAsLong", "value is too large for long");
        }
        return -unscaled;
    }

    private long reduceScale(long value, int scaleLimit) {
        int scale = 0;
        while (scale-- > scaleLimit) {
            value /= 10L;
        }
        return value;
    }

    private long scaleLong(long value, int scale, int scaleLimit) {
        while (scale++ < scaleLimit) {
            if (value < -922337203685477580L) {
                throw this.reportError("readLongSlowPath", "value is too large for long");
            }
            if ((value = (value << 3) + (value << 1)) < 0L) continue;
            throw this.reportError("readLongSlowPath", "value is too large for long");
        }
        return value;
    }

    abstract BigDecimal parseBigDecimal(CharBufferFunction<BigDecimal> var1);

    @Override
    public final BigInteger readBigInteger() {
        ValueType valueType = this.whatIsNext();
        if (valueType == ValueType.NUMBER) {
            return new BigInteger(this.readNumberAsString());
        }
        if (valueType == ValueType.STRING) {
            return this.applyChars(READ_BIG_INTEGER_FUNCTION);
        }
        if (valueType == ValueType.NULL) {
            this.skip();
            return null;
        }
        throw this.reportError("readBigInteger", "Must be a number, string or null but found " + String.valueOf((Object)valueType));
    }

    @Override
    public final Instant readDateTime() {
        return this.applyChars(InstantParser.INSTANT_PARSER);
    }

    @Override
    public String readNumberOrNumberString() {
        ValueType valueType = this.whatIsNext();
        if (valueType == ValueType.NUMBER) {
            return this.readNumberAsString();
        }
        if (valueType == ValueType.STRING) {
            return this.readString();
        }
        if (valueType == ValueType.NULL) {
            this.skip();
            return null;
        }
        throw this.reportError("readNumberOrNumberString", "Must be a number, string or null but found " + String.valueOf((Object)valueType));
    }

    @Override
    public final ValueType whatIsNext() {
        return ValueType.VALUE_TYPES[this.peekToken()];
    }

    private void skipUntilBreak() {
        int i = this.head;
        while (true) {
            if (i == this.tail) {
                if (this.loadMore()) {
                    i = this.head;
                } else {
                    this.head = this.tail;
                    return;
                }
            }
            switch (this.peekChar(i)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case ',': 
                case ']': 
                case '}': {
                    this.head = i;
                    return;
                }
            }
            ++i;
        }
    }

    private void skipArray() {
        int i = this.head;
        int level = 1;
        while (true) {
            char c;
            if (i == this.tail) {
                if (this.loadMore()) {
                    i = this.head;
                } else {
                    throw this.reportError("skipArray", "incomplete array");
                }
            }
            if ((c = this.peekChar(i)) == '\"') {
                this.head = i + 1;
                this.skipPastEndQuote();
                i = this.head - 1;
            } else if (c == '[') {
                ++level;
            } else if (c == ']' && --level == 0) {
                this.head = i + 1;
                return;
            }
            ++i;
        }
    }

    private void skipObject() {
        int i = this.head;
        int level = 1;
        while (true) {
            char c;
            if (i == this.tail) {
                if (this.loadMore()) {
                    i = this.head;
                } else {
                    throw this.reportError("skipObject", "incomplete object");
                }
            }
            if ((c = this.peekChar(i)) == '\"') {
                this.head = i + 1;
                this.skipPastEndQuote();
                i = this.head - 1;
            } else if (c == '{') {
                ++level;
            } else if (c == '}' && --level == 0) {
                this.head = i + 1;
                return;
            }
            ++i;
        }
    }

    @Override
    public final JsonIterator skip() {
        char c = this.nextToken();
        switch (c) {
            case '\"': {
                this.skipPastEndQuote();
                break;
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.skipUntilBreak();
                break;
            }
            case 'n': 
            case 't': {
                this.skip(3);
                break;
            }
            case 'f': {
                this.skip(4);
                break;
            }
            case '[': {
                this.skipArray();
                break;
            }
            case '{': {
                this.skipObject();
                break;
            }
            default: {
                throw this.reportError("skip", "Cannot skip: " + c);
            }
        }
        return this;
    }

    @Override
    public final boolean readNull() {
        char c = this.peekToken();
        if (c == 'n') {
            this.skip(4);
            return true;
        }
        return false;
    }

    @Override
    public final boolean readBoolean() {
        char c = this.nextToken();
        if (c == 't') {
            this.skip(3);
            return true;
        }
        if (c == 'f') {
            this.skip(4);
            return false;
        }
        throw this.reportError("readBoolean", "expected t or f, found: " + c);
    }

    private void assertNotLeadingZero() {
        if (this.head == this.tail && !this.loadMore()) {
            return;
        }
        char peek = this.peekChar();
        if (peek < INT_DIGITS.length && INT_DIGITS[peek] != -1) {
            throw this.reportError("assertNotLeadingZero", "leading zero is invalid");
        }
    }

    private int readIntSlowPath(int value) {
        value = -value;
        int i = this.head;
        while (true) {
            int ind;
            if (i == this.tail) {
                if (this.loadMore()) {
                    i = this.head;
                } else {
                    this.head = this.tail;
                    return -value;
                }
            }
            if ((ind = this.peekIntDigitChar(i)) == -1) {
                this.head = i;
                return -value;
            }
            if (value < -214748364) {
                throw this.reportError("readIntSlowPath", "value is too large for int");
            }
            if ((value = (value << 3) + (value << 1) - ind) >= 0) {
                throw this.reportError("readIntSlowPath", "value is too large for int");
            }
            ++i;
        }
    }

    private int readInt(char c) {
        int ind = INT_DIGITS[c];
        if (ind == 0) {
            this.assertNotLeadingZero();
            return 0;
        }
        if (ind == -1) {
            throw this.reportError("readInt", "expected 0~9");
        }
        if (this.tail - this.head > 9) {
            int ind8;
            int ind7;
            int ind6;
            int ind5;
            int ind4;
            int ind3;
            int i = this.head;
            int ind2 = this.peekIntDigitChar(i);
            if (ind2 == -1) {
                this.head = i;
                return ind;
            }
            if ((ind3 = this.peekIntDigitChar(++i)) == -1) {
                this.head = i;
                return ind * 10 + ind2;
            }
            if ((ind4 = this.peekIntDigitChar(++i)) == -1) {
                this.head = i;
                return ind * 100 + ind2 * 10 + ind3;
            }
            if ((ind5 = this.peekIntDigitChar(++i)) == -1) {
                this.head = i;
                return ind * 1000 + ind2 * 100 + ind3 * 10 + ind4;
            }
            if ((ind6 = this.peekIntDigitChar(++i)) == -1) {
                this.head = i;
                return ind * 10000 + ind2 * 1000 + ind3 * 100 + ind4 * 10 + ind5;
            }
            if ((ind7 = this.peekIntDigitChar(++i)) == -1) {
                this.head = i;
                return ind * 100000 + ind2 * 10000 + ind3 * 1000 + ind4 * 100 + ind5 * 10 + ind6;
            }
            if ((ind8 = this.peekIntDigitChar(++i)) == -1) {
                this.head = i;
                return ind * 1000000 + ind2 * 100000 + ind3 * 10000 + ind4 * 1000 + ind5 * 100 + ind6 * 10 + ind7;
            }
            int result = ind * 10000000 + ind2 * 1000000 + ind3 * 100000 + ind4 * 10000 + ind5 * 1000 + ind6 * 100 + ind7 * 10 + ind8;
            this.head = ++i;
            if (this.peekIntDigitChar(i) == -1) {
                return result;
            }
            return this.readIntSlowPath(result);
        }
        return this.readIntSlowPath(ind);
    }

    @Override
    public final int readInt() {
        char c = this.nextToken();
        if (c == '\"') {
            int val = this.readInt();
            if (this.nextToken() != '\"') {
                throw this.reportError("readInt", "Lenient parsing of number string did not close with a quote.");
            }
            return val;
        }
        if (c == '-') {
            return -this.readInt(this.readChar());
        }
        int val = this.readInt(c);
        if (-val == Integer.MIN_VALUE) {
            throw this.reportError("readInt", "value is too large for int");
        }
        return val;
    }

    @Override
    public final short readShort() {
        int v = this.readInt();
        if (Short.MIN_VALUE <= v && v <= Short.MAX_VALUE) {
            return (short)v;
        }
        throw this.reportError("readShort", "short overflow: " + v);
    }

    private long readLongSlowPath(long value) {
        value = -value;
        int i = this.head;
        while (true) {
            int ind;
            if (i == this.tail) {
                if (this.loadMore()) {
                    i = this.head;
                } else {
                    this.head = this.tail;
                    return -value;
                }
            }
            if ((ind = this.peekIntDigitChar(i)) == -1) {
                this.head = i;
                return -value;
            }
            if (value < -922337203685477580L) {
                throw this.reportError("readLongSlowPath", "value is too large for long");
            }
            if ((value = (value << 3) + (value << 1) - (long)ind) >= 0L) {
                throw this.reportError("readLongSlowPath", "value is too large for long");
            }
            ++i;
        }
    }

    private long readLong(char c) {
        long ind = INT_DIGITS[c];
        if (ind == 0L) {
            this.assertNotLeadingZero();
            return 0L;
        }
        if (ind == -1L) {
            throw this.reportError("readLong", "expected 0~9");
        }
        if (this.tail - this.head > 9) {
            int ind8;
            int ind7;
            int ind6;
            int ind5;
            int ind4;
            int ind3;
            int i = this.head;
            int ind2 = this.peekIntDigitChar(i);
            if (ind2 == -1) {
                this.head = i;
                return ind;
            }
            if ((ind3 = this.peekIntDigitChar(++i)) == -1) {
                this.head = i;
                return ind * 10L + (long)ind2;
            }
            if ((ind4 = this.peekIntDigitChar(++i)) == -1) {
                this.head = i;
                return ind * 100L + (long)ind2 * 10L + (long)ind3;
            }
            if ((ind5 = this.peekIntDigitChar(++i)) == -1) {
                this.head = i;
                return ind * 1000L + (long)ind2 * 100L + (long)ind3 * 10L + (long)ind4;
            }
            if ((ind6 = this.peekIntDigitChar(++i)) == -1) {
                this.head = i;
                return ind * 10000L + (long)ind2 * 1000L + (long)ind3 * 100L + (long)ind4 * 10L + (long)ind5;
            }
            if ((ind7 = this.peekIntDigitChar(++i)) == -1) {
                this.head = i;
                return ind * 100000L + (long)ind2 * 10000L + (long)ind3 * 1000L + (long)ind4 * 100L + (long)ind5 * 10L + (long)ind6;
            }
            if ((ind8 = this.peekIntDigitChar(++i)) == -1) {
                this.head = i;
                return ind * 1000000L + (long)ind2 * 100000L + (long)ind3 * 10000L + (long)ind4 * 1000L + (long)ind5 * 100L + (long)ind6 * 10L + (long)ind7;
            }
            long result = ind * 10000000L + (long)ind2 * 1000000L + (long)ind3 * 100000L + (long)ind4 * 10000L + (long)ind5 * 1000L + (long)ind6 * 100L + (long)ind7 * 10L + (long)ind8;
            this.head = ++i;
            if (this.peekIntDigitChar(i) == -1) {
                return result;
            }
            return this.readLongSlowPath(result);
        }
        return this.readLongSlowPath(ind);
    }

    @Override
    public final long readLong() {
        char c = this.nextToken();
        if (c == '\"') {
            long val = this.readLong();
            if (this.nextToken() != '\"') {
                throw this.reportError("readLong", "Lenient parsing of number string did not close with a quote.");
            }
            return val;
        }
        if (c == '-') {
            return -this.readLong(this.readChar());
        }
        long val = this.readLong(c);
        if (-val == Long.MIN_VALUE) {
            throw this.reportError("readLong", "value is too large for long");
        }
        return val;
    }

    @Override
    public final boolean readArray() {
        char c = this.nextToken();
        if (c == '[') {
            if (this.peekToken() == ']') {
                ++this.head;
                return false;
            }
            return true;
        }
        if (c == ',') {
            return true;
        }
        if (c == ']') {
            return false;
        }
        if (c == 'n') {
            this.skip(3);
            return false;
        }
        throw this.reportError("readArray", "expected [ or , or n or ], but found: " + c);
    }

    @Override
    public final String readNumberAsString() {
        return this.parsedNumberAsString(this.parseNumber());
    }

    abstract int parseNumber();

    abstract String parsedNumberAsString(int var1);

    @Override
    public final <R> R applyNumberChars(CharBufferFunction<R> applyChars) {
        return this.parseNumber(applyChars, this.parseNumber());
    }

    abstract <R> R parseNumber(CharBufferFunction<R> var1, int var2);

    @Override
    public final <C, R> R applyNumberChars(C context, ContextCharBufferFunction<C, R> applyChars) {
        return this.parseNumber(context, applyChars, this.parseNumber());
    }

    abstract <C, R> R parseNumber(C var1, ContextCharBufferFunction<C, R> var2, int var3);

    @Override
    public final int applyNumberCharsAsInt(CharBufferToIntFunction applyChars) {
        return this.parseNumber(applyChars, this.parseNumber());
    }

    abstract int parseNumber(CharBufferToIntFunction var1, int var2);

    @Override
    public final <C> int applyNumberCharsAsInt(C context, ContextCharBufferToIntFunction<C> applyChars) {
        return this.parseNumber(context, applyChars, this.parseNumber());
    }

    abstract <C> int parseNumber(C var1, ContextCharBufferToIntFunction<C> var2, int var3);

    @Override
    public final long applyNumberCharsAsLong(CharBufferToLongFunction applyChars) {
        return this.parseNumber(applyChars, this.parseNumber());
    }

    abstract long parseNumber(CharBufferToLongFunction var1, int var2);

    @Override
    public final <C> long applyNumberCharsAsLong(C context, ContextCharBufferToLongFunction<C> applyChars) {
        return this.parseNumber(context, applyChars, this.parseNumber());
    }

    abstract <C> long parseNumber(C var1, ContextCharBufferToLongFunction<C> var2, int var3);

    private static final class INIT_INT_DIGITS {
        private INIT_INT_DIGITS() {
        }

        private static int[] initIntDigits() {
            int[] intDigits = new int[127];
            Arrays.fill(intDigits, -1);
            for (int i = 48; i <= 57; ++i) {
                intDigits[i] = i - 48;
            }
            return intDigits;
        }
    }
}

