/*
 * Decompiled with CFR 0.152.
 */
package systems.comodal.jsoniter;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.IsoChronology;
import java.time.format.DateTimeParseException;
import systems.comodal.jsoniter.BaseJsonIterator;
import systems.comodal.jsoniter.CharBufferFunction;

public final class InstantParser {
    private static final int SECONDS_PER_HOUR = 3600;
    private static final int DAYS_PER_CYCLE = 146097;
    private static final long DAYS_0000_TO_1970 = 719528L;
    public static final CharBufferFunction<Instant> RFC_1123_INSTANT_PARSER = (buf, offset, len) -> {
        int month;
        int ind;
        int i = offset + 5;
        int day = BaseJsonIterator.INT_DIGITS[buf[i]];
        if (day == -1) {
            throw InstantParser.throwDateTimeParseException("Invalid day ", buf, offset, len, i - offset);
        }
        if ((ind = BaseJsonIterator.INT_DIGITS[buf[++i]]) == -1) {
            throw InstantParser.throwDateTimeParseException("Invalid day ", buf, offset, len, i - offset);
        }
        day = (day << 3) + (day << 1) + ind;
        char a = buf[i += 2];
        char b = buf[++i];
        char c = buf[++i];
        if (a == 'J') {
            if (b == 'a' && c == 'n') {
                month = 1;
            } else {
                if (b != 'u') throw InstantParser.throwDateTimeParseException("Invalid month ", buf, offset, len, i - offset);
                if (c == 'l') {
                    month = 7;
                } else {
                    if (c != 'n') throw InstantParser.throwDateTimeParseException("Invalid month ", buf, offset, len, i - offset);
                    month = 6;
                }
            }
        } else if (a == 'M') {
            if (b != 'a') throw InstantParser.throwDateTimeParseException("Invalid month ", buf, offset, len, i - offset);
            if (c == 'r') {
                month = 3;
            } else {
                if (c != 'y') throw InstantParser.throwDateTimeParseException("Invalid month ", buf, offset, len, i - offset);
                month = 5;
            }
        } else if (a == 'A') {
            if (b == 'p' && c == 'r') {
                month = 4;
            } else {
                if (b != 'u' || c != 'g') throw InstantParser.throwDateTimeParseException("Invalid month ", buf, offset, len, i - offset);
                month = 8;
            }
        } else if (a == 'F' && b == 'e' && c == 'b') {
            month = 2;
        } else if (a == 'S' && b == 'e' && c == 'p') {
            month = 9;
        } else if (a == 'O' && b == 'c' && c == 't') {
            month = 10;
        } else if (a == 'N' && b == 'o' && c == 'v') {
            month = 11;
        } else {
            if (a != 'D' || b != 'e' || c != 'c') throw InstantParser.throwDateTimeParseException("Invalid month ", buf, offset, len, i - offset);
            month = 12;
        }
        int year = BaseJsonIterator.INT_DIGITS[buf[i += 2]];
        if (year == -1) {
            throw InstantParser.throwDateTimeParseException("Invalid year ", buf, offset, len, 0);
        }
        if ((ind = BaseJsonIterator.INT_DIGITS[buf[++i]]) == -1) {
            throw InstantParser.throwDateTimeParseException("Invalid year ", buf, offset, len, i - offset);
        }
        year = (year << 3) + (year << 1) + ind;
        if ((ind = BaseJsonIterator.INT_DIGITS[buf[++i]]) == -1) {
            throw InstantParser.throwDateTimeParseException("Invalid year ", buf, offset, len, i - offset);
        }
        year = (year << 3) + (year << 1) + ind;
        if ((ind = BaseJsonIterator.INT_DIGITS[buf[++i]]) == -1) {
            throw InstantParser.throwDateTimeParseException("Invalid year ", buf, offset, len, i - offset);
        }
        year = (year << 3) + (year << 1) + ind;
        int hour = BaseJsonIterator.INT_DIGITS[buf[i += 2]];
        if (hour == -1) {
            throw InstantParser.throwDateTimeParseException("Invalid hour ", buf, offset, len, i - offset);
        }
        if ((ind = BaseJsonIterator.INT_DIGITS[buf[++i]]) == -1) {
            throw InstantParser.throwDateTimeParseException("Invalid hour ", buf, offset, len, i - offset);
        }
        hour = (hour << 3) + (hour << 1) + ind;
        int minute = BaseJsonIterator.INT_DIGITS[buf[i += 2]];
        if (minute == -1) {
            throw InstantParser.throwDateTimeParseException("Invalid minute ", buf, offset, len, i - offset);
        }
        if ((ind = BaseJsonIterator.INT_DIGITS[buf[++i]]) == -1) {
            throw InstantParser.throwDateTimeParseException("Invalid minute ", buf, offset, len, i - offset);
        }
        minute = (minute << 3) + (minute << 1) + ind;
        int second = BaseJsonIterator.INT_DIGITS[buf[i += 2]];
        if (second == -1) {
            throw InstantParser.throwDateTimeParseException("Invalid second ", buf, offset, len, i - offset);
        }
        if ((ind = BaseJsonIterator.INT_DIGITS[buf[++i]]) == -1) {
            throw InstantParser.throwDateTimeParseException("Invalid second ", buf, offset, len, i - offset);
        }
        second = (second << 3) + (second << 1) + ind;
        ZoneId zone = ZoneId.of(new String(buf, i += 2, offset + len - i));
        return ZonedDateTime.of(year, month, day, hour, minute, second, 0, zone).toInstant();
    };
    public static final CharBufferFunction<Instant> INSTANT_PARSER = (buf, offset, len) -> {
        int ind;
        if (len < 19) {
            if (len == 0) {
                return null;
            }
            throw InstantParser.throwDateTimeParseException(String.format("Invalid length, %d, expected at least 19 characters", len), buf, offset, len, 0);
        }
        int i = offset;
        char c = buf[i];
        int year = BaseJsonIterator.INT_DIGITS[c];
        if (year == -1) {
            if (c == 'S' || c == 'T' || c == 'M' || c == 'W' || c == 'F') {
                return RFC_1123_INSTANT_PARSER.apply(buf, offset, len);
            }
            throw InstantParser.throwDateTimeParseException("Invalid year ", buf, offset, len, 0);
        }
        if ((ind = BaseJsonIterator.INT_DIGITS[buf[++i]]) == -1) {
            throw InstantParser.throwDateTimeParseException("Invalid year ", buf, offset, len, i - offset);
        }
        year = (year << 3) + (year << 1) + ind;
        if ((ind = BaseJsonIterator.INT_DIGITS[buf[++i]]) == -1) {
            throw InstantParser.throwDateTimeParseException("Invalid year ", buf, offset, len, i - offset);
        }
        year = (year << 3) + (year << 1) + ind;
        if ((ind = BaseJsonIterator.INT_DIGITS[buf[++i]]) == -1) {
            throw InstantParser.throwDateTimeParseException("Invalid year ", buf, offset, len, i - offset);
        }
        year = (year << 3) + (year << 1) + ind;
        int month = BaseJsonIterator.INT_DIGITS[buf[i += 2]];
        if (month == -1) {
            throw InstantParser.throwDateTimeParseException("Invalid month ", buf, offset, len, i - offset);
        }
        if ((ind = BaseJsonIterator.INT_DIGITS[buf[++i]]) == -1) {
            throw InstantParser.throwDateTimeParseException("Invalid month ", buf, offset, len, i - offset);
        }
        month = (month << 3) + (month << 1) + ind;
        int day = BaseJsonIterator.INT_DIGITS[buf[i += 2]];
        if (day == -1) {
            throw InstantParser.throwDateTimeParseException("Invalid day ", buf, offset, len, i - offset);
        }
        if ((ind = BaseJsonIterator.INT_DIGITS[buf[++i]]) == -1) {
            throw InstantParser.throwDateTimeParseException("Invalid day ", buf, offset, len, i - offset);
        }
        day = (day << 3) + (day << 1) + ind;
        int hour = BaseJsonIterator.INT_DIGITS[buf[i += 2]];
        if (hour == -1) {
            throw InstantParser.throwDateTimeParseException("Invalid hour ", buf, offset, len, i - offset);
        }
        if ((ind = BaseJsonIterator.INT_DIGITS[buf[++i]]) == -1) {
            throw InstantParser.throwDateTimeParseException("Invalid hour ", buf, offset, len, i - offset);
        }
        hour = (hour << 3) + (hour << 1) + ind;
        int minute = BaseJsonIterator.INT_DIGITS[buf[i += 2]];
        if (minute == -1) {
            throw InstantParser.throwDateTimeParseException("Invalid minute ", buf, offset, len, i - offset);
        }
        if ((ind = BaseJsonIterator.INT_DIGITS[buf[++i]]) == -1) {
            throw InstantParser.throwDateTimeParseException("Invalid minute ", buf, offset, len, i - offset);
        }
        minute = (minute << 3) + (minute << 1) + ind;
        int second = BaseJsonIterator.INT_DIGITS[buf[i += 2]];
        if (second == -1) {
            throw InstantParser.throwDateTimeParseException("Invalid second ", buf, offset, len, i - offset);
        }
        if ((ind = BaseJsonIterator.INT_DIGITS[buf[++i]]) == -1) {
            throw InstantParser.throwDateTimeParseException("Invalid second ", buf, offset, len, i - offset);
        }
        second = (second << 3) + (second << 1) + ind;
        int max = offset + len;
        if (++i == max) {
            return Instant.ofEpochSecond(InstantParser.toEpochSecond(year, month, day, hour, minute, second), 0L);
        }
        c = buf[i];
        if (c != '.') {
            int offsetSeconds;
            if (c == 'Z') {
                offsetSeconds = 0;
            } else if (c == '-') {
                offsetSeconds = -InstantParser.parseOffset(buf, i, offset, len, max);
            } else if (c == '+') {
                offsetSeconds = InstantParser.parseOffset(buf, i, offset, len, max);
            } else {
                throw InstantParser.throwDateTimeParseException("Invalid offset ", buf, offset, len, i - offset);
            }
            return Instant.ofEpochSecond(InstantParser.toEpochSecond(year, month, day, hour, minute, second) - (long)offsetSeconds, 0L);
        }
        c = buf[++i];
        int nano = BaseJsonIterator.INT_DIGITS[c];
        if (nano == -1) {
            throw InstantParser.throwDateTimeParseException("Invalid offset ", buf, offset, len, i - offset);
        }
        int nanoDigitCount = 1;
        int offsetSeconds = 0;
        while (++i < max) {
            c = buf[i];
            ind = BaseJsonIterator.INT_DIGITS[c];
            if (ind == -1) {
                if (c == 'Z') break;
                if (c == '-') {
                    offsetSeconds = -InstantParser.parseOffset(buf, i, offset, len, max);
                    break;
                }
                if (c == '+') {
                    offsetSeconds = InstantParser.parseOffset(buf, i, offset, len, max);
                    break;
                }
                throw InstantParser.throwDateTimeParseException("Invalid offset ", buf, offset, len, i - offset);
            }
            nano = (nano << 3) + (nano << 1) + ind;
            ++nanoDigitCount;
        }
        while (nanoDigitCount++ < 9) {
            nano = (nano << 3) + (nano << 1);
        }
        return Instant.ofEpochSecond(InstantParser.toEpochSecond(year, month, day, hour, minute, second) - (long)offsetSeconds, nano);
    };

    private InstantParser() {
    }

    private static long toEpochSecond(long year, long month, int day, int hour, int minute, int second) {
        long total = 365L * year;
        total = year >= 0L ? (total += (year + 3L) / 4L - (year + 99L) / 100L + (year + 399L) / 400L) : (total -= year / -4L - year / -100L + year / -400L);
        total += (367L * month - 362L) / 12L;
        total += (long)(day - 1);
        if (month > 2L) {
            --total;
            if (!IsoChronology.INSTANCE.isLeapYear(year)) {
                --total;
            }
        }
        return 86400L * (total - 719528L) + (long)hour * 3600L + (long)minute * 60L + (long)second;
    }

    private static DateTimeParseException throwDateTimeParseException(String context, char[] buf, int begin, int len, int offset) {
        String dateTime = new String(buf, begin, len);
        throw new DateTimeParseException(context + "[" + dateTime + "]", dateTime, offset);
    }

    private static int parseOffset(char[] buf, int i, int offset, int len, int max) {
        int minuteOffset;
        int ind;
        int hourOffset;
        if ((hourOffset = BaseJsonIterator.INT_DIGITS[buf[++i]]) == -1) {
            throw InstantParser.throwDateTimeParseException("Invalid offset ", buf, offset, len, i - offset);
        }
        if ((ind = BaseJsonIterator.INT_DIGITS[buf[++i]]) == -1) {
            throw InstantParser.throwDateTimeParseException("Invalid offset ", buf, offset, len, i - offset);
        }
        hourOffset = 3600 * ((hourOffset << 3) + (hourOffset << 1) + ind);
        if (++i == max) {
            return hourOffset;
        }
        if ((minuteOffset = BaseJsonIterator.INT_DIGITS[buf[++i]]) == -1) {
            throw InstantParser.throwDateTimeParseException("Invalid offset ", buf, offset, len, i - offset);
        }
        if ((ind = BaseJsonIterator.INT_DIGITS[buf[++i]]) == -1) {
            throw InstantParser.throwDateTimeParseException("Invalid offset ", buf, offset, len, i - offset);
        }
        minuteOffset = 60 * ((minuteOffset << 3) + (minuteOffset << 1) + ind);
        return hourOffset + minuteOffset;
    }
}

