/*
 * Decompiled with CFR 0.152.
 */
package systems.comodal.jsoniter;

public final class JIUtil {
    private JIUtil() {
    }

    public static int fieldHashCode(char[] value, int from, int to) {
        int h = 0;
        while (from < to) {
            h = 31 * h + (value[from++] & 0xFF);
        }
        return h;
    }

    public static int fieldCompare(String field, char[] buf, int offset, int len) {
        int i = len - field.length();
        if (i == 0) {
            int j = offset;
            while (i < len) {
                int c = Character.compare(buf[j], field.charAt(i));
                if (c != 0) {
                    return c;
                }
                ++i;
                ++j;
            }
            return 0;
        }
        return i;
    }

    public static long compileReplacePattern(byte byteToFind) {
        long pattern = (long)byteToFind & 0xFFL;
        return pattern | pattern << 8 | pattern << 16 | pattern << 24 | pattern << 32 | pattern << 40 | pattern << 48 | pattern << 56;
    }

    public static String escapeQuotesChecked(String str) {
        int len = str.length();
        int from = 0;
        do {
            if ((from = str.indexOf(34, from)) < 0) {
                return str;
            }
            int i = from - 1;
            if (i < 0) {
                return JIUtil.escapeQuotes(str, from);
            }
            if (str.charAt(i) == '\\') {
                int escapes = 1;
                while (--i >= 0 && str.charAt(i) == '\\') {
                    ++escapes;
                }
                if (escapes & true) continue;
                return JIUtil.escapeQuotes(str, from);
            }
            return JIUtil.escapeQuotes(str, from);
        } while (++from < len);
        return str;
    }

    public static String escapeQuotes(String str) {
        return JIUtil.escapeQuotes(str, -1);
    }

    private static String escapeQuotes(String str, int firstUnescapedQuote) {
        int to;
        int from;
        char[] chars = str.toCharArray();
        char[] escaped = new char[chars.length << 1];
        if (firstUnescapedQuote < 0) {
            from = 0;
            to = 0;
        } else if (firstUnescapedQuote > 0) {
            System.arraycopy(chars, 0, escaped, 0, firstUnescapedQuote);
            escaped[firstUnescapedQuote] = 92;
            from = firstUnescapedQuote;
            to = firstUnescapedQuote + 1;
        } else {
            escaped[0] = 92;
            from = 0;
            to = 1;
        }
        int escapes = 0;
        int dest = to;
        while (true) {
            int len;
            if (to == chars.length) {
                if (from == 0) {
                    return str;
                }
                len = to - from;
                System.arraycopy(chars, from, escaped, dest, len);
                return new String(escaped, 0, dest += len);
            }
            char c = chars[to];
            if (c == '\\') {
                ++escapes;
            } else if (c == '\"' && (escapes & 1) == 0) {
                len = to - from;
                System.arraycopy(chars, from, escaped, dest, len);
                dest += len;
                escaped[dest++] = 92;
                from = to;
                escapes = 0;
            } else {
                escapes = 0;
            }
            ++to;
        }
    }

    private static String escapeOddBackslashGroups(String str) {
        return JIUtil.escapeOddBackslashGroups(str, '\\');
    }

    private static String escapeOddBackslashGroups(String str, char c) {
        int numEscaped;
        char[] buffer;
        int numChars;
        block9: {
            if (str == null) {
                return null;
            }
            int index = str.indexOf(c);
            if (index < 0) {
                return str;
            }
            numChars = str.length();
            buffer = new char[(numChars << 1) - index];
            numEscaped = 0;
            int from = 0;
            do {
                int numEscapes = 0;
                do {
                    ++numEscapes;
                } while (++index < numChars && str.charAt(index) == c);
                if ((numEscapes & 1) == 1) {
                    str.getChars(from, from + (index - from), buffer, from + numEscaped);
                    buffer[index + numEscaped] = c;
                    ++numEscaped;
                    if (index != numChars) {
                        from = index;
                        continue;
                    }
                } else {
                    if (index != numChars) continue;
                    str.getChars(from, from + (numChars - from), buffer, from + numEscaped);
                }
                break block9;
            } while ((index = str.indexOf(c, index + 1)) >= 0);
            if (numEscaped > 0) {
                str.getChars(from, from + (numChars - from), buffer, from + numEscaped);
            } else {
                return str;
            }
        }
        return new String(buffer, 0, numChars + numEscaped);
    }
}

