/*
 * Decompiled with CFR 0.152.
 */
package systems.comodal.jsoniter.factory;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import systems.comodal.jsoniter.CharBufferFunction;
import systems.comodal.jsoniter.FieldBufferPredicate;
import systems.comodal.jsoniter.JsonIterator;
import systems.comodal.jsoniter.ValueType;

public interface ElementFactory<T>
extends FieldBufferPredicate {
    public static <T> List<T> parseList(JsonIterator ji, Supplier<? extends ElementFactory<T>> objectParserSupplier) {
        if (ji.readArray()) {
            ArrayList<T> list = new ArrayList<T>();
            do {
                ElementFactory<T> parser = objectParserSupplier.get();
                ji.testObject(parser);
                list.add(parser.create());
            } while (ji.readArray());
            return list;
        }
        return List.of();
    }

    public static <T> List<T> parseList(JsonIterator ji, Supplier<? extends ElementFactory<T>> objectParserSupplier, CharBufferFunction<T> stringParser) {
        if (ji.readArray()) {
            ArrayList<T> list = new ArrayList<T>();
            do {
                if (ji.whatIsNext() == ValueType.OBJECT) {
                    ElementFactory<T> parser = objectParserSupplier.get();
                    ji.testObject(parser);
                    list.add(parser.create());
                    continue;
                }
                list.add(ji.applyChars(stringParser));
            } while (ji.readArray());
            return list;
        }
        return List.of();
    }

    public T create();
}

