/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.accounts;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.EdECPoint;
import java.security.spec.EdECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.NamedParameterSpec;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.crypto.signers.Ed25519Signer;
import software.sava.core.accounts.AccountWithSeed;
import software.sava.core.accounts.AccountWithSeedRecord;
import software.sava.core.accounts.ProgramDerivedAddress;
import software.sava.core.accounts.PublicKeyBytes;
import software.sava.core.crypto.Hash;
import software.sava.core.crypto.SunCrypto;
import software.sava.core.crypto.ed25519.Ed25519Util;
import software.sava.core.encoding.Base58;
import software.sava.core.encoding.ByteUtil;

public interface PublicKey
extends Comparable<PublicKey> {
    public static final int PUBLIC_KEY_LENGTH = 32;
    public static final int MAX_SEED_LENGTH = 32;
    public static final int MAX_SEEDS = 16;
    public static final PublicKey NONE = new PublicKeyBytes(new byte[32]);

    public static boolean verifySignature(java.security.PublicKey publicKey, byte[] msg, int msgOffset, int msgLength, byte[] signature) {
        try {
            Signature sigAlgo = Signature.getInstance("Ed25519");
            sigAlgo.initVerify(publicKey);
            sigAlgo.update(msg, msgOffset, msgLength);
            return sigAlgo.verify(signature);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean verifySignature(java.security.PublicKey publicKey, byte[] msg, byte[] signature) {
        return PublicKey.verifySignature(publicKey, msg, 0, msg.length, signature);
    }

    public static boolean verifySignature(java.security.PublicKey publicKey, String msg, byte[] signature) {
        return PublicKey.verifySignature(publicKey, msg.getBytes(), signature);
    }

    public static java.security.PublicKey toJavaPublicKey(byte[] publicKey, int off, int len) {
        byte[] reversed = ByteUtil.reverse(publicKey, off, len);
        int last = reversed[0] & 0xFF;
        boolean xOdd = (last & 0x80) == 128;
        reversed[0] = (byte)(last & 0x7F);
        BigInteger y = new BigInteger(reversed);
        EdECPoint edECPoint = new EdECPoint(xOdd, y);
        EdECPublicKeySpec pubSpec = new EdECPublicKeySpec(NamedParameterSpec.ED25519, edECPoint);
        try {
            return SunCrypto.ED_25519_KEY_FACTORY.generatePublic(pubSpec);
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }

    public static java.security.PublicKey toJavaPublicKey(byte[] publicKey) {
        return PublicKey.toJavaPublicKey(publicKey, 0, 32);
    }

    private static boolean verifySignature(Ed25519PublicKeyParameters publicKeyParameters, byte[] msg, int msgOffset, int msgLength, byte[] signature) {
        Ed25519Signer verifier = new Ed25519Signer();
        verifier.init(false, (CipherParameters)publicKeyParameters);
        verifier.update(msg, msgOffset, msgLength);
        return verifier.verifySignature(signature);
    }

    private static boolean verifySignature(Ed25519PublicKeyParameters publicKeyParameters, byte[] msg, byte[] signature) {
        return PublicKey.verifySignature(publicKeyParameters, msg, 0, msg.length, signature);
    }

    private static boolean verifySignature(Ed25519PublicKeyParameters publicKeyParameters, String msg, byte[] signature) {
        return PublicKey.verifySignature(publicKeyParameters, msg.getBytes(), signature);
    }

    public static boolean verifySignature(byte[] publicKey, int publicKeyOffset, byte[] msg, int msgOffset, int msgLength, byte[] signature) {
        Ed25519PublicKeyParameters publicKeyParameters = new Ed25519PublicKeyParameters(publicKey, publicKeyOffset);
        return PublicKey.verifySignature(publicKeyParameters, msg, msgOffset, msgLength, signature);
    }

    public static boolean verifySignature(byte[] publicKey, int publicKeyOffset, String msg, byte[] signature) {
        return PublicKey.verifySignature(publicKey, publicKeyOffset, msg.getBytes(), 0, msg.length(), signature);
    }

    public static boolean verifySignature(byte[] publicKey, String msg, byte[] signature) {
        return PublicKey.verifySignature(publicKey, 0, msg.getBytes(), 0, msg.length(), signature);
    }

    public static boolean verifySignature(byte[] publicKey, String msg, String signature) {
        return PublicKey.verifySignature(publicKey, 0, msg, signature.getBytes());
    }

    public static PublicKey readPubKey(byte[] bytes, int offset) {
        return new PublicKeyBytes(Arrays.copyOfRange(bytes, offset, offset + 32));
    }

    public static PublicKey readPubKey(byte[] bytes) {
        return PublicKey.readPubKey(bytes, 0);
    }

    public static PublicKey createPubKey(byte[] publicKey) {
        if (publicKey.length != 32) {
            throw new IllegalArgumentException("Invalid public key input");
        }
        return new PublicKeyBytes(publicKey);
    }

    public static PublicKey fromBase58Encoded(String base58) {
        byte[] publicKey = Base58.decode(base58);
        return PublicKey.createPubKey(publicKey);
    }

    public static PublicKey fromBase58Encoded(char[] base58) {
        return PublicKey.fromBase58Encoded(base58, 0, base58.length);
    }

    public static PublicKey fromBase58Encoded(char[] base58, int from, int len) {
        byte[] publicKey = Base58.decode(base58, from, len);
        return PublicKey.createPubKey(publicKey);
    }

    public static PublicKey fromBase64Encoded(String base64) {
        byte[] publicKey = Base64.getDecoder().decode(base64);
        return PublicKey.createPubKey(publicKey);
    }

    public int write(byte[] var1, int var2);

    public static PublicKey createProgramAddress(List<byte[]> seeds, PublicKey programId) {
        byte[] buffer = PublicKeyBytes.createBuffer(seeds, false, programId);
        byte[] hash = Hash.sha256(buffer);
        return Ed25519Util.isNotOnCurve(hash) ? PublicKey.createPubKey(hash) : null;
    }

    public static ProgramDerivedAddress findProgramAddress(List<byte[]> seeds, PublicKey programId) {
        byte[] buffer = PublicKeyBytes.createBuffer(seeds, true, programId);
        int nonceOffset = buffer.length - (33 + PublicKeyBytes.PDA_BYTES.length);
        MessageDigest sha256 = Hash.sha256Digest();
        for (int nonce = 255; nonce >= 0; --nonce) {
            buffer[nonceOffset] = (byte)nonce;
            byte[] hash = sha256.digest(buffer);
            if (!Ed25519Util.isNotOnCurve(hash)) continue;
            return ProgramDerivedAddress.createPDA(seeds, PublicKey.createPubKey(hash), nonce);
        }
        throw new RuntimeException("Unable to find a viable program derived address nonce");
    }

    public static AccountWithSeed createOffCurveAccountWithAsciiSeed(PublicKey base, String baseSeed, PublicKey programId) {
        byte[] baseSeedBytes = baseSeed.getBytes(StandardCharsets.US_ASCII);
        if (baseSeedBytes.length > 32) {
            throw new IllegalArgumentException(String.format("Seed [%s] exceeds maximum length of [%d].", baseSeed, 32));
        }
        byte[] buffer = new byte[32 + baseSeedBytes.length + 1 + 32];
        base.write(buffer, 0);
        System.arraycopy(baseSeedBytes, 0, buffer, 32, baseSeedBytes.length);
        programId.write(buffer, buffer.length - 32);
        int nonceOffset = 32 + baseSeedBytes.length;
        MessageDigest sha256 = Hash.sha256Digest();
        for (int nonce = 127; nonce >= 0; --nonce) {
            buffer[nonceOffset] = (byte)nonce;
            byte[] hash = sha256.digest(buffer);
            if (!Ed25519Util.isNotOnCurve(hash)) continue;
            byte[] bumpSeedBytes = Arrays.copyOfRange(buffer, 32, 32 + baseSeedBytes.length + 1);
            return new AccountWithSeedRecord(base, PublicKey.createPubKey(hash), bumpSeedBytes, programId);
        }
        throw new RuntimeException("Unable to find a viable program derived address nonce");
    }

    public static PublicKey createWithSeed(PublicKey base, String seed, PublicKey programId) {
        byte[] seedBytes = seed.getBytes(StandardCharsets.US_ASCII);
        if (seedBytes.length > 32) {
            throw new IllegalArgumentException(String.format("Seed [%s] exceeds maximum length of [%d].", seed, 32));
        }
        MessageDigest digest = Hash.sha256Digest();
        digest.update(base.toByteArray());
        digest.update(seedBytes);
        digest.update(programId.toByteArray());
        return PublicKey.createPubKey(digest.digest());
    }

    public byte[] toByteArray();

    public byte[] copyByteArray();

    public String toBase58();

    public String toBase64();

    default public int l() {
        return 32;
    }

    default public boolean verifySignature(byte[] msg, int msgOffset, int msgLength, byte[] signature) {
        return PublicKey.verifySignature(this.toByteArray(), 0, msg, msgOffset, msgLength, signature);
    }

    default public boolean verifySignature(byte[] msg, byte[] signature) {
        return PublicKey.verifySignature(this.toByteArray(), 0, msg, 0, msg.length, signature);
    }

    default public boolean verifySignature(String msg, byte[] signature) {
        return PublicKey.verifySignature(this.toByteArray(), msg, signature);
    }

    default public boolean verifySignature(String msg, String signature) {
        return this.verifySignature(msg, signature.getBytes());
    }

    default public java.security.PublicKey toJavaPublicKey() {
        return PublicKey.toJavaPublicKey(this.toByteArray());
    }
}

