/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.accounts;

import software.sava.core.accounts.PublicKey;
import software.sava.core.accounts.SolanaAccountsRecord;
import software.sava.core.accounts.meta.AccountMeta;

public interface SolanaAccounts {
    public static final SolanaAccounts MAIN_NET = SolanaAccounts.createAddressConstants("11111111111111111111111111111111", "Config1111111111111111111111111111111111111", "Stake11111111111111111111111111111111111111", "StakeConfig11111111111111111111111111111111", "Vote111111111111111111111111111111111111111", "AddressLookupTab1e1111111111111111111111111", "BPFLoaderUpgradeab1e11111111111111111111111", "Ed25519SigVerify111111111111111111111111111", "KeccakSecp256k11111111111111111111111111111", "ZkTokenProof1111111111111111111111111111111", "ZkE1Gama1Proof11111111111111111111111111111", "So11111111111111111111111111111111111111112", "ComputeBudget111111111111111111111111111111", "TokenkegQfeZyiNwAJbNbGKPFXCWuBvf9Ss623VQ5DA", "ATokenGPvbdGVxr1b2hvZbsiqW5xWH25efTNsLJA8knL", "TokenzQdBNbLqP5VEhdkAS6EPFLC1PHnBqCXEpPxuEb", "TkupDoNseygccBCjSsrSpMccjwHfTYwcrjpnDSrFDhC", "Memo1UhkJRfHyvLMcVucJwxXeuD728EqVDDwQDxFMNo", "MemoSq4gqABAXKb96qnH8TysNcWxMyWCqXgDLGmfcHr", "namesLPneVptA9Z5rqUDD9tMTWEJwofgaYwp8cawRkX", "shmem4EWT2sPdVGvTZCzXXRAURL9G5vpPxNwSeKhHUL", "Feat1YXHhH6t1juaWF74WLcfv4XoNocjXA6sPWHNgAse", "SysvarC1ock11111111111111111111111111111111", "SysvarEpochSchedu1e111111111111111111111111", "SysvarFees111111111111111111111111111111111", "Sysvar1nstructions1111111111111111111111111", "SysvarRecentB1ockHashes11111111111111111111", "SysvarRent111111111111111111111111111111111", "SysvarS1otHashes111111111111111111111111111", "SysvarS1otHistory11111111111111111111111111", "SysvarStakeHistory1111111111111111111111111", "SysvarEpochRewards1111111111111111111111111", "SysvarLastRestartS1ot1111111111111111111111");

    public static SolanaAccounts createAddressConstants(PublicKey systemProgram, PublicKey configProgram, PublicKey stakeProgram, PublicKey stakeConfig, PublicKey voteProgram, PublicKey addressLookupTableProgram, PublicKey bPFLoaderProgram, PublicKey systemEd25519Program, PublicKey secp256k1Program, PublicKey zKTokenProofProgram, PublicKey zkElGamalProofProgram, PublicKey wrappedSolTokenMint, PublicKey computeBudgetProgram, PublicKey tokenProgram, PublicKey associatedTokenAccountProgram, PublicKey token2022Program, PublicKey tokenUpgradeProgram, PublicKey memoProgram, PublicKey memoProgramV2, PublicKey nameServiceProgram, PublicKey sharedMemoryProgram, PublicKey featureProposalProgram, PublicKey clockSysVar, PublicKey epochScheduleSysVar, PublicKey feesSysVar, PublicKey instructionsSysVar, PublicKey recentBlockhashesSysVar, PublicKey rentSysVar, PublicKey slotHashesSysVar, PublicKey slotHistorySysVar, PublicKey stakeHistorySysVar, PublicKey epochRewardsSysVar, PublicKey lastRestartSlotSysVar) {
        return new SolanaAccountsRecord(systemProgram, AccountMeta.createInvoked(systemProgram), AccountMeta.createRead(systemProgram), configProgram, AccountMeta.createInvoked(configProgram), AccountMeta.createRead(configProgram), stakeProgram, AccountMeta.createInvoked(stakeProgram), AccountMeta.createRead(stakeProgram), stakeConfig, AccountMeta.createRead(stakeConfig), voteProgram, AccountMeta.createInvoked(voteProgram), AccountMeta.createRead(voteProgram), addressLookupTableProgram, AccountMeta.createInvoked(addressLookupTableProgram), AccountMeta.createRead(addressLookupTableProgram), bPFLoaderProgram, AccountMeta.createInvoked(bPFLoaderProgram), AccountMeta.createRead(bPFLoaderProgram), systemEd25519Program, AccountMeta.createInvoked(systemEd25519Program), AccountMeta.createRead(systemEd25519Program), secp256k1Program, AccountMeta.createInvoked(secp256k1Program), AccountMeta.createRead(secp256k1Program), zKTokenProofProgram, AccountMeta.createInvoked(zKTokenProofProgram), AccountMeta.createRead(zKTokenProofProgram), zkElGamalProofProgram, AccountMeta.createInvoked(zkElGamalProofProgram), AccountMeta.createRead(zkElGamalProofProgram), wrappedSolTokenMint, AccountMeta.createRead(wrappedSolTokenMint), computeBudgetProgram, AccountMeta.createInvoked(computeBudgetProgram), tokenProgram, AccountMeta.createInvoked(tokenProgram), AccountMeta.createRead(tokenProgram), associatedTokenAccountProgram, AccountMeta.createInvoked(associatedTokenAccountProgram), AccountMeta.createRead(associatedTokenAccountProgram), token2022Program, AccountMeta.createInvoked(token2022Program), AccountMeta.createRead(token2022Program), tokenUpgradeProgram, AccountMeta.createInvoked(tokenUpgradeProgram), AccountMeta.createRead(tokenUpgradeProgram), memoProgram, AccountMeta.createInvoked(memoProgram), AccountMeta.createRead(memoProgram), AccountMeta.createInvoked(memoProgramV2), AccountMeta.createRead(memoProgramV2), nameServiceProgram, AccountMeta.createInvoked(nameServiceProgram), AccountMeta.createRead(nameServiceProgram), sharedMemoryProgram, AccountMeta.createInvoked(sharedMemoryProgram), AccountMeta.createRead(sharedMemoryProgram), featureProposalProgram, AccountMeta.createInvoked(featureProposalProgram), AccountMeta.createRead(featureProposalProgram), clockSysVar, AccountMeta.createRead(clockSysVar), epochScheduleSysVar, AccountMeta.createRead(epochScheduleSysVar), feesSysVar, AccountMeta.createRead(feesSysVar), instructionsSysVar, AccountMeta.createRead(instructionsSysVar), recentBlockhashesSysVar, AccountMeta.createRead(recentBlockhashesSysVar), rentSysVar, AccountMeta.createRead(rentSysVar), slotHashesSysVar, AccountMeta.createRead(slotHashesSysVar), slotHistorySysVar, AccountMeta.createRead(slotHistorySysVar), stakeHistorySysVar, AccountMeta.createRead(stakeHistorySysVar), epochRewardsSysVar, AccountMeta.createRead(epochRewardsSysVar), lastRestartSlotSysVar, AccountMeta.createRead(lastRestartSlotSysVar));
    }

    public static SolanaAccounts createAddressConstants(String systemProgram, String configProgram, String stakeProgram, String stakeConfig, String voteProgram, String addressLookupTableProgram, String bPFLoaderProgram, String systemEd25519Program, String secp256k1Program, String zKTokenProofProgram, String zkElGamalProofProgram, String wrappedSolTokenMint, String computeBudgetProgram, String tokenProgram, String associatedTokenAccountProgram, String token2022Program, String tokenUpgradeProgram, String memoProgram, String memoProgramV2, String nameServiceProgram, String sharedMemoryProgram, String featureProposalProgram, String clockSysVar, String epochScheduleSysVar, String feesSysVar, String instructionsSysVar, String recentBlockhashesSysVar, String rentSysVar, String slotHashesSysVar, String slotHistorySysVar, String stakeHistorySysVar, String epochRewardsSysVar, String lastRestartSlotSysVar) {
        return SolanaAccounts.createAddressConstants(PublicKey.fromBase58Encoded(systemProgram), PublicKey.fromBase58Encoded(configProgram), PublicKey.fromBase58Encoded(stakeProgram), PublicKey.fromBase58Encoded(stakeConfig), PublicKey.fromBase58Encoded(voteProgram), PublicKey.fromBase58Encoded(addressLookupTableProgram), PublicKey.fromBase58Encoded(bPFLoaderProgram), PublicKey.fromBase58Encoded(systemEd25519Program), PublicKey.fromBase58Encoded(secp256k1Program), PublicKey.fromBase58Encoded(zKTokenProofProgram), PublicKey.fromBase58Encoded(zkElGamalProofProgram), PublicKey.fromBase58Encoded(wrappedSolTokenMint), PublicKey.fromBase58Encoded(computeBudgetProgram), PublicKey.fromBase58Encoded(tokenProgram), PublicKey.fromBase58Encoded(associatedTokenAccountProgram), PublicKey.fromBase58Encoded(token2022Program), PublicKey.fromBase58Encoded(tokenUpgradeProgram), PublicKey.fromBase58Encoded(memoProgram), PublicKey.fromBase58Encoded(memoProgramV2), PublicKey.fromBase58Encoded(nameServiceProgram), PublicKey.fromBase58Encoded(sharedMemoryProgram), PublicKey.fromBase58Encoded(featureProposalProgram), PublicKey.fromBase58Encoded(clockSysVar), PublicKey.fromBase58Encoded(epochScheduleSysVar), PublicKey.fromBase58Encoded(feesSysVar), PublicKey.fromBase58Encoded(instructionsSysVar), PublicKey.fromBase58Encoded(recentBlockhashesSysVar), PublicKey.fromBase58Encoded(rentSysVar), PublicKey.fromBase58Encoded(slotHashesSysVar), PublicKey.fromBase58Encoded(slotHistorySysVar), PublicKey.fromBase58Encoded(stakeHistorySysVar), PublicKey.fromBase58Encoded(epochRewardsSysVar), PublicKey.fromBase58Encoded(lastRestartSlotSysVar));
    }

    public PublicKey wrappedSolTokenMint();

    public AccountMeta readWrappedSolTokenMint();

    public PublicKey computeBudgetProgram();

    public AccountMeta invokedComputeBudgetProgram();

    public PublicKey tokenProgram();

    public AccountMeta invokedTokenProgram();

    public AccountMeta readTokenProgram();

    public PublicKey associatedTokenAccountProgram();

    public AccountMeta invokedAssociatedTokenAccountProgram();

    public AccountMeta readAssociatedTokenAccountProgram();

    public PublicKey token2022Program();

    public AccountMeta invokedToken2022Program();

    public AccountMeta readToken2022Program();

    public PublicKey tokenUpgradeProgram();

    public AccountMeta invokedTokenUpgradeProgram();

    public AccountMeta readTokenUpgradeProgram();

    public PublicKey memoProgram();

    public AccountMeta invokedMemoProgram();

    public AccountMeta invokedMemoProgramV2();

    public AccountMeta readMemoProgramV2();

    public AccountMeta readMemoProgram();

    public PublicKey nameServiceProgram();

    public AccountMeta invokedNameServiceProgram();

    public AccountMeta readNameServiceProgram();

    public PublicKey sharedMemoryProgram();

    public AccountMeta invokedSharedMemoryProgram();

    public AccountMeta readSharedMemoryProgram();

    public PublicKey featureProposalProgram();

    public AccountMeta invokedFeatureProposalProgram();

    public AccountMeta readFeatureProposalProgram();

    public PublicKey systemProgram();

    public AccountMeta invokedSystemProgram();

    public AccountMeta readSystemProgram();

    public PublicKey configProgram();

    public AccountMeta invokedConfigProgram();

    public AccountMeta readConfigProgram();

    public PublicKey stakeProgram();

    public AccountMeta invokedStakeProgram();

    public PublicKey stakeConfig();

    public AccountMeta readStakeConfig();

    public AccountMeta readStakeProgram();

    public PublicKey voteProgram();

    public AccountMeta invokedVoteProgram();

    public AccountMeta readVoteProgram();

    public PublicKey addressLookupTableProgram();

    public AccountMeta invokedAddressLookupTableProgram();

    public AccountMeta readAddressLookupTableProgram();

    public PublicKey bPFLoaderProgram();

    public AccountMeta invokedBPFLoaderProgram();

    public AccountMeta readBPFLoaderProgram();

    public PublicKey ed25519Program();

    public AccountMeta invokedEd25519Program();

    public AccountMeta readEd25519Program();

    public PublicKey secp256k1Program();

    public AccountMeta invokedSecp256k1Program();

    public AccountMeta readSecp256k1Program();

    public PublicKey zKTokenProofProgram();

    public AccountMeta invokedZKTokenProofProgram();

    public AccountMeta readZKTokenProofProgram();

    public PublicKey zkElGamalProofProgram();

    public AccountMeta invokedZkElGamalProofProgram();

    public AccountMeta readZkElGamalProofProgram();

    public PublicKey clockSysVar();

    public AccountMeta readClockSysVar();

    public PublicKey epochScheduleSysVar();

    public AccountMeta readEpochScheduleSysVar();

    public PublicKey feesSysVar();

    public AccountMeta readFeesSysVar();

    public PublicKey instructionsSysVar();

    public AccountMeta readInstructionsSysVar();

    public PublicKey recentBlockhashesSysVar();

    public AccountMeta readRecentBlockhashesSysVar();

    public PublicKey rentSysVar();

    public AccountMeta readRentSysVar();

    public PublicKey slotHashesSysVar();

    public AccountMeta readSlotHashesSysVar();

    public PublicKey slotHistorySysVar();

    public AccountMeta readSlotHistorySysVar();

    public PublicKey stakeHistorySysVar();

    public AccountMeta readStakeHistorySysVar();

    public PublicKey epochRewardsSysVar();

    public AccountMeta readEpochRewardsSysVar();

    public PublicKey lastRestartSlotSysVar();

    public AccountMeta readLastRestartSlotSysVar();
}

