/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.accounts.lookup;

import java.util.Arrays;
import java.util.Base64;
import java.util.Map;
import software.sava.core.accounts.PublicKey;
import software.sava.core.encoding.Base58;

public record AccountIndexLookupTableEntry(byte[] publicKey, int index) implements PublicKey
{
    private static final Integer NOT_PRESENT = Integer.MIN_VALUE;

    public static int lookupAccountIndex(AccountIndexLookupTableEntry[] lookupTable, PublicKey publicKey) {
        int index = Arrays.binarySearch(lookupTable, publicKey);
        if (index < 0) {
            return Integer.MIN_VALUE;
        }
        return lookupTable[index].index;
    }

    public static byte lookupAccountIndexOrThrow(AccountIndexLookupTableEntry[] lookupTable, PublicKey publicKey) {
        int index = Arrays.binarySearch(lookupTable, publicKey);
        if (index < 0) {
            throw new IllegalStateException(String.format("Could not find %s in lookup table.", publicKey.toBase58()));
        }
        return (byte)lookupTable[index].index;
    }

    public static int indexOf(Map<PublicKey, Integer> accountMap, PublicKey publicKey) {
        int index = accountMap.getOrDefault(publicKey, NOT_PRESENT);
        if (index < 0) {
            return Integer.MIN_VALUE;
        }
        return index;
    }

    public static byte indexOfOrThrow(Map<PublicKey, Integer> accountMap, PublicKey publicKey) {
        int index = accountMap.getOrDefault(publicKey, NOT_PRESENT);
        if (index < 0) {
            throw new IllegalStateException(String.format("Could not find %s in lookup table.", publicKey.toBase58()));
        }
        return (byte)index;
    }

    @Override
    public byte[] toByteArray() {
        return this.publicKey;
    }

    @Override
    public byte[] copyByteArray() {
        return Arrays.copyOf(this.publicKey, this.publicKey.length);
    }

    @Override
    public int compareTo(PublicKey o) {
        return Arrays.compare(this.publicKey, o.toByteArray());
    }

    @Override
    public int write(byte[] out, int off) {
        System.arraycopy(this.publicKey, 0, out, off, 32);
        return 32;
    }

    @Override
    public String toBase58() {
        return Base58.encode(this.publicKey);
    }

    @Override
    public String toBase64() {
        return Base64.getEncoder().encodeToString(this.publicKey);
    }

    @Override
    public String toString() {
        return String.format("AccountIndexLookupTableEntry[publicKey=[%s, index=%d]", Base58.encode(this.publicKey), this.index);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof PublicKey) {
            PublicKey _publicKey = (PublicKey)o;
            return Arrays.equals(this.publicKey, _publicKey.toByteArray());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.publicKey);
    }
}

