/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.accounts.lookup;

import java.util.Arrays;
import java.util.Base64;
import software.sava.core.accounts.PublicKey;
import software.sava.core.encoding.Base58;

public record AccountIndexLookupTableView(byte[] lookupTable, int offset, int index) implements PublicKey
{
    @Override
    public byte[] toByteArray() {
        return Arrays.copyOfRange(this.lookupTable, this.offset, this.offset + 32);
    }

    @Override
    public byte[] copyByteArray() {
        return this.toByteArray();
    }

    @Override
    public int compareTo(PublicKey o) {
        if (o instanceof AccountIndexLookupTableView) {
            AccountIndexLookupTableView view = (AccountIndexLookupTableView)o;
            return Arrays.compare(this.lookupTable, this.offset, this.offset + 32, this.lookupTable, view.offset, view.offset + 32);
        }
        return Arrays.compare(this.lookupTable, this.offset, this.offset + 32, o.toByteArray(), 0, 32);
    }

    @Override
    public int write(byte[] out, int off) {
        System.arraycopy(this.lookupTable, this.offset, out, off, 32);
        return 32;
    }

    @Override
    public String toBase58() {
        return Base58.encode(this.lookupTable, this.offset, this.offset + 32);
    }

    @Override
    public String toBase64() {
        return Base64.getEncoder().encodeToString(this.toByteArray());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof PublicKey) {
            PublicKey _publicKey = (PublicKey)o;
            return Arrays.equals(this.lookupTable, this.offset, this.offset + 32, _publicKey.toByteArray(), 0, 32);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.toByteArray());
    }
}

