/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.accounts.lookup;

import java.util.HashMap;
import java.util.Set;
import java.util.function.BiFunction;
import software.sava.core.accounts.PublicKey;
import software.sava.core.accounts.lookup.AddressLookupTableOverlay;
import software.sava.core.accounts.lookup.AddressLookupTableRoot;
import software.sava.core.accounts.lookup.AddressLookupTableWithReverseLookup;
import software.sava.core.encoding.ByteUtil;
import software.sava.core.rpc.Filter;

public interface AddressLookupTable {
    public static final int LOOKUP_TABLE_MAX_ADDRESSES = 256;
    public static final int LOOKUP_TABLE_META_SIZE = 56;
    public static final int DISCRIMINATOR_OFFSET = 0;
    public static final int DEACTIVATION_SLOT_OFFSET = 4;
    public static final int LAST_EXTENDED_OFFSET = 12;
    public static final int LAST_EXTENDED_SLOT_START_INDEX_OFFSET = 20;
    public static final int AUTHORITY_OPTION_OFFSET = 21;
    public static final int AUTHORITY_OFFSET = 22;
    public static final BiFunction<PublicKey, byte[], AddressLookupTable> FACTORY = AddressLookupTable::read;

    public static Filter activeFilter() {
        return AddressLookupTableRoot.ACTIVE_FILTER;
    }

    public static Filter authorityFilter(PublicKey authority) {
        return Filter.createMemCompFilter(22, authority);
    }

    public static AddressLookupTable read(PublicKey address, byte[] data) {
        if (data == null || data.length == 0) {
            return null;
        }
        byte[] discriminator = new byte[4];
        System.arraycopy(data, 0, discriminator, 0, 4);
        long deactivationSlot = ByteUtil.getInt64LE(data, 4);
        long lastExtendedSlot = ByteUtil.getInt64LE(data, 12);
        int lastExtendedSlotStartIndex = data[20] & 0xFF;
        PublicKey authority = data[21] == 0 ? null : PublicKey.readPubKey(data, 22);
        int numAccounts = data.length - 56 >> 5;
        PublicKey[] accounts = new PublicKey[numAccounts];
        HashMap<PublicKey, Integer> distinctAccounts = HashMap.newHashMap(numAccounts);
        int i = 0;
        int o = 56;
        while (i < numAccounts) {
            PublicKey pubKey = PublicKey.readPubKey(data, o);
            distinctAccounts.putIfAbsent(pubKey, i);
            accounts[i] = pubKey;
            ++i;
            o += 32;
        }
        return new AddressLookupTableWithReverseLookup(address, discriminator, deactivationSlot, lastExtendedSlot, lastExtendedSlotStartIndex, authority, distinctAccounts, accounts, data);
    }

    public static AddressLookupTable readWithoutReverseLookup(PublicKey address, byte[] data) {
        if (data == null || data.length == 0) {
            return null;
        }
        return new AddressLookupTableOverlay(address, data);
    }

    public AddressLookupTable withReverseLookup();

    default public boolean isActive() {
        return this.deactivationSlot() == -1L;
    }

    public PublicKey account(int var1);

    public int indexOf(PublicKey var1);

    default public boolean containKey(PublicKey publicKey) {
        return this.indexOf(publicKey) >= 0;
    }

    public byte indexOfOrThrow(PublicKey var1);

    public PublicKey address();

    public byte[] discriminator();

    public long deactivationSlot();

    public long lastExtendedSlot();

    public int lastExtendedSlotStartIndex();

    public PublicKey authority();

    public int numAccounts();

    public int numUniqueAccounts();

    public int write(byte[] var1, int var2);

    public byte[] data();

    public int length();

    public Set<PublicKey> uniqueAccounts();
}

