/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.accounts.lookup;

import software.sava.core.accounts.PublicKey;
import software.sava.core.accounts.lookup.AddressLookupTable;
import software.sava.core.encoding.ByteUtil;
import software.sava.core.rpc.Filter;

abstract class AddressLookupTableRoot
implements AddressLookupTable {
    static final Filter ACTIVE_FILTER;
    protected final PublicKey address;
    protected final byte[] data;

    AddressLookupTableRoot(PublicKey address, byte[] data) {
        this.address = address;
        this.data = data;
    }

    @Override
    public final int write(byte[] out, int offset) {
        System.arraycopy(this.data, 0, out, offset, this.data.length);
        return this.data.length;
    }

    @Override
    public final byte[] data() {
        return this.data;
    }

    @Override
    public final int length() {
        return this.data.length;
    }

    @Override
    public final PublicKey address() {
        return this.address;
    }

    protected abstract String keysToString();

    public final String toString() {
        return String.format("{\n  \"address\": \"%s\",\n  \"deactivationSlot\": %s,\n  \"lastExtendedSlot\": %s,\n  \"lastExtendedSlotStartIndex\": %d,\n  \"authority\": \"%s\",\n  \"accounts\": \"%s\"\n}", this.address, Long.toUnsignedString(this.deactivationSlot()), Long.toUnsignedString(this.lastExtendedSlot()), this.lastExtendedSlotStartIndex(), this.authority(), this.keysToString());
    }

    static {
        byte[] notDeActivated = new byte[8];
        ByteUtil.putInt64LE(notDeActivated, 0, -1L);
        ACTIVE_FILTER = Filter.createMemCompFilter(4, notDeActivated);
    }
}

