/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.accounts.meta;

import software.sava.core.accounts.PublicKey;
import software.sava.core.accounts.meta.AccountMeta;
import software.sava.core.accounts.meta.AccountMetaReadOnly;
import software.sava.core.accounts.meta.AccountMetaSignerWriter;

final class AccountMetaReadOnlySigner
extends AccountMetaReadOnly {
    AccountMetaReadOnlySigner(PublicKey publicKey) {
        super(publicKey);
    }

    @Override
    public boolean signer() {
        return true;
    }

    @Override
    public AccountMeta merge(AccountMeta accountMeta) {
        if (accountMeta.feePayer()) {
            return accountMeta;
        }
        return accountMeta.write() ? (accountMeta.signer() ? accountMeta : new AccountMetaSignerWriter(this.publicKey)) : this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof AccountMetaReadOnlySigner)) return false;
        AccountMetaReadOnlySigner account = (AccountMetaReadOnlySigner)o;
        if (!this.publicKey.equals(account.publicKey)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + 1;
        result = 31 * result;
        result = 31 * result;
        return result;
    }
}

