/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.accounts.meta;

import software.sava.core.accounts.PublicKey;
import software.sava.core.accounts.meta.AccountMeta;
import software.sava.core.accounts.meta.AccountMetaReadOnly;
import software.sava.core.accounts.meta.AccountMetaSignerWriter;

final class AccountMetaWrite
extends AccountMetaReadOnly {
    AccountMetaWrite(PublicKey publicKey) {
        super(publicKey);
    }

    @Override
    public boolean write() {
        return true;
    }

    @Override
    public AccountMeta merge(AccountMeta accountMeta) {
        if (accountMeta.feePayer()) {
            return accountMeta;
        }
        if (accountMeta.signer()) {
            return accountMeta.write() ? accountMeta : new AccountMetaSignerWriter(this.publicKey);
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof AccountMetaWrite)) return false;
        AccountMetaWrite account = (AccountMetaWrite)o;
        if (!this.publicKey.equals(account.publicKey)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result;
        result = 31 * result + 1;
        result = 31 * result;
        return result;
    }
}

