/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.accounts.meta;

import java.util.Collection;
import java.util.Map;
import software.sava.core.accounts.PublicKey;
import software.sava.core.accounts.lookup.AccountIndexLookupTableEntry;
import software.sava.core.accounts.lookup.AddressLookupTable;
import software.sava.core.accounts.meta.AccountMeta;
import software.sava.core.accounts.meta.TableAccountMeta;

public interface LookupTableAccountMeta {
    public static LookupTableAccountMeta createMeta(AddressLookupTable lookupTable, int maxNumAccounts) {
        return new TableAccountMeta(lookupTable, maxNumAccounts);
    }

    public static LookupTableAccountMeta[] createMetas(AddressLookupTable[] lookupTables, int maxNumAccounts) {
        LookupTableAccountMeta[] tableAccountMetas = new LookupTableAccountMeta[lookupTables.length];
        for (int i = 0; i < lookupTables.length; ++i) {
            tableAccountMetas[i] = LookupTableAccountMeta.createMeta(lookupTables[i], maxNumAccounts);
        }
        return tableAccountMetas;
    }

    public static LookupTableAccountMeta[] createMetas(Collection<AddressLookupTable> lookupTables, int maxNumAccounts) {
        int numTables = lookupTables.size();
        LookupTableAccountMeta[] tableAccountMetas = new LookupTableAccountMeta[numTables];
        int i = 0;
        for (AddressLookupTable lookupTable : lookupTables) {
            tableAccountMetas[i++] = LookupTableAccountMeta.createMeta(lookupTable, maxNumAccounts);
        }
        return tableAccountMetas;
    }

    public static LookupTableAccountMeta createMeta(AddressLookupTable lookupTable) {
        return new TableAccountMeta(lookupTable, 256);
    }

    public static LookupTableAccountMeta[] createMetas(AddressLookupTable[] lookupTables) {
        return LookupTableAccountMeta.createMetas(lookupTables, 256);
    }

    public static LookupTableAccountMeta[] createMetas(Collection<AddressLookupTable> lookupTables) {
        return LookupTableAccountMeta.createMetas(lookupTables, 256);
    }

    public AddressLookupTable lookupTable();

    public boolean addAccountIfExists(AccountMeta var1);

    public int indexWrites(AccountIndexLookupTableEntry[] var1, int var2);

    public int indexReads(AccountIndexLookupTableEntry[] var1, int var2);

    public int indexWrites(Map<PublicKey, Integer> var1, int var2);

    public int indexReads(Map<PublicKey, Integer> var1, int var2);

    public void reset();

    public int numIndexed();

    public int serialize(byte[] var1, int var2);
}

