/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.accounts.meta;

import java.util.Map;
import software.sava.core.accounts.PublicKey;
import software.sava.core.accounts.lookup.AccountIndexLookupTableEntry;
import software.sava.core.accounts.lookup.AddressLookupTable;
import software.sava.core.accounts.meta.AccountMeta;
import software.sava.core.accounts.meta.LookupTableAccountMeta;
import software.sava.core.encoding.CompactU16Encoding;

final class TableAccountMeta
implements LookupTableAccountMeta {
    private final AddressLookupTable lookupTable;
    private final byte[] writeAccounts;
    private final byte[] readAccounts;
    private int numWrites;
    private int numReads;

    TableAccountMeta(AddressLookupTable lookupTable, int maxAccounts) {
        this.lookupTable = lookupTable;
        this.writeAccounts = new byte[maxAccounts];
        this.readAccounts = new byte[maxAccounts];
    }

    @Override
    public AddressLookupTable lookupTable() {
        return this.lookupTable;
    }

    public int indexOf(PublicKey publicKey) {
        return this.lookupTable.indexOf(publicKey);
    }

    @Override
    public boolean addAccountIfExists(AccountMeta account) {
        int index = this.indexOf(account.publicKey());
        if (index < 0) {
            return false;
        }
        if (account.write()) {
            this.writeAccounts[this.numWrites++] = (byte)index;
        } else {
            this.readAccounts[this.numReads++] = (byte)index;
        }
        return true;
    }

    private AccountIndexLookupTableEntry createAccountIndexLookupTableEntry(int index, int i) {
        return new AccountIndexLookupTableEntry(this.lookupTable.account(index).toByteArray(), i);
    }

    @Override
    public int indexWrites(AccountIndexLookupTableEntry[] accountIndexLookupTable, int i) {
        int w = 0;
        while (w < this.numWrites) {
            accountIndexLookupTable[i] = this.createAccountIndexLookupTableEntry(this.writeAccounts[w] & 0xFF, i);
            ++w;
            ++i;
        }
        return i;
    }

    @Override
    public int indexReads(AccountIndexLookupTableEntry[] accountIndexLookupTable, int i) {
        int r = 0;
        while (r < this.numReads) {
            accountIndexLookupTable[i] = this.createAccountIndexLookupTableEntry(this.readAccounts[r] & 0xFF, i);
            ++r;
            ++i;
        }
        return i;
    }

    @Override
    public int indexWrites(Map<PublicKey, Integer> accountIndexLookupTable, int i) {
        int w = 0;
        while (w < this.numWrites) {
            accountIndexLookupTable.put(this.lookupTable.account(this.writeAccounts[w] & 0xFF), i);
            ++w;
            ++i;
        }
        return i;
    }

    @Override
    public int indexReads(Map<PublicKey, Integer> accountIndexLookupTable, int i) {
        int r = 0;
        while (r < this.numReads) {
            accountIndexLookupTable.put(this.lookupTable.account(this.readAccounts[r] & 0xFF), i);
            ++r;
            ++i;
        }
        return i;
    }

    @Override
    public void reset() {
        this.numWrites = 0;
        this.numReads = 0;
    }

    @Override
    public int numIndexed() {
        return this.numReads + this.numWrites;
    }

    @Override
    public int serialize(byte[] out, int i) {
        i += this.lookupTable.address().write(out, i);
        i += CompactU16Encoding.encodeLength(out, i, this.numWrites);
        System.arraycopy(this.writeAccounts, 0, out, i, this.numWrites);
        i += this.numWrites;
        i += CompactU16Encoding.encodeLength(out, i, this.numReads);
        System.arraycopy(this.readAccounts, 0, out, i, this.numReads);
        return i += this.numReads;
    }
}

