/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.accounts.sysvar;

import java.math.BigInteger;
import java.util.function.BiFunction;
import software.sava.core.accounts.PublicKey;
import software.sava.core.borsh.Borsh;
import software.sava.core.encoding.ByteUtil;

public record EpochRewards(PublicKey address, long distributionStartingBlockHeight, long numPartitions, byte[] parentBlockHash, BigInteger totalPoints, long totalRewards, long distributedRewards, boolean active) implements Borsh
{
    public static final int BYTES = 81;
    public static final BiFunction<PublicKey, byte[], EpochRewards> FACTORY = EpochRewards::read;

    public static EpochRewards read(byte[] data) {
        return EpochRewards.read(data, 0);
    }

    public static EpochRewards read(byte[] data, int offset) {
        return EpochRewards.read(null, data, offset);
    }

    public static EpochRewards read(PublicKey address, byte[] data) {
        return EpochRewards.read(address, data, 0);
    }

    public static EpochRewards read(PublicKey address, byte[] data, int offset) {
        long distributionStartingBlockHeight = ByteUtil.getInt64LE(data, offset);
        long numPartitions = ByteUtil.getInt64LE(data, offset += 8);
        byte[] parentBlockHash = new byte[32];
        System.arraycopy(data, offset += 8, parentBlockHash, 0, 32);
        BigInteger totalPoints = ByteUtil.getInt128LE(data, offset += 32);
        long totalRewards = ByteUtil.getInt64LE(data, offset += 16);
        long distributedRewards = ByteUtil.getInt64LE(data, offset += 8);
        return new EpochRewards(address, distributionStartingBlockHeight, numPartitions, parentBlockHash, totalPoints, totalRewards, distributedRewards, data[++offset] == 1);
    }

    @Override
    public int write(byte[] data, int offset) {
        int i = offset;
        ByteUtil.putInt64LE(data, i, this.distributionStartingBlockHeight);
        ByteUtil.putInt64LE(data, i += 8, this.numPartitions);
        System.arraycopy(this.parentBlockHash, 0, data, i += 8, 32);
        ByteUtil.putInt128LE(data, i += 32, this.totalPoints);
        ByteUtil.putInt64LE(data, i += 16, this.totalRewards);
        ByteUtil.putInt64LE(data, i += 8, this.distributedRewards);
        data[i += 8] = (byte)(this.active ? 1 : 0);
        return ++i - offset;
    }

    @Override
    public int l() {
        return 81;
    }
}

