/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.accounts.token;

import java.util.EnumMap;
import java.util.Map;
import java.util.function.BiFunction;
import software.sava.core.accounts.PublicKey;
import software.sava.core.accounts.token.Mint;
import software.sava.core.accounts.token.extensions.AccountType;
import software.sava.core.accounts.token.extensions.ConfidentialMintBurn;
import software.sava.core.accounts.token.extensions.ConfidentialTransferAccount;
import software.sava.core.accounts.token.extensions.ConfidentialTransferFeeAmount;
import software.sava.core.accounts.token.extensions.ConfidentialTransferFeeConfig;
import software.sava.core.accounts.token.extensions.ConfidentialTransferMint;
import software.sava.core.accounts.token.extensions.CpiGuard;
import software.sava.core.accounts.token.extensions.DefaultAccountState;
import software.sava.core.accounts.token.extensions.ExtensionType;
import software.sava.core.accounts.token.extensions.GroupMemberPointer;
import software.sava.core.accounts.token.extensions.GroupPointer;
import software.sava.core.accounts.token.extensions.ImmutableOwner;
import software.sava.core.accounts.token.extensions.InterestBearingConfig;
import software.sava.core.accounts.token.extensions.MemoTransfer;
import software.sava.core.accounts.token.extensions.MetadataPointer;
import software.sava.core.accounts.token.extensions.MintCloseAuthority;
import software.sava.core.accounts.token.extensions.NonTransferable;
import software.sava.core.accounts.token.extensions.NonTransferableAccount;
import software.sava.core.accounts.token.extensions.PausableAccount;
import software.sava.core.accounts.token.extensions.PausableConfig;
import software.sava.core.accounts.token.extensions.PermanentDelegate;
import software.sava.core.accounts.token.extensions.ScaledUiAmountConfig;
import software.sava.core.accounts.token.extensions.TokenExtension;
import software.sava.core.accounts.token.extensions.TokenGroup;
import software.sava.core.accounts.token.extensions.TokenGroupMember;
import software.sava.core.accounts.token.extensions.TokenMetadata;
import software.sava.core.accounts.token.extensions.TransferFeeAmount;
import software.sava.core.accounts.token.extensions.TransferFeeConfig;
import software.sava.core.accounts.token.extensions.TransferHook;
import software.sava.core.accounts.token.extensions.TransferHookAccount;
import software.sava.core.accounts.token.extensions.Uninitialized;
import software.sava.core.encoding.ByteUtil;
import software.sava.core.serial.Serializable;

public record Token2022(Mint mint, AccountType accountType, Map<ExtensionType, TokenExtension> extensions) implements Serializable
{
    private static final int PADDING_AFTER_MINT = 83;
    public static final BiFunction<PublicKey, byte[], Token2022> FACTORY = Token2022::read;

    static Map<ExtensionType, TokenExtension> parseExtensions(byte[] data, int offset) {
        short length;
        EnumMap<ExtensionType, TokenExtension> extensions = new EnumMap<ExtensionType, TokenExtension>(ExtensionType.class);
        ExtensionType[] extensionTypes = ExtensionType.values();
        for (int i = offset; i < data.length; i += length) {
            Record extensionData;
            short extensionType = ByteUtil.getInt16LE(data, i);
            length = ByteUtil.getInt16LE(data, i += 2);
            i += 2;
            ExtensionType type = extensionTypes[extensionType];
            switch (type) {
                default: {
                    throw new MatchException(null, null);
                }
                case Uninitialized: {
                    Record record = Uninitialized.INSTANCE;
                    break;
                }
                case TransferFeeConfig: {
                    Record record = TransferFeeConfig.read(data, i);
                    break;
                }
                case TransferFeeAmount: {
                    Record record = TransferFeeAmount.read(data, i);
                    break;
                }
                case MintCloseAuthority: {
                    Record record = MintCloseAuthority.read(data, i);
                    break;
                }
                case ConfidentialTransferMint: {
                    Record record = ConfidentialTransferMint.read(data, i);
                    break;
                }
                case ConfidentialTransferAccount: {
                    Record record = ConfidentialTransferAccount.read(data, i);
                    break;
                }
                case DefaultAccountState: {
                    Record record = DefaultAccountState.read(data, i);
                    break;
                }
                case ImmutableOwner: {
                    Record record = ImmutableOwner.INSTANCE;
                    break;
                }
                case MemoTransfer: {
                    Record record = MemoTransfer.read(data, i);
                    break;
                }
                case NonTransferable: {
                    Record record = NonTransferable.INSTANCE;
                    break;
                }
                case InterestBearingConfig: {
                    Record record = InterestBearingConfig.read(data, i);
                    break;
                }
                case CpiGuard: {
                    Record record = CpiGuard.read(data, i);
                    break;
                }
                case PermanentDelegate: {
                    Record record = PermanentDelegate.read(data, i);
                    break;
                }
                case NonTransferableAccount: {
                    Record record = NonTransferableAccount.INSTANCE;
                    break;
                }
                case TransferHook: {
                    Record record = TransferHook.read(data, i);
                    break;
                }
                case TransferHookAccount: {
                    Record record = TransferHookAccount.read(data, i);
                    break;
                }
                case ConfidentialTransferFeeConfig: {
                    Record record = ConfidentialTransferFeeConfig.read(data, i, i + length);
                    break;
                }
                case ConfidentialTransferFeeAmount: {
                    Record record = ConfidentialTransferFeeAmount.read(data, i, i + length);
                    break;
                }
                case MetadataPointer: {
                    Record record = MetadataPointer.read(data, i);
                    break;
                }
                case TokenMetadata: {
                    Record record = TokenMetadata.read(data, i);
                    break;
                }
                case GroupPointer: {
                    Record record = GroupPointer.read(data, i);
                    break;
                }
                case TokenGroup: {
                    Record record = TokenGroup.INSTANCE;
                    break;
                }
                case GroupMemberPointer: {
                    Record record = GroupMemberPointer.read(data, i);
                    break;
                }
                case TokenGroupMember: {
                    Record record = TokenGroupMember.INSTANCE;
                    break;
                }
                case ConfidentialMintBurn: {
                    Record record = ConfidentialMintBurn.read(data, i);
                    break;
                }
                case ScaledUiAmount: {
                    Record record = ScaledUiAmountConfig.read(data, i);
                    break;
                }
                case Pausable: {
                    Record record = PausableConfig.read(data, i);
                    break;
                }
                case PausableAccount: {
                    Record record = extensionData = PausableAccount.INSTANCE;
                }
            }
            if (extensionData == null) continue;
            extensions.put(type, (TokenExtension)((Object)extensionData));
        }
        return extensions;
    }

    static AccountType parseAccountType(byte[] data, int offset) {
        int ordinal = data[offset] & 0xFF;
        AccountType[] accountTypes = AccountType.values();
        return ordinal < accountTypes.length ? accountTypes[ordinal] : null;
    }

    public static Token2022 read(PublicKey address, byte[] data) {
        if (data == null || data.length == 0) {
            return null;
        }
        Mint mint = Mint.read(address, data);
        int i = 165;
        AccountType accountType = Token2022.parseAccountType(data, i);
        Map<ExtensionType, TokenExtension> extensions = Token2022.parseExtensions(data, ++i);
        return new Token2022(mint, accountType, extensions);
    }

    @Override
    public int l() {
        int l = 166 + this.extensions.size() * 4;
        for (TokenExtension extension : this.extensions.values()) {
            l += extension.l();
        }
        return l;
    }

    @Override
    public int write(byte[] data, int offset) {
        int i = offset + this.mint.write(data, offset) + 83;
        data[i] = (byte)this.accountType.ordinal();
        ++i;
        for (TokenExtension extension : this.extensions.values()) {
            i += TokenExtension.write(extension, data, i);
        }
        return i - offset;
    }
}

