/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.accounts.token;

import java.util.function.BiFunction;
import software.sava.core.accounts.PublicKey;
import software.sava.core.accounts.token.AccountState;
import software.sava.core.borsh.Borsh;
import software.sava.core.encoding.ByteUtil;
import software.sava.core.rpc.Filter;

public record TokenAccount(PublicKey address, PublicKey mint, PublicKey owner, long amount, int delegateOption, PublicKey delegate, AccountState state, int isNativeOption, long isNative, long delegatedAmount, int closeAuthorityOption, PublicKey closeAuthority) implements Borsh
{
    public static final int BYTES = 165;
    public static final Filter TOKEN_ACCOUNT_SIZE_FILTER = Filter.createDataSizeFilter(165);
    public static final int MINT_OFFSET = 0;
    public static final int OWNER_OFFSET = 32;
    public static final int AMOUNT_OFFSET = 64;
    public static final int DELEGATE_OPTION_OFFSET = 72;
    public static final int DELEGATE_OFFSET = 76;
    public static final int STATE_OFFSET = 108;
    public static final int IS_NATIVE_OPTION_OFFSET = 109;
    public static final int IS_NATIVE_OFFSET = 113;
    public static final int DELEGATED_AMOUNT_OFFSET = 121;
    public static final int CLOSE_AUTHORITY_OPTION_OFFSET = 129;
    public static final int CLOSE_AUTHORITY_OFFSET = 133;
    public static final BiFunction<PublicKey, byte[], TokenAccount> FACTORY = TokenAccount::read;

    public static Filter createMintFilter(PublicKey mint) {
        return Filter.createMemCompFilter(0, mint);
    }

    public static Filter createOwnerFilter(PublicKey owner) {
        return Filter.createMemCompFilter(32, owner);
    }

    public static Filter createDelegateFilter(PublicKey delegate) {
        return Filter.createMemCompFilter(76, delegate);
    }

    public static Filter createCloseAuthorityFilter(PublicKey closeAuthority) {
        return Filter.createMemCompFilter(133, closeAuthority);
    }

    public static TokenAccount read(PublicKey publicKey, byte[] data) {
        return TokenAccount.read(publicKey, data, 0);
    }

    public static TokenAccount read(PublicKey publicKey, byte[] data, int offset) {
        int i = offset;
        PublicKey mint = PublicKey.readPubKey(data, i);
        PublicKey owner = PublicKey.readPubKey(data, i += 32);
        long amount = ByteUtil.getInt64LE(data, i += 32);
        int delegateOption = ByteUtil.getInt32LE(data, i += 8);
        PublicKey delegate = delegateOption == 1 ? PublicKey.readPubKey(data, i += 4) : null;
        AccountState state = AccountState.values()[data[i += 32]];
        int isNativeOption = ByteUtil.getInt32LE(data, ++i);
        long isNative = isNativeOption == 1 ? ByteUtil.getInt64LE(data, i += 4) : 0L;
        long delegatedAmount = ByteUtil.getInt64LE(data, i += 8);
        int closeAuthorityOption = ByteUtil.getInt32LE(data, i += 8);
        PublicKey closeAuthority = closeAuthorityOption == 1 ? PublicKey.readPubKey(data, i += 4) : null;
        return new TokenAccount(publicKey, mint, owner, amount, delegateOption, delegate, state, isNativeOption, isNative, delegatedAmount, closeAuthorityOption, closeAuthority);
    }

    @Override
    public int write(byte[] data, int offset) {
        int i = offset;
        i += this.mint.write(data, i);
        i += this.owner.write(data, i);
        ByteUtil.putInt64LE(data, i, this.amount);
        ByteUtil.putInt32LE(data, i += 8, this.delegateOption);
        i += 4;
        i += this.delegate.write(data, i);
        data[i] = (byte)this.state.ordinal();
        ByteUtil.putInt32LE(data, ++i, this.isNativeOption);
        ByteUtil.putInt64LE(data, i += 4, this.isNative);
        ByteUtil.putInt64LE(data, i += 8, this.delegatedAmount);
        ByteUtil.putInt32LE(data, i += 8, this.closeAuthorityOption);
        i += 4;
        i += this.closeAuthority.write(data, i);
        return i - offset;
    }

    @Override
    public int l() {
        return 165;
    }
}

