/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.accounts.token.extensions;

import software.sava.core.accounts.PublicKey;
import software.sava.core.accounts.token.extensions.ExtensionType;
import software.sava.core.accounts.token.extensions.MintTokenExtension;

public record ConfidentialMintBurn(byte[] confidentialSupply, byte[] decryptableSupply, PublicKey supplyElGamalPubKey, byte[] pendingBurn) implements MintTokenExtension
{
    public static final int BYTES = 196;

    public static ConfidentialMintBurn read(byte[] data, int offset) {
        if (data == null || data.length == 0) {
            return null;
        }
        int i = offset;
        byte[] confidentialSupply = new byte[64];
        System.arraycopy(data, i, confidentialSupply, 0, confidentialSupply.length);
        byte[] decryptableSupply = new byte[36];
        System.arraycopy(data, i += confidentialSupply.length, decryptableSupply, 0, decryptableSupply.length);
        PublicKey supplyElGamalPubKey = PublicKey.readPubKey(data, i += decryptableSupply.length);
        byte[] pendingBurn = new byte[64];
        System.arraycopy(data, i += 32, pendingBurn, 0, pendingBurn.length);
        i += pendingBurn.length;
        return new ConfidentialMintBurn(confidentialSupply, decryptableSupply, supplyElGamalPubKey, pendingBurn);
    }

    @Override
    public ExtensionType extensionType() {
        return ExtensionType.ConfidentialMintBurn;
    }

    @Override
    public int write(byte[] data, int offset) {
        int i = offset;
        System.arraycopy(this.confidentialSupply, 0, data, i, this.confidentialSupply.length);
        System.arraycopy(this.decryptableSupply, 0, data, i += this.confidentialSupply.length, this.decryptableSupply.length);
        this.supplyElGamalPubKey.write(data, i += this.decryptableSupply.length);
        System.arraycopy(this.pendingBurn, 0, data, i += 32, this.pendingBurn.length);
        return 196;
    }

    @Override
    public int l() {
        return 196;
    }
}

