/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.accounts.token.extensions;

import software.sava.core.accounts.PublicKey;
import software.sava.core.accounts.token.extensions.ExtensionType;
import software.sava.core.accounts.token.extensions.MintTokenExtension;

public record ConfidentialTransferFeeConfig(PublicKey authority, PublicKey withdrawWithheldAuthorityElgamalPubkey, boolean harvestToMintEnabled, byte[] withheldAmount) implements MintTokenExtension
{
    public static ConfidentialTransferFeeConfig read(byte[] data, int offset, int to) {
        if (data == null || data.length == 0) {
            return null;
        }
        PublicKey authority = PublicKey.readPubKey(data, offset);
        int i = offset + 32;
        PublicKey withdrawWithheldAuthorityElgamalPubkey = PublicKey.readPubKey(data, i);
        boolean harvestToMintEnabled = data[i += 32] == 1;
        byte[] withheldAmount = new byte[to - ++i];
        System.arraycopy(data, i, withheldAmount, 0, withheldAmount.length);
        return new ConfidentialTransferFeeConfig(authority, withdrawWithheldAuthorityElgamalPubkey, harvestToMintEnabled, withheldAmount);
    }

    @Override
    public ExtensionType extensionType() {
        return ExtensionType.ConfidentialTransferFeeConfig;
    }

    @Override
    public int write(byte[] data, int offset) {
        this.authority.write(data, offset);
        int i = offset + 32;
        i += this.withdrawWithheldAuthorityElgamalPubkey.write(data, i);
        data[i] = (byte)(this.harvestToMintEnabled ? 1 : 0);
        System.arraycopy(this.withheldAmount, 0, data, ++i, this.withheldAmount.length);
        return (i += this.withheldAmount.length) - offset;
    }

    @Override
    public int l() {
        return 65 + this.withheldAmount.length;
    }
}

