/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.accounts.token.extensions;

import software.sava.core.accounts.PublicKey;
import software.sava.core.accounts.token.extensions.ExtensionType;
import software.sava.core.accounts.token.extensions.MintTokenExtension;
import software.sava.core.encoding.ByteUtil;

public record ScaledUiAmountConfig(PublicKey authority, double multiplier, long newMultiplierEffectiveTimestamp, double newMultiplier) implements MintTokenExtension
{
    public static final int BYTES = 56;

    public static ScaledUiAmountConfig read(byte[] data, int offset) {
        if (data == null || data.length == 0) {
            return null;
        }
        PublicKey authority = PublicKey.readPubKey(data, offset);
        int i = offset + 32;
        double multiplier = ByteUtil.getFloat64LE(data, i);
        long newMultiplierEffectiveTimestamp = ByteUtil.getInt64LE(data, i += 8);
        double newMultiplier = ByteUtil.getFloat64LE(data, i += 8);
        return new ScaledUiAmountConfig(authority, multiplier, newMultiplierEffectiveTimestamp, newMultiplier);
    }

    @Override
    public ExtensionType extensionType() {
        return ExtensionType.ScaledUiAmount;
    }

    @Override
    public int l() {
        return 56;
    }

    @Override
    public int write(byte[] data, int offset) {
        this.authority.write(data, offset);
        int i = offset + 32;
        ByteUtil.putFloat64LE(data, i, this.multiplier);
        ByteUtil.putInt64LE(data, i += 8, this.newMultiplierEffectiveTimestamp);
        ByteUtil.putFloat64LE(data, i += 8, this.newMultiplier);
        return 56;
    }
}

