/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.accounts.token.extensions;

import java.util.Map;
import software.sava.core.accounts.PublicKey;
import software.sava.core.accounts.token.extensions.ExtensionType;
import software.sava.core.accounts.token.extensions.MintTokenExtension;
import software.sava.core.borsh.Borsh;
import software.sava.core.encoding.ByteUtil;

public record TokenMetadata(PublicKey updateAuthority, PublicKey mint, String name, String symbol, String uri, Map<String, String> additionalMetadata) implements MintTokenExtension
{
    public static TokenMetadata read(byte[] data, int offset) {
        Map<String, String> additionalMetadata;
        if (data == null || data.length == 0) {
            return null;
        }
        int i = offset;
        PublicKey updateAuthority = PublicKey.readPubKey(data, i);
        PublicKey mint = PublicKey.readPubKey(data, i += 32);
        int nameLength = ByteUtil.getInt32LE(data, i += 32);
        String name = new String(data, i += 4, nameLength);
        int symbolLength = ByteUtil.getInt32LE(data, i += nameLength);
        String symbol = new String(data, i += 4, symbolLength);
        int uriLength = ByteUtil.getInt32LE(data, i += symbolLength);
        String uri = new String(data, i += 4, uriLength);
        int numExtras = ByteUtil.getInt32LE(data, i += uriLength);
        i += 4;
        if (numExtras == 0) {
            additionalMetadata = Map.of();
        } else {
            Map.Entry[] entries = new Map.Entry[numExtras];
            for (int m = 0; m < numExtras; ++m) {
                int l = ByteUtil.getInt32LE(data, i);
                String key = new String(data, i += 4, l);
                i += l;
                l = ByteUtil.getInt32LE(data, i);
                String val = new String(data, i += 4, l);
                i += l;
                entries[m] = Map.entry(key, val);
            }
            additionalMetadata = Map.ofEntries(entries);
        }
        return new TokenMetadata(updateAuthority, mint, name, symbol, uri, additionalMetadata);
    }

    @Override
    public ExtensionType extensionType() {
        return ExtensionType.TokenMetadata;
    }

    @Override
    public int l() {
        int additionalMetaDataLength = 4 + 8 * this.additionalMetadata.size() + this.additionalMetadata.entrySet().stream().mapToInt(entry -> ((String)entry.getKey()).length() + ((String)entry.getValue()).length()).sum();
        return 68 + this.name.length() + 4 + this.symbol.length() + 4 + this.uri.length() + additionalMetaDataLength;
    }

    @Override
    public int write(byte[] data, int offset) {
        this.updateAuthority.write(data, offset);
        int i = offset + 32;
        this.mint.write(data, i);
        i += 32;
        i += Borsh.write(this.name, data, i);
        i += Borsh.write(this.symbol, data, i);
        i += Borsh.write(this.uri, data, i);
        ByteUtil.putInt32LE(data, i, this.additionalMetadata.size());
        i += 4;
        for (Map.Entry<String, String> entry : this.additionalMetadata.entrySet()) {
            i += Borsh.write(entry.getKey(), data, i);
            i += Borsh.write(entry.getValue(), data, i);
        }
        return i - offset;
    }
}

