/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.accounts.token.extensions;

import software.sava.core.accounts.PublicKey;
import software.sava.core.accounts.token.extensions.ExtensionType;
import software.sava.core.accounts.token.extensions.MintTokenExtension;
import software.sava.core.accounts.token.extensions.TransferFee;
import software.sava.core.encoding.ByteUtil;

public record TransferFeeConfig(PublicKey transferFeeConfigAuthority, PublicKey withdrawWithheldAuthority, long withheldAmount, TransferFee olderTransferFee, TransferFee newerTransferFee) implements MintTokenExtension
{
    public static final int BYTES = 108;

    public static TransferFeeConfig read(byte[] data, int offset) {
        if (data == null || data.length == 0) {
            return null;
        }
        int i = offset;
        PublicKey transferFeeConfigAuthority = PublicKey.readPubKey(data, i);
        PublicKey withdrawWithheldAuthority = PublicKey.readPubKey(data, i += 32);
        long withheldAmount = ByteUtil.getInt64LE(data, i += 32);
        TransferFee olderTransferFee = TransferFee.read(data, i += 8);
        TransferFee newerTransferFee = TransferFee.read(data, i += olderTransferFee.l());
        return new TransferFeeConfig(transferFeeConfigAuthority, withdrawWithheldAuthority, withheldAmount, olderTransferFee, newerTransferFee);
    }

    @Override
    public ExtensionType extensionType() {
        return ExtensionType.TransferFeeConfig;
    }

    @Override
    public int l() {
        return 108;
    }

    @Override
    public int write(byte[] data, int offset) {
        this.transferFeeConfigAuthority.write(data, offset);
        int i = offset + 32;
        this.withdrawWithheldAuthority.write(data, offset);
        ByteUtil.putInt64LE(data, i += 32, this.withheldAmount);
        i += 8;
        i += this.olderTransferFee.write(data, i);
        this.newerTransferFee.write(data, i);
        return 108;
    }
}

