/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.accounts.vanity;

import java.util.Arrays;
import software.sava.core.accounts.vanity.SubsequenceRecord;
import software.sava.core.encoding.Base58;

public interface Subsequence {
    public static Subsequence create(String subsequence, boolean caseSensitive, boolean _1337Numbers, boolean _1337Letters) {
        if (subsequence.isBlank()) {
            return null;
        }
        int noneBase58Character = Base58.nonBase58(subsequence);
        if (noneBase58Character >= 0) {
            throw new IllegalArgumentException(String.format("'%c' is not a base58 character.", Character.valueOf(subsequence.charAt(noneBase58Character))));
        }
        char[][] charOptions = SubsequenceRecord.generateCharOptions(subsequence, caseSensitive, _1337Numbers, _1337Letters);
        System.out.println("Character options:");
        for (int level = 0; level < 3; ++level) {
            System.out.print("  ");
            for (char[] options : charOptions) {
                if (options.length > level) {
                    System.out.print(options[level]);
                } else {
                    System.out.print('_');
                }
                System.out.print(' ');
            }
            System.out.println();
        }
        long[] masks = SubsequenceRecord.generateMasks(charOptions);
        Arrays.sort(masks);
        return new SubsequenceRecord(subsequence, subsequence.length(), caseSensitive, _1337Numbers, _1337Letters, masks);
    }

    public boolean contains(char[] var1, int var2);

    public String subsequence();

    public int length();

    public boolean caseSensitive();

    public boolean _1337Numbers();

    public boolean _1337Letters();

    public int numCombinations();
}

