/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.borsh;

import java.math.BigInteger;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import software.sava.core.accounts.PublicKey;
import software.sava.core.borsh.Borsh;
import software.sava.core.encoding.ByteUtil;

public interface RustEnum
extends Borsh {
    public int ordinal();

    default public String name() {
        return this.getClass().getSimpleName();
    }

    default public int writeOrdinal(byte[] data, int offset) {
        data[offset] = (byte)this.ordinal();
        return 1 + offset;
    }

    public static interface OptionalBorshEnum
    extends RustEnum {
        public Borsh val();

        @Override
        default public int l() {
            return 1 + Borsh.lenOptional(this.val());
        }

        @Override
        default public int write(byte[] data, int offset) {
            return 1 + Borsh.writeOptional(this.val(), data, this.writeOrdinal(data, offset));
        }
    }

    public static interface OptionalEnumPublicKey
    extends RustEnum {
        public PublicKey val();

        @Override
        default public int l() {
            return 1 + Borsh.lenOptional(this.val());
        }

        @Override
        default public int write(byte[] data, int offset) {
            return 1 + Borsh.writeOptional(this.val(), data, this.writeOrdinal(data, offset));
        }
    }

    public static interface OptionalEnumString
    extends OptionalEnumBytes {
        public String _val();
    }

    public static interface OptionalEnumBytes
    extends RustEnum {
        public byte[] val();

        @Override
        default public int l() {
            return 1 + Borsh.lenOptionalVector(this.val());
        }

        @Override
        default public int write(byte[] data, int offset) {
            return 1 + Borsh.writeOptionalVector(this.val(), data, this.writeOrdinal(data, offset));
        }
    }

    public static interface OptionalEnumInt256
    extends RustEnum {
        public BigInteger val();

        @Override
        default public int l() {
            return 1 + Borsh.len256Optional(this.val());
        }

        @Override
        default public int write(byte[] data, int offset) {
            return 1 + Borsh.write256Optional(this.val(), data, this.writeOrdinal(data, offset));
        }
    }

    public static interface OptionalEnumInt128
    extends RustEnum {
        public BigInteger val();

        @Override
        default public int l() {
            return 1 + Borsh.len128Optional(this.val());
        }

        @Override
        default public int write(byte[] data, int offset) {
            return 1 + Borsh.write128Optional(this.val(), data, this.writeOrdinal(data, offset));
        }
    }

    public static interface OptionalEnumInt64
    extends RustEnum {
        public OptionalLong val();

        @Override
        default public int l() {
            return 1 + Borsh.lenOptional(this.val());
        }

        @Override
        default public int write(byte[] data, int offset) {
            return 1 + Borsh.writeOptional(this.val(), data, this.writeOrdinal(data, offset));
        }
    }

    public static interface OptionalEnumInt32
    extends RustEnum {
        public OptionalInt val();

        @Override
        default public int l() {
            return 1 + Borsh.lenOptional(this.val());
        }

        @Override
        default public int write(byte[] data, int offset) {
            return 1 + Borsh.writeOptional(this.val(), data, this.writeOrdinal(data, offset));
        }
    }

    public static interface OptionalEnumInt16
    extends RustEnum {
        public OptionalInt val();

        @Override
        default public int l() {
            return 1 + Borsh.lenOptionalshort(this.val());
        }

        @Override
        default public int write(byte[] data, int offset) {
            return 1 + Borsh.writeOptionalshort(this.val(), data, this.writeOrdinal(data, offset));
        }
    }

    public static interface OptionalEnumInt8
    extends RustEnum {
        public OptionalInt val();

        @Override
        default public int l() {
            return 1 + Borsh.lenOptionalbyte(this.val());
        }

        @Override
        default public int write(byte[] data, int offset) {
            return 1 + Borsh.writeOptionalbyte(this.val(), data, this.writeOrdinal(data, offset));
        }
    }

    public static interface OptionalEnumFloat64
    extends RustEnum {
        public OptionalDouble val();

        @Override
        default public int l() {
            return 1 + Borsh.lenOptional(this.val());
        }

        @Override
        default public int write(byte[] data, int offset) {
            return 1 + Borsh.writeOptional(this.val(), data, this.writeOrdinal(data, offset));
        }
    }

    public static interface OptionalEnumFloat32
    extends RustEnum {
        public OptionalDouble val();

        @Override
        default public int l() {
            return 1 + Borsh.lenOptionalfloat(this.val());
        }

        @Override
        default public int write(byte[] data, int offset) {
            return 1 + Borsh.writeOptionalfloat(this.val(), data, this.writeOrdinal(data, offset));
        }
    }

    public static interface OptionalEnumBool
    extends RustEnum {
        public Boolean val();

        @Override
        default public int l() {
            return 1 + Borsh.lenOptional(this.val());
        }

        @Override
        default public int write(byte[] data, int offset) {
            return 1 + Borsh.writeOptional(this.val(), data, this.writeOrdinal(data, offset));
        }
    }

    public static interface PublicKeyArrayEnum
    extends RustEnum {
        public PublicKey[] val();

        @Override
        default public int l() {
            return 1 + Borsh.lenArray(this.val());
        }

        @Override
        default public int write(byte[] data, int offset) {
            return 1 + Borsh.writeArray(this.val(), data, this.writeOrdinal(data, offset));
        }
    }

    public static interface PublicKeyVectorEnum
    extends RustEnum {
        public PublicKey[] val();

        @Override
        default public int l() {
            return 1 + Borsh.lenVector(this.val());
        }

        @Override
        default public int write(byte[] data, int offset) {
            return 1 + Borsh.writeVector(this.val(), data, this.writeOrdinal(data, offset));
        }
    }

    public static interface BorshArrayEnum
    extends RustEnum {
        public Borsh[] val();

        @Override
        default public int l() {
            return 1 + Borsh.lenArray(this.val());
        }

        @Override
        default public int write(byte[] data, int offset) {
            return 1 + Borsh.writeArray(this.val(), data, this.writeOrdinal(data, offset));
        }
    }

    public static interface BorshVectorEnum
    extends RustEnum {
        public Borsh[] val();

        @Override
        default public int l() {
            return 1 + Borsh.lenVector(this.val());
        }

        @Override
        default public int write(byte[] data, int offset) {
            return 1 + Borsh.writeVector(this.val(), data, this.writeOrdinal(data, offset));
        }
    }

    public static interface BorshEnum
    extends RustEnum {
        public Borsh val();

        @Override
        default public int l() {
            return 1 + this.val().l();
        }

        @Override
        default public int write(byte[] data, int offset) {
            return 1 + this.val().write(data, this.writeOrdinal(data, offset));
        }
    }

    public static interface EnumPublicKey
    extends RustEnum {
        public PublicKey val();

        @Override
        default public int l() {
            return 33;
        }

        @Override
        default public int write(byte[] data, int offset) {
            return 1 + this.val().write(data, this.writeOrdinal(data, offset));
        }
    }

    public static interface EnumString
    extends EnumBytes {
        public String _val();
    }

    public static interface EnumBytes
    extends RustEnum {
        public byte[] val();

        @Override
        default public int l() {
            return 1 + Borsh.lenVector(this.val());
        }

        @Override
        default public int write(byte[] data, int offset) {
            return 1 + Borsh.writeVector(this.val(), data, this.writeOrdinal(data, offset));
        }
    }

    public static interface EnumInt256
    extends RustEnum {
        public BigInteger val();

        @Override
        default public int l() {
            return 257;
        }

        @Override
        default public int write(byte[] data, int offset) {
            return 1 + Borsh.write256(this.val(), data, this.writeOrdinal(data, offset));
        }
    }

    public static interface EnumInt128
    extends RustEnum {
        public BigInteger val();

        @Override
        default public int l() {
            return 129;
        }

        @Override
        default public int write(byte[] data, int offset) {
            return 1 + Borsh.write128(this.val(), data, this.writeOrdinal(data, offset));
        }
    }

    public static interface EnumInt64
    extends RustEnum {
        public long val();

        @Override
        default public int l() {
            return 9;
        }

        @Override
        default public int write(byte[] data, int offset) {
            ByteUtil.putInt64LE(data, this.writeOrdinal(data, offset), this.val());
            return this.l();
        }
    }

    public static interface EnumInt32
    extends RustEnum {
        public int val();

        @Override
        default public int l() {
            return 5;
        }

        @Override
        default public int write(byte[] data, int offset) {
            ByteUtil.putInt32LE(data, this.writeOrdinal(data, offset), this.val());
            return this.l();
        }
    }

    public static interface EnumInt16
    extends RustEnum {
        public int val();

        @Override
        default public int l() {
            return 3;
        }

        @Override
        default public int write(byte[] data, int offset) {
            ByteUtil.putInt16LE(data, this.writeOrdinal(data, offset), (short)this.val());
            return this.l();
        }
    }

    public static interface EnumInt8
    extends RustEnum {
        public int val();

        @Override
        default public int l() {
            return 2;
        }

        @Override
        default public int write(byte[] data, int offset) {
            data[this.writeOrdinal((byte[])data, (int)offset)] = (byte)this.val();
            return 2;
        }
    }

    public static interface EnumFloat64
    extends RustEnum {
        public double val();

        @Override
        default public int l() {
            return 9;
        }

        @Override
        default public int write(byte[] data, int offset) {
            ByteUtil.putFloat64LE(data, this.writeOrdinal(data, offset), this.val());
            return this.l();
        }
    }

    public static interface EnumFloat32
    extends RustEnum {
        public float val();

        @Override
        default public int l() {
            return 5;
        }

        @Override
        default public int write(byte[] data, int offset) {
            ByteUtil.putFloat32LE(data, this.writeOrdinal(data, offset), this.val());
            return this.l();
        }
    }

    public static interface EnumBool
    extends RustEnum {
        public boolean val();

        @Override
        default public int l() {
            return 2;
        }

        @Override
        default public int write(byte[] data, int offset) {
            this.writeOrdinal(data, offset);
            data[offset + 1] = (byte)(this.val() ? 1 : 0);
            return 2;
        }
    }

    public static interface EnumNone
    extends RustEnum {
        @Override
        default public int l() {
            return 1;
        }

        @Override
        default public int write(byte[] data, int offset) {
            return 1;
        }
    }
}

