/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.crypto;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;
import software.sava.core.crypto.SunCrypto;

public final class Hash {
    public static MessageDigest sha256Digest() {
        try {
            return MessageDigest.getInstance("SHA-256", SunCrypto.SUN_SECURITY_PROVIDER);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to find SHA-256", e);
        }
    }

    public static MessageDigest sha512Digest() {
        try {
            return MessageDigest.getInstance("SHA-512", SunCrypto.SUN_SECURITY_PROVIDER);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to find SHA-512", e);
        }
    }

    public static byte[] sha256(byte[] input) {
        return Hash.sha256Digest().digest(input);
    }

    public static byte[] sha256Twice(byte[] bytes) {
        return Hash.sha256Twice(bytes, 0, bytes.length);
    }

    public static byte[] sha256Twice(byte[] bytes, int offset, int length) {
        MessageDigest digest = Hash.sha256Digest();
        digest.update(bytes, offset, length);
        digest.update(digest.digest());
        return digest.digest();
    }

    public static byte[] h160(byte[] input) {
        byte[] sha256 = Hash.sha256(input);
        RIPEMD160Digest digest = new RIPEMD160Digest();
        digest.update(sha256, 0, sha256.length);
        byte[] out = new byte[20];
        digest.doFinal(out, 0);
        return out;
    }

    private Hash() {
    }
}

