/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.crypto;

import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.stream.Stream;

public final class SunCrypto {
    public static final Provider SUN_SECURITY_PROVIDER = Stream.of(Security.getProviders()).filter(p -> p.getName().equals("SUN")).findFirst().orElseThrow();
    public static final Provider SUN_JCE_PROVIDER = Stream.of(Security.getProviders()).filter(p -> p.getName().equals("SunJCE")).findFirst().orElseThrow();
    public static final Provider SUN_EC_PROVIDER = Stream.of(Security.getProviders()).filter(p -> p.getName().equals("SunEC")).findFirst().orElseThrow();
    public static final SecureRandom SECURE_RANDOM;
    public static final KeyFactory EdDSA_KEY_FACTORY;
    public static final KeyFactory ED_25519_KEY_FACTORY;

    private SunCrypto() {
    }

    static {
        try {
            SECURE_RANDOM = SecureRandom.getInstanceStrong();
            EdDSA_KEY_FACTORY = KeyFactory.getInstance("EdDSA", SUN_EC_PROVIDER);
            ED_25519_KEY_FACTORY = KeyFactory.getInstance("Ed25519", SUN_EC_PROVIDER);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

