/*
 * Decompiled with CFR 0.152.
 */
package software.sava.core.encoding;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.math.BigInteger;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public final class ByteUtil {
    private static final VarHandle SHORT_LE = MethodHandles.byteArrayViewVarHandle(short[].class, ByteOrder.LITTLE_ENDIAN);
    private static final VarHandle INT_LE = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.LITTLE_ENDIAN);
    private static final VarHandle LONG_LE = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.LITTLE_ENDIAN);
    private static final VarHandle FLOAT_LE = MethodHandles.byteArrayViewVarHandle(float[].class, ByteOrder.LITTLE_ENDIAN);
    private static final VarHandle DOUBLE_LE = MethodHandles.byteArrayViewVarHandle(double[].class, ByteOrder.LITTLE_ENDIAN);

    public static void putInt16LE(byte[] b, int off, int val) {
        ByteUtil.putInt16LE(b, off, (short)val);
    }

    public static void putInt16LE(byte[] b, int off, short val) {
        SHORT_LE.set(b, off, val);
    }

    public static void putInt32LE(byte[] b, int off, int val) {
        INT_LE.set(b, off, val);
    }

    public static void putInt64LE(byte[] b, int off, long val) {
        LONG_LE.set(b, off, val);
    }

    public static void putFloat32LE(byte[] b, int off, double val) {
        ByteUtil.putFloat32LE(b, off, (float)val);
    }

    public static void putFloat32LE(byte[] b, int off, float val) {
        FLOAT_LE.set(b, off, val);
    }

    public static void putFloat64LE(byte[] b, int off, double val) {
        DOUBLE_LE.set(b, off, val);
    }

    public static float getFloat32LE(byte[] b, int off) {
        return FLOAT_LE.get(b, off);
    }

    public static double getFloat64LE(byte[] b, int off) {
        return DOUBLE_LE.get(b, off);
    }

    public static int getInt8LE(byte[] b, int off) {
        return b[off] & 0xFF;
    }

    public static short getInt16LE(byte[] b, int off) {
        return SHORT_LE.get(b, off);
    }

    public static int getInt32LE(byte[] b, int off) {
        return INT_LE.get(b, off);
    }

    public static long getInt64LE(byte[] b, int off) {
        return LONG_LE.get(b, off);
    }

    public static int putIntLE(byte[] data, int offset, BigInteger val, int byteSize) {
        int j = offset;
        byte[] be = val.toByteArray();
        int i = be.length - 1;
        while (i >= 0) {
            data[j] = be[i];
            --i;
            ++j;
        }
        if (be.length < byteSize) {
            int to = offset + byteSize;
            byte zero = (byte)(val.signum() < 0 ? -1 : 0);
            while (j < to) {
                data[j] = zero;
                ++j;
            }
        }
        return byteSize;
    }

    private static BigInteger getIntLE(byte[] data, int offset, int byteSize) {
        byte[] be = new byte[byteSize];
        int i = 0;
        int o = offset + (byteSize - 1);
        while (i < be.length) {
            be[i] = data[o];
            ++i;
            --o;
        }
        return new BigInteger(be);
    }

    private static BigInteger getUIntLE(byte[] data, int offset, int byteSize) {
        return ByteUtil.getIntLE(data, offset, byteSize);
    }

    public static int putInt128LE(byte[] data, int offset, BigInteger val) {
        return ByteUtil.putIntLE(data, offset, val, 16);
    }

    public static BigInteger getUInt128LE(byte[] data, int offset) {
        return ByteUtil.getUIntLE(data, offset, 16);
    }

    public static BigInteger getInt128LE(byte[] data, int offset) {
        return ByteUtil.getIntLE(data, offset, 16);
    }

    public static int putInt256LE(byte[] data, int offset, BigInteger val) {
        return ByteUtil.putIntLE(data, offset, val, 32);
    }

    public static BigInteger getUInt256LE(byte[] data, int offset) {
        return ByteUtil.getUIntLE(data, offset, 32);
    }

    public static BigInteger getInt256LE(byte[] data, int offset) {
        return ByteUtil.getIntLE(data, offset, 32);
    }

    public static int indexOf(byte[] data, int start, int end, byte[] sub, int subStart, int subEnd) {
        int len = subEnd - subStart;
        int from = start;
        for (int to = from + len; to <= end; ++to) {
            if (Arrays.equals(sub, subStart, subEnd, data, from, to)) {
                return from;
            }
            ++from;
        }
        return -1;
    }

    public static int indexOf(byte[] data, int start, byte[] sub, int subStart) {
        return ByteUtil.indexOf(data, start, data.length, sub, subStart, sub.length);
    }

    public static int indexOf(byte[] data, int start, byte[] sub) {
        return ByteUtil.indexOf(data, start, data.length, sub, 0, sub.length);
    }

    public static int indexOf(byte[] data, byte[] sub) {
        return ByteUtil.indexOf(data, 0, data.length, sub, 0, sub.length);
    }

    public static byte[] reverse(byte[] bytes, int offset, int len) {
        byte[] reversed = new byte[len];
        int i = offset;
        for (int j = offset + len - 1; j >= offset; --j) {
            reversed[j] = bytes[i];
            ++i;
        }
        return reversed;
    }

    public static byte[] reverse(byte[] bytes, int len) {
        return ByteUtil.reverse(bytes, 0, len);
    }

    public static byte[] reverse(byte[] bytes) {
        return ByteUtil.reverse(bytes, bytes.length);
    }

    public static byte[] fixedLength(byte[] bytes, int length) {
        if (bytes.length < length) {
            byte[] fixedBytes = new byte[length];
            System.arraycopy(bytes, 0, fixedBytes, 0, bytes.length);
            return fixedBytes;
        }
        if (bytes.length == length) {
            return bytes;
        }
        throw new IllegalArgumentException(String.format("Must be <= %s bytes", length));
    }

    public static byte[] fixedLength(String val, int length, Charset charset) {
        return ByteUtil.fixedLength(val.getBytes(charset), length);
    }

    public static byte[] fixedLength(String val, int length) {
        return ByteUtil.fixedLength(val, length, StandardCharsets.UTF_8);
    }

    private ByteUtil() {
    }
}

